/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.deprecated.pre61settings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.modules.editor.deprecated.pre61settings.EditorPreferencesInjector;
import org.netbeans.modules.editor.deprecated.pre61settings.OrgNbEditorAccessor;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.netbeans.modules.editor.settings.storage.spi.StorageFilter;

public final class KeybindingsInjector
extends StorageFilter<Collection<KeyStroke>, MultiKeyBinding>
implements PropertyChangeListener,
SettingsChangeListener {
    private static final Logger LOG = Logger.getLogger(EditorPreferencesInjector.class.getName());
    private final ThreadLocal<Map> currentSettingsMap = new ThreadLocal();
    private volatile int ourOwnChangeNotification = 0;
    private final ThreadLocal<Boolean> ignoreInitializerChanges = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public KeybindingsInjector() {
        super("Keybindings");
        OrgNbEditorAccessor.get().Settings_addPropertyChangeListener(this);
        OrgNbEditorAccessor.get().Settings_addSettingsChangeListener(this);
    }

    public void capturedSetValue(Class kitClass, String settingName, Object value) {
        Map map = this.currentSettingsMap.get();
        assert (map != null) : "The current settings map should not be null";
        map.put(settingName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLoad(Map<Collection<KeyStroke>, MultiKeyBinding> keybindings, MimePath mimePath, String profile, boolean defaults) {
        Class kitClass = null;
        if (mimePath.size() == 0) {
            kitClass = BaseKit.class;
        } else if (mimePath.size() == 1) {
            this.ignoreInitializerChanges.set(true);
            try {
                kitClass = KitsTracker.getInstance().findKitClass(mimePath.getPath());
            }
            finally {
                this.ignoreInitializerChanges.remove();
            }
        }
        if (kitClass == null) {
            return;
        }
        HashMap map = new HashMap();
        this.currentSettingsMap.set(map);
        try {
            List[] lists = OrgNbEditorAccessor.get().Settings_getListsOfInitializers();
            for (int i = 0; i < lists.length; ++i) {
                for (Settings.Initializer initializer : lists[i]) {
                    try {
                        initializer.updateSettingsMap(kitClass, map);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, null, t);
                    }
                }
            }
        }
        finally {
            this.currentSettingsMap.remove();
        }
        List legacyKeybindings = (List)map.get("key-bindings");
        if (legacyKeybindings != null) {
            for (org.netbeans.editor.MultiKeyBinding legacyMkb : legacyKeybindings) {
                MultiKeyBinding mkb;
                if (legacyMkb.actionName == null || legacyMkb.actionName.length() == 0 || legacyMkb.key == null && (legacyMkb.keys == null || legacyMkb.keys.length == 0)) continue;
                if (legacyMkb.keys != null) {
                    if (keybindings.containsKey(Arrays.asList(legacyMkb.keys))) continue;
                    mkb = new MultiKeyBinding(legacyMkb.keys, legacyMkb.actionName);
                    keybindings.put(mkb.getKeyStrokeList(), mkb);
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("Injecting: " + mkb.getKeyStrokeList() + " bound to '" + mkb.getActionName() + "' for '" + mimePath.getPath() + "', profile '" + profile + "'");
                    continue;
                }
                if (keybindings.containsKey(Collections.singleton(legacyMkb.key))) continue;
                mkb = new MultiKeyBinding(legacyMkb.key, legacyMkb.actionName);
                keybindings.put(mkb.getKeyStrokeList(), mkb);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Injecting: " + mkb.getKeyStrokeList() + " bound to '" + mkb.getActionName() + "' for '" + mimePath.getPath() + "', profile '" + profile + "'");
            }
        }
    }

    public void beforeSave(Map<Collection<KeyStroke>, MultiKeyBinding> map, MimePath mimePath, String profile, boolean defaults) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ((evt == null || "initializers".equals(evt.getPropertyName())) && !this.ignoreInitializerChanges.get().booleanValue()) {
            LOG.fine("Settings.Initializers changed");
            this.safeNotifyChanges();
        }
    }

    @Override
    public void settingsChange(SettingsChangeEvent evt) {
        if (evt.getSettingName() == null || "key-bindings".equals(evt.getSettingName()) || "custom-action-list".equals(evt.getSettingName())) {
            LOG.fine("settingsChange(" + evt.getSettingName() + ")");
            this.safeNotifyChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeNotifyChanges() {
        if (this.ourOwnChangeNotification == 0) {
            ++this.ourOwnChangeNotification;
            try {
                Settings.update(new Runnable(){

                    @Override
                    public void run() {
                        KeybindingsInjector.this.notifyChanges();
                    }

                    public boolean asynchronous() {
                        return true;
                    }
                });
            }
            finally {
                --this.ourOwnChangeNotification;
            }
        }
    }
}

