/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class HashMapHistogram
extends IteratingRule {
    private FieldAccess fldHMEKey;
    private FieldAccess fldHMENext;
    private FieldAccess fldHMEValue;
    private FieldAccess fldHMTable;
    private FieldAccess fldSValue;
    private Histogram<HashmapEntry> byIncomming;
    private JavaClass clsHM;
    private JavaClass clsHME;
    private JavaClass clsString;
    private Set<Instance> known = new HashSet<Instance>();

    public HashMapHistogram() {
        super(NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_Name"), NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_Desc"), "java.util.HashMap");
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_LongDesc");
    }

    @Override
    protected void perform(Instance hm) {
        HashmapEntry he = this.sizeOfHashmap(hm);
        String incomming = this.getContext().getRootIncommingString(hm);
        incomming = Utils.printClass(this.getContext(), incomming);
        this.byIncomming.add(incomming, he);
    }

    @Override
    protected void prepareRule(MemoryLint context) {
        Heap heap = context.getHeap();
        this.clsString = heap.getJavaClassByName("java.lang.String");
        this.clsHM = heap.getJavaClassByName("java.util.HashMap");
        this.clsHME = heap.getJavaClassByName("java.util.HashMap$Entry");
        this.fldSValue = new FieldAccess(this.clsString, "value");
        this.fldHMTable = new FieldAccess(this.clsHM, "table");
        this.fldHMEKey = new FieldAccess(this.clsHME, "key");
        this.fldHMEValue = new FieldAccess(this.clsHME, "value");
        this.fldHMENext = new FieldAccess(this.clsHME, "next");
        this.byIncomming = new Histogram();
    }

    @Override
    protected void summary() {
        this.getContext().appendResults(this.byIncomming.toString(50000));
    }

    private boolean add(Instance inst) {
        if (this.known.contains(inst)) {
            return false;
        }
        this.known.add(inst);
        return true;
    }

    private int sizeIfNewString(Instance obj) {
        if (obj == null) {
            return 0;
        }
        if ("java.lang.String".equals(obj.getJavaClass().getName()) && this.add(obj)) {
            int sz = obj.getSize();
            Instance arr = this.fldSValue.getRefValue(obj);
            if (arr != null && this.add(arr)) {
                sz += arr.getSize();
            }
            return sz;
        }
        return 0;
    }

    private HashmapEntry sizeOfHashmap(Instance hm) {
        ObjectArrayInstance table = (ObjectArrayInstance)this.fldHMTable.getRefValue(hm);
        int sum = hm.getSize() + table.getSize();
        int hmeCount = 0;
        int strCount = 0;
        List tval = table.getValues();
        for (Instance entry : tval) {
            while (entry != null) {
                ++hmeCount;
                sum += entry.getSize();
                int sz = this.sizeIfNewString(this.fldHMEKey.getRefValue(entry));
                if (sz != 0) {
                    ++strCount;
                }
                sum += sz;
                sz = this.sizeIfNewString(this.fldHMEValue.getRefValue(entry));
                if (sz != 0) {
                    ++strCount;
                }
                sum += sz;
                entry = this.fldHMENext.getRefValue(entry);
            }
        }
        HashmapEntry hme = new HashmapEntry(sum, hmeCount, strCount);
        return hme;
    }

    private static class HashmapEntry
    extends Histogram.Entry<HashmapEntry> {
        int hmeCount;
        int strCount;

        HashmapEntry(int size, int hmeCount, int strCount) {
            super(size);
            this.hmeCount = hmeCount;
            this.strCount = strCount;
        }

        @Override
        public String toString() {
            return "#:" + this.getCount() + "/" + this.getSize() + "B, " + this.hmeCount + " HMEs, " + this.strCount + " Strings<br>";
        }

        @Override
        protected void add(HashmapEntry source) {
            this.hmeCount += source.hmeCount;
            this.strCount += source.strCount;
        }
    }
}

