/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ExportAction
extends AbstractAction {
    private static final String EXPORT_ACTION_NAME = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportActionName");
    private static final String EXPORT_ACTION_DESCRIPTION = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportActionDescr");
    private static final String OVERWRITE_FILE_CAPTION = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OverwriteFileCaption");
    private static final String OVERWRITE_FILE_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OverwriteFileMsg");
    private static final String CANNOT_OVERWRITE_FILE_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_CannotOverwriteFileMsg");
    private static final String EXPORT_DIALOG_TITLE = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogTitle");
    private static final String EXPORT_DIALOG_BUTTON = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogButton");
    private static final String EXPORT_DIALOG_CSV_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogCSVFilter");
    private static final String EXPORT_DIALOG_EXCEL_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogExcelFilter");
    private static final String EXPORT_DIALOG_XML_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogXMLFilter");
    private static final String EXPORT_DIALOG_HTML_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogHTMLFilter");
    private static final String EXPORT_DIALOG_NPS_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogNPSFilter");
    private static final String NO_VIEW_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_NoViewMsg");
    private static final String EXPORTING_VIEW_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportingViewMsg");
    private static final String OOME_EXPORTING_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OomeExportingMsg");
    private static final String IOEXCEPTION_EXPORTING_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_IOException_Exporting_Msg");
    private static final String SNAPSHOT_CREATE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateFailedMsg");
    private static final ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/export.png", (boolean)false);
    private static final String FILE_EXTENSION_CSV = "csv";
    private static final String FILE_EXTENSION_XML = "xml";
    private static final String FILE_EXTENSION_HTML = "html";
    private static final String FILE_EXTENSION_NPS = "nps";
    public static final int MODE_CSV = 1;
    public static final int MODE_EXCEL = 2;
    public static final int MODE_XML = 3;
    public static final int MODE_HTML = 4;
    public static final int MODE_NPS = 5;
    private static File exportDir;
    private JFileChooser fileChooser;
    private ExportProvider exportProvider;
    private int exportedFileType;
    private LoadedSnapshot snapshot;

    public ExportAction(ExportProvider exportProvider, LoadedSnapshot loadedSnapshot) {
        this.putValue("Name", EXPORT_ACTION_NAME);
        this.putValue("ShortDescription", EXPORT_ACTION_DESCRIPTION);
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", "org/netbeans/modules/profiler/resources/export.png");
        this.exportProvider = exportProvider;
        if (loadedSnapshot != null) {
            this.snapshot = loadedSnapshot;
        }
    }

    private void setFilters() {
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
        if (this.exportProvider.hasExportableView()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_XML);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_XML_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_HTML);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_HTML_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_CSV);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_EXCEL_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_CSV);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_CSV_FILTER;
                }
            });
        }
        if (this.exportProvider.hasLoadedSnapshot()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_NPS);
                }

                @Override
                public String getDescription() {
                    return EXPORT_DIALOG_NPS_FILTER;
                }
            });
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(EXPORT_DIALOG_TITLE);
            this.fileChooser.setApproveButtonText(EXPORT_DIALOG_BUTTON);
        }
        this.fileChooser.resetChoosableFileFilters();
        this.setFilters();
        return this.fileChooser;
    }

    private boolean checkFileExists(File file) {
        if (file.exists()) {
            if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(OVERWRITE_FILE_CAPTION, file.getName()), OVERWRITE_FILE_CAPTION, 0)) != NotifyDescriptor.YES_OPTION) {
                return false;
            }
            if (!file.delete()) {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_OVERWRITE_FILE_MSG, file.getName()));
                return false;
            }
        }
        return true;
    }

    private SelectedFile selectExportTargetFile(ExportProvider exportProvider) {
        String targetName;
        File targetDir;
        String targetExt;
        int result;
        String defaultName = exportProvider.getViewName();
        JFileChooser chooser = this.getFileChooser();
        if (exportDir != null) {
            chooser.setCurrentDirectory(exportDir);
        }
        if ((result = chooser.showSaveDialog(IDEUtils.getMainWindow())) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (chooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_XML_FILTER)) {
            targetExt = FILE_EXTENSION_XML;
            this.exportedFileType = 3;
        } else if (chooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_HTML_FILTER)) {
            targetExt = FILE_EXTENSION_HTML;
            this.exportedFileType = 4;
        } else if (chooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_EXCEL_FILTER)) {
            targetExt = FILE_EXTENSION_CSV;
            this.exportedFileType = 2;
        } else if (chooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_NPS_FILTER)) {
            targetExt = FILE_EXTENSION_NPS;
            this.exportedFileType = 5;
        } else {
            targetExt = FILE_EXTENSION_CSV;
            this.exportedFileType = 1;
        }
        exportDir = chooser.getCurrentDirectory();
        if (file.isDirectory()) {
            targetDir = file;
            targetName = defaultName;
        } else {
            targetDir = exportDir;
            String fName = file.getName();
            int idx = fName.lastIndexOf(".");
            if (idx == -1) {
                targetName = fName;
            } else {
                targetName = fName.substring(0, idx);
                targetExt = fName.substring(idx + 1);
            }
        }
        return new SelectedFile(targetDir, targetName, targetExt);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        SelectedFile saveFile;
        if (!this.exportProvider.hasExportableView() && !this.exportProvider.hasLoadedSnapshot()) {
            NetBeansProfiler.getDefaultNB().displayError(NO_VIEW_MSG);
            return;
        }
        final LiveResultsWindow lrw = this.exportProvider instanceof LiveResultsWindow ? (LiveResultsWindow)this.exportProvider : null;
        final AppStatusHandler statusHandler = NetBeansProfiler.getDefaultNB().getTargetAppRunner().getAppStatusHandler();
        if (lrw != null) {
            statusHandler.pauseLiveUpdates();
        }
        if ((saveFile = this.selectExportTargetFile(this.exportProvider)) == null) {
            if (lrw != null) {
                statusHandler.resumeLiveUpdates();
            }
            return;
        }
        if (this.exportedFileType == 5) {
            File file = saveFile.getSelectedFile();
            if (!this.checkFileExists(file)) {
                return;
            }
            try {
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)saveFile.folder)).createData(saveFile.fileName, saveFile.fileExt);
                saveFile = null;
                ResultsManager.getDefault().saveSnapshot(this.snapshot, fo);
            }
            catch (IOException e1) {
                ErrorManager.getDefault().annotate((Throwable)e1, MessageFormat.format(SNAPSHOT_CREATE_FAILED_MSG, e1.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e1);
            }
        } else {
            final File file = saveFile.getSelectedFile();
            saveFile = null;
            if (!this.checkFileExists(file)) {
                if (lrw != null) {
                    statusHandler.resumeLiveUpdates();
                }
                return;
            }
            IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressHandle pHandle = null;
                    pHandle = ProgressHandleFactory.createHandle((String)EXPORTING_VIEW_MSG);
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    try {
                        FileOutputStream fo = new FileOutputStream(file);
                        ExportDataDumper eDD = new ExportDataDumper(fo);
                        ExportAction.this.exportProvider.exportData(ExportAction.this.exportedFileType, eDD);
                        if (eDD.getCaughtException() != null) {
                            NetBeansProfiler.getDefaultNB().displayError(eDD.getNumExceptions() + IOEXCEPTION_EXPORTING_MSG);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (OutOfMemoryError e) {
                        NetBeansProfiler.getDefaultNB().displayError(OOME_EXPORTING_MSG + e.getMessage());
                    }
                    finally {
                        if (pHandle != null) {
                            pHandle.finish();
                        }
                        if (lrw != null) {
                            statusHandler.resumeLiveUpdates();
                        }
                    }
                }
            });
        }
    }

    private static class SelectedFile {
        File folder;
        String fileExt;
        String fileName;

        SelectedFile(File folder, String fileName, String fileExt) {
            this.folder = folder;
            this.fileName = fileName;
            this.fileExt = fileExt;
        }

        File getSelectedFile() {
            return new File(this.folder + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    public static interface ExportProvider {
        public void exportData(int var1, ExportDataDumper var2);

        public String getViewName();

        public boolean hasExportableView();

        public boolean hasLoadedSnapshot();
    }
}

