/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beansdev.AbstractCodeGeneratorClass;
import org.netbeans.modules.schema2beansdev.CodeGeneratorClass;
import org.netbeans.modules.schema2beansdev.CodeGeneratorFactory;
import org.netbeans.modules.schema2beansdev.DataEnumRestriction;
import org.netbeans.modules.schema2beansdev.GenBeans;
import org.netbeans.modules.schema2beansdev.GraphLink;
import org.netbeans.modules.schema2beansdev.GraphNode;
import org.netbeans.modules.schema2beansdev.HasPrefixGuesser;
import org.netbeans.modules.schema2beansdev.TreeBuilder;
import org.netbeans.modules.schema2beansdev.TreeParser;
import org.netbeans.modules.schema2beansdev.beangraph.BeanGraph;
import org.netbeans.modules.schema2beansdev.beangraph.SchemaTypeMappingType;
import org.netbeans.modules.schema2beansdev.gen.JavaUtil;
import org.netbeans.modules.schema2beansdev.gen.JavaWriter;
import org.netbeans.modules.schema2beansdev.gen.WriteIfDifferentOutputStream;
import org.netbeans.modules.schema2beansdev.metadd.MetaDD;
import org.netbeans.modules.schema2beansdev.metadd.MetaElement;
import org.netbeans.modules.schema2beansdev.metadd.MetaProperty;

public class BeanBuilder {
    private static final String UNIQUE_PREFIX = "My";
    protected GenBeans.Config config;
    protected CodeGeneratorFactory codeGenFactory;
    protected BeanElement rootElement;
    protected String genDir;
    protected String packagePath;
    protected String packageName = null;
    protected TreeParser parser;
    protected Map constNameMap = null;
    protected Map illegalClassNames = new HashMap();

    BeanBuilder(TreeParser parser, GenBeans.Config config, CodeGeneratorFactory cgf) {
        this.parser = parser;
        this.config = config;
        this.codeGenFactory = cgf;
        this.illegalClassNames.put("Object", null);
        this.illegalClassNames.put("Thread", null);
        this.illegalClassNames.put("Compiler", null);
        this.illegalClassNames.put("Class", null);
        this.illegalClassNames.put("ClassLoader", null);
        this.illegalClassNames.put("Package", null);
        this.illegalClassNames.put("String", null);
        this.illegalClassNames.put("Boolean", null);
        this.illegalClassNames.put("Integer", null);
        this.illegalClassNames.put("Long", null);
        this.illegalClassNames.put("Short", null);
        this.illegalClassNames.put("Double", null);
        this.illegalClassNames.put("Float", null);
        this.illegalClassNames.put("Byte", null);
        this.illegalClassNames.put("Character", null);
        this.illegalClassNames.put("int", null);
        this.illegalClassNames.put("char", null);
        this.illegalClassNames.put("byte", null);
        this.illegalClassNames.put("short", null);
        this.illegalClassNames.put("long", null);
        this.illegalClassNames.put("double", null);
        this.illegalClassNames.put("float", null);
        this.illegalClassNames.put("boolean", null);
        this.illegalClassNames.put("void", null);
    }

    private void buildProperties(GraphLink l, CodeGeneratorClass bc, int nestedLevel, int groupInstance, boolean ored, MetaElement e, MetaDD mdd, Map usedNames) {
        while (l != null) {
            if (this.config.isTraceGen()) {
                this.config.messageOut.println("buildProperties: l=" + l + " l.name=" + l.name + " l.element=" + l.element + " l.getSibling()=" + l.getSibling() + " groupInstance=" + groupInstance);
            }
            if (l.element != null) {
                String namespace;
                String dtdName;
                String name;
                BeanElement be = (BeanElement)l.element.getObject();
                if (be == null) {
                    this.config.messageOut.println("Warning: be was null");
                    continue;
                }
                if (l.getParent() != null) {
                    boolean bl = ored = ored || l.getParent().isSequenceOr();
                }
                if (l.name != null) {
                    name = Common.convertName(l.name);
                    dtdName = l.getSchemaName();
                    namespace = l.getNamespace();
                } else {
                    name = be.getName();
                    dtdName = be.getDTDName();
                    namespace = be.getNamespace();
                }
                MetaElement propertyME = this.getMetaElement(mdd, dtdName);
                if (propertyME != null && propertyME.getBeanName() != null) {
                    name = propertyME.getBeanName();
                    if (this.config.isTraceGen()) {
                        this.config.messageOut.println("buildProperties: property in " + e.getBeanName() + " has been renamed to " + name);
                    }
                }
                String constName = Common.constName(dtdName);
                if ("#PCDATA".equals(dtdName)) {
                    name = "pcdata";
                    constName = "PCDATA";
                }
                if (usedNames.containsKey(name)) {
                    int uniqNum = 2;
                    String baseName = name;
                    while (usedNames.containsKey(name = baseName + uniqNum)) {
                        ++uniqNum;
                    }
                    constName = constName + uniqNum;
                    if (l.name == null) {
                        be.setName(name);
                        MetaElement origE = this.getMetaElement(mdd, dtdName);
                        if (origE != null) {
                            MetaElement newE = new MetaElement(origE);
                            mdd.addMetaElement(newE);
                        }
                    }
                    this.config.messageOut.println(Common.getMessage("RenamedProperty_msg", baseName, name, e.getBeanName()));
                }
                usedNames.put(name, be);
                if (this.config.isTraceGen()) {
                    this.config.messageOut.println("buildProperties: name=" + name + " constName=" + constName + " dtdName=" + dtdName + " graphlink.name=" + l.name + " be.getClassType=" + be.getClassType());
                }
                AttrProp[] attrs = be.node.getAttributes();
                ArrayList<KnownValueEnumeration> extraData = new ArrayList<KnownValueEnumeration>(l.extraData);
                if (!be.node.getExtraData().isEmpty()) {
                    extraData.addAll(be.node.getExtraData());
                }
                if (propertyME != null && propertyME.sizeKnownValue() > 0) {
                    int size = propertyME.sizeKnownValue();
                    for (int valNum = 0; valNum < size; ++valNum) {
                        String knownValue = propertyME.getKnownValue(valNum);
                        extraData.add(new KnownValueEnumeration(knownValue));
                    }
                }
                this.constNameMap.put(constName, dtdName);
                int type = be.type;
                String classType = be.getClassType();
                if (!be.isTypeSetExternally() && (ored || l.isNillable()) && JavaUtil.isPrimitiveType(classType)) {
                    type = Common.wrapperToType(classType = JavaUtil.toObjectType(classType));
                    if (type == 0) {
                        type = 256;
                    }
                    if (this.config.isTraceGen()) {
                        this.config.messageOut.println("Promoting primitive type to object type for " + name + " classType=" + classType + " type=" + type);
                    }
                }
                AbstractCodeGeneratorClass.Property prop = bc.addProperty(name, dtdName, namespace, l.element, l, classType, nestedLevel, l.getElementInstance(), groupInstance, type, ored, attrs, constName, l.getDefaultValue(), true, extraData, l.isUnion());
                prop.setCanBeEmpty(be.getCanBeEmpty());
                prop.setNillable(l.isNillable());
                prop.setBeanElement(be);
                l.setObject(prop);
                if (e != null) {
                    MetaProperty[] metaProperties = e.getMetaProperty();
                    boolean found = false;
                    for (int i = 0; i < metaProperties.length; ++i) {
                        if (!name.equals(metaProperties[i].getBeanName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        MetaProperty mp = new MetaProperty();
                        mp.setBeanName(name);
                        e.addMetaProperty(mp);
                    }
                }
                if (!Common.isBean(be.type) && this.config.isAttributesAsProperties()) {
                    this.addAttrProps(bc, attrs, name, usedNames, l.getElementInstance(), false);
                }
            }
            int childGroupInstance = Common.widestInstance(groupInstance, l.getGroupInstance());
            this.buildProperties(l.getFirstChild(), bc, nestedLevel + 1, childGroupInstance, ored, e, mdd, usedNames);
            l = l.getSibling();
        }
    }

    protected void addAttrProps(CodeGeneratorClass bc, AttrProp[] attrs, String propertyName, Map usedNames, int groupInstance, boolean directChild) {
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                this.addAttrProp(bc, attrs[i], propertyName, usedNames, groupInstance, directChild);
            }
        }
    }

    protected void addAttrProp(CodeGeneratorClass bc, AttrProp attr, String propertyName, Map usedNames, int groupInstance, boolean directChild) {
        int type;
        String name = directChild ? Common.convertName(attr.getName()) : Common.convertName(propertyName + "_" + attr.getName());
        if (usedNames.containsKey(name)) {
            int uniqNum = 2;
            String baseName = name;
            while (usedNames.containsKey(name = baseName + uniqNum)) {
                ++uniqNum;
            }
            attr.setName(name);
            this.config.messageOut.println(Common.getMessage("RenamedProperty_msg", baseName, name, propertyName));
        }
        usedNames.put(name, attr);
        String javaType = attr.getJavaType();
        if (javaType == null) {
            type = 256;
            javaType = "java.lang.String";
        } else {
            type = Common.wrapperToType(javaType);
            if (type == 0) {
                type = 256;
            }
        }
        List extraData = attr.getExtraData();
        String namespace = attr.getNamespace();
        bc.addProperty(name, attr.getDtdName(), namespace, null, null, javaType, 0, attr.getInstance(), groupInstance, type, false, null, Common.constName(name), attr.getDefaultValue(), directChild, extraData, false).setAttrProp(attr);
    }

    protected void addCommentsProcessing(CodeGeneratorClass bc) {
        bc.addProperty("Comments", "comment", null, null, null, "java.lang.String", 0, 48, 0, 3840, false, null, "COMMENTS", null, true, Collections.EMPTY_LIST, false);
    }

    void process() throws IOException {
        LinkedHashMap generators = new LinkedHashMap();
        this.prepareBeans(generators);
        this.doGeneration(generators);
    }

    void prepareBeans(Map generators) throws IOException {
        GraphNode graphNode;
        BeanElement be;
        GraphNode root = this.parser.getRoot();
        GraphNode[] list = this.parser.getNodes();
        MetaDD mdd = this.config.getMetaDD();
        if (root == null) {
            throw new IllegalStateException(Common.getMessage("DTDObjectGraphIsNull_msg"));
        }
        this.constNameMap = new LinkedHashMap();
        for (int i = 0; i < list.length; ++i) {
            GraphNode node = list[i];
            be = new BeanElement(node);
            be.initialize(node == root);
            node.setObject(be);
        }
        String rootDir = this.config.getRootDir() == null ? "." : this.config.getRootDir().toString();
        this.packagePath = this.config.getPackagePath();
        this.rootElement = (BeanElement)root.getObject();
        if (this.packagePath == null) {
            this.packagePath = this.rootElement.getName().toLowerCase();
        }
        this.genDir = rootDir.equals("") ? this.packagePath : (!rootDir.equals("/") ? (this.packagePath == null || this.packagePath.equals("") ? rootDir : rootDir + "/" + this.packagePath) : "/" + this.packagePath);
        this.packageName = null;
        if (this.packagePath != null) {
            this.packageName = this.packagePath.replace('/', '.');
        }
        if (this.config.isDoGeneration() && this.config.getOutputStreamProvider() instanceof GenBeans.DefaultOutputStreamProvider) {
            File dir = new File(this.genDir);
            if (dir.exists() && !dir.isDirectory()) {
                throw new Schema2BeansRuntimeException(Common.getMessage("CantCreateDirIsFile_msg", dir));
            }
            if (!dir.exists() && dir.mkdirs() && !this.config.isQuiet()) {
                this.config.messageOut.println(Common.getMessage("MSG_CreatedDirectory", dir));
            }
        }
        this.setSchemaType(list);
        String commonInterface = this.config.getGenerateCommonInterface();
        if (commonInterface != null) {
            this.illegalClassNames.put(commonInterface, "Common Bean Interface");
            if (this.packageName != null && !"".equals(this.packageName)) {
                commonInterface = this.packageName + "." + commonInterface;
            }
        }
        boolean doGeneration = !this.config.isCheckUpToDate();
        for (int i = 0; i < list.length; ++i) {
            GraphNode extensionNode;
            MetaElement e = null;
            graphNode = list[i];
            String suggestedJavaType = graphNode.getJavaType();
            be = (BeanElement)graphNode.getObject();
            if (be == null) continue;
            e = this.getMetaElement(mdd, be.getDTDName(), graphNode.getNamespace());
            if (e == null) {
                e = new MetaElement();
                e.setBeanName(be.getName());
                e.setDtdName(be.getDTDName());
                e.setNamespace(graphNode.getNamespace());
                mdd.addMetaElement(e);
            }
            if (e.isCanBeEmpty()) {
                be.setCanBeEmpty(true);
            }
            if (e.getBeanName() != null && !e.getBeanName().equals("")) {
                be.setClassType(e.getBeanName());
                be.setName(e.getBeanName());
            }
            if (e.getWrapperClass() != null) {
                suggestedJavaType = e.getWrapperClass();
                graphNode.setCreated(false);
                be.setTypeSetExternally(true);
            } else if (suggestedJavaType != null) {
                e.setWrapperClass(suggestedJavaType);
            } else if (be != this.rootElement && Common.isScalar(be.type)) {
                e.setWrapperClass(Common.wrapperClass(be.type));
                suggestedJavaType = e.getWrapperClass();
            } else if (be != this.rootElement && !Common.isBean(be.type)) {
                e.setWrapperClass(be.typeToString());
                suggestedJavaType = e.getWrapperClass();
            }
            if (suggestedJavaType != null) {
                int proposedType = Common.wrapperToType(suggestedJavaType);
                if (proposedType != 0) {
                    be.type = proposedType;
                }
                be.setClassType(suggestedJavaType);
            }
            if (graphNode.getExtendedProperty("can-be-empty") != null) {
                be.setCanBeEmpty(true);
            }
            if (!be.isBean()) continue;
            while (this.illegalClassNames.containsKey(be.getClassType())) {
                String prefix = graphNode.getNamespace() != null ? Common.convertName(graphNode.getNamespace()) : UNIQUE_PREFIX;
                be.setClassType(prefix + be.getClassType());
                be.setName(prefix + be.getName());
                e.setBeanName(prefix + e.getBeanName());
                if (!this.config.isTraceGen()) continue;
                this.config.messageOut.println("Made class name change to " + be.getClassType());
            }
            this.illegalClassNames.put(be.getClassType(), be);
            if (graphNode.getExtension() != null && (extensionNode = graphNode.getExtension()).isCreated()) {
                BeanElement extensionBE = (BeanElement)extensionNode.getObject();
                String extendsName = extensionBE.getFullClassType();
                e.setExtends(extendsName);
                this.addToBeanInterfaceExtends(e, extendsName + "Interface");
            }
            if (this.config.isExtendBaseBean() && e.getExtends() == null) {
                e.setExtends("org.netbeans.modules.schema2beans.BaseBean");
            }
            if (graphNode.getExtendedProperty("extends") != null && e.getExtends() == null) {
                e.setExtends((String)graphNode.getExtendedProperty("extends"));
            }
            if (graphNode.getExtendedProperty("implements") != null && e.getImplements() == null) {
                e.setImplements((String)graphNode.getExtendedProperty("implements"));
            }
            if (this.config.isGenerateInterfaces()) {
                String interfaceName;
                if (graphNode.getJavaType() == null) {
                    interfaceName = be.getName() + "Interface";
                    if (this.packageName != null && !"".equals(this.packageName)) {
                        interfaceName = this.packageName + "." + interfaceName;
                    }
                } else {
                    interfaceName = graphNode.getJavaType() + "Interface";
                }
                this.addToImplements(e, interfaceName);
            }
            if (commonInterface != null && graphNode.getJavaType() == null) {
                this.addToImplements(e, commonInterface);
            }
            if (this.config.isExtendBaseBean()) {
                this.addToImplements(e, "org.netbeans.modules.schema2beans.Bean");
            }
            if (!this.config.isCheckUpToDate()) continue;
            String outputFileName = be.getOutputFileName();
            if (!this.config.getOutputStreamProvider().isOlderThan(this.genDir, outputFileName, "java", this.config.getNewestSourceTime())) continue;
            doGeneration = true;
        }
        if (!doGeneration) {
            this.config.messageOut.println(Common.getMessage("MSG_SkippingGenerationDueToTime"));
            return;
        }
        HashMap<String, BeanElement> usedTypes = new HashMap<String, BeanElement>();
        for (int i = 0; i < list.length; ++i) {
            MetaElement e = null;
            be = (BeanElement)list[i].getObject();
            if (be == null) continue;
            graphNode = be.getGraphNode();
            if (be.isBean() || be == this.rootElement) {
                GraphLink l;
                if (this.config.isTraceGen()) {
                    this.config.messageOut.println("Building properties for " + be);
                }
                be.isAbstract = graphNode.isAbstract();
                e = this.getMetaElement(mdd, be.getDTDName(), graphNode.getNamespace());
                HashMap usedNames = new HashMap();
                CodeGeneratorClass bc = this.codeGenFactory.newCodeGeneratorClass(be, this.config);
                bc.setPackageName(this.packageName);
                bc.setIndent(this.config.getIndent());
                bc.setRootBeanElement(this.rootElement);
                bc.setDefaultNamespace(this.parser.getDefaultNamespace());
                bc.setInvalidPropertyNames(usedNames);
                if (this.config.isProcessComments()) {
                    this.addCommentsProcessing(bc);
                }
                if (this.parser instanceof HasPrefixGuesser) {
                    bc.setPrefixGuesser(((HasPrefixGuesser)((Object)this.parser)).getPrefixGuesser());
                }
                if (this.config.isAttributesAsProperties()) {
                    this.addAttrProps(bc, be.node.getAttributes(), be.getName(), usedNames, 32, true);
                }
                if (be.isBean() && (l = graphNode.getGraphLink()) != null) {
                    int groupInstance = l.getGroupInstance();
                    this.buildProperties(l, bc, 0, groupInstance, false, e, mdd, usedNames);
                    int nonAttributePropertyCount = 0;
                    List props = bc.getPropertyList();
                    for (AbstractCodeGeneratorClass.Property prop : props) {
                        if (prop.isAttribute()) continue;
                        ++nonAttributePropertyCount;
                    }
                    be.setNonAttributePropertyCount(be.getNonAttributePropertyCount() + nonAttributePropertyCount);
                }
                if (graphNode.isCreated()) {
                    generators.put(be, bc);
                }
            }
            usedTypes.put(be.getClassType(), be);
        }
        this.rootElement.setUsedTypes(usedTypes);
        this.processFinders(this.rootElement.node);
        if (this.config.getWriteBeanGraphFile() != null) {
            File beanGraphFile = this.config.getWriteBeanGraphFile();
            File parentDir = beanGraphFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && parentDir.mkdirs() && !this.config.isQuiet()) {
                this.config.messageOut.println(Common.getMessage("MSG_CreatedDirectory", parentDir));
            }
            WriteIfDifferentOutputStream out = new WriteIfDifferentOutputStream(beanGraphFile);
            BeanGraph bg = this.generateBeanGraph(list);
            bg.write(out);
            this.close(out);
        }
    }

    void doGeneration(Map generators) throws IOException {
        MetaDD mdd = this.config.getMetaDD();
        if (this.config.isDoGeneration()) {
            CodeGeneratorClass bc;
            LinkedList<Collection> generatedMethods = new LinkedList<Collection>();
            for (BeanElement be : generators.keySet()) {
                bc = (CodeGeneratorClass)generators.get(be);
                String outputFileName = be.getOutputFileName();
                MetaElement metaElement = this.getMetaElement(mdd, be.getDTDName(), be.node.getNamespace());
                if (metaElement.isSkipGeneration()) {
                    this.config.messageOut.println("Skipping generation of class " + be.beanName + " (as specified in the mdd file)");
                    continue;
                }
                try {
                    OutputStream out = this.config.getOutputStreamProvider().getStream(this.genDir, outputFileName, "java");
                    bc.generate(out, mdd);
                    this.close(out);
                    out = null;
                    Collection beansMethods = bc.getGeneratedMethods();
                    generatedMethods.add(beansMethods);
                    if (this.config.isGenerateDelegator()) {
                        String delegatorClassName;
                        GraphNode graphNode = be.getGraphNode();
                        MetaElement e = this.getMetaElement(mdd, be.getDTDName(), graphNode.getNamespace());
                        if (e != null && e.getDelegatorName() != null) {
                            delegatorClassName = e.getDelegatorName();
                        } else {
                            delegatorClassName = outputFileName + "Delegator";
                            if (e != null) {
                                e.setDelegatorName(delegatorClassName);
                            }
                        }
                        String delegatorPackageName = this.packageName;
                        String dir = this.genDir;
                        if (this.config.getDelegateDir() != null) {
                            dir = this.config.getDelegateDir().getAbsolutePath();
                            if (this.config.getDelegatePackage() == null) {
                                if (this.packagePath != null && !this.packagePath.equals("")) {
                                    dir = dir + "/" + this.packagePath;
                                }
                            } else {
                                delegatorPackageName = this.config.getDelegatePackage();
                                dir = dir + "/" + delegatorPackageName.replace('.', '/');
                            }
                        }
                        out = this.config.getOutputStreamProvider().getStream(dir, delegatorClassName, "java");
                        bc.generateDelegator(out, mdd, delegatorClassName, delegatorPackageName);
                        this.close(out);
                        out = null;
                    }
                    if (!this.config.isGenerateInterfaces()) continue;
                    ArrayList<JavaWriter.Method> beanInfoMethods = new ArrayList<JavaWriter.Method>(beansMethods.size());
                    for (JavaWriter.Method method : beansMethods) {
                        if (method.isStatic() || method.isConstructor() || !method.isPublic() || !method.isBeanInfo()) continue;
                        beanInfoMethods.add(method);
                    }
                    String interfaceName = outputFileName + "Interface";
                    GraphNode graphNode = be.getGraphNode();
                    MetaElement me = this.getMetaElement(mdd, be.getDTDName(), graphNode.getNamespace());
                    this.generateInterface(this.genDir, this.packageName, interfaceName, beanInfoMethods, "This interface has all of the bean info accessor methods.", me.getBeanInterfaceExtends());
                }
                catch (IOException ioe) {
                    this.config.messageOut.println("Failed to generate bean class: " + outputFileName);
                    TraceLogger.error(ioe);
                    throw ioe;
                }
                catch (IllegalStateException ise) {
                    this.config.messageOut.println("Failed to generate bean class " + outputFileName);
                    TraceLogger.error(ise);
                    throw ise;
                }
            }
            if (this.config.getGenerateCommonInterface() != null && generatedMethods.size() > 0) {
                HashMap<String, JavaWriter.Method> commonGeneratedMethods = new HashMap<String, JavaWriter.Method>();
                Iterator it = generatedMethods.iterator();
                Collection methods = (Collection)it.next();
                for (JavaWriter.Method method : methods) {
                    if (method.isStatic() || method.isConstructor() || !method.isPublic() || method.isUnsupported()) continue;
                    commonGeneratedMethods.put(method.getNameParameters(), method);
                }
                while (it.hasNext()) {
                    methods = (Collection)it.next();
                    HashMap toKeep = new HashMap();
                    for (JavaWriter.Method method : methods) {
                        String nameParameters = method.getNameParameters();
                        if (!commonGeneratedMethods.containsKey(nameParameters)) continue;
                        toKeep.put(nameParameters, commonGeneratedMethods.get(nameParameters));
                    }
                    commonGeneratedMethods = toKeep;
                }
                ArrayList sortedMethodNames = new ArrayList(commonGeneratedMethods.keySet());
                Collections.sort(sortedMethodNames);
                ArrayList sortedMethods = new ArrayList(sortedMethodNames.size());
                Iterator sortedMethodNamesIterator = sortedMethodNames.iterator();
                while (sortedMethodNamesIterator.hasNext()) {
                    sortedMethods.add(commonGeneratedMethods.get(sortedMethodNamesIterator.next()));
                }
                this.generateInterface(this.genDir, this.packageName, this.config.getGenerateCommonInterface(), sortedMethods, "This interface is the intersection of all generated methods.", null);
            }
            if (this.config.getDumpBeanTree() != null) {
                FileWriter out = new FileWriter(this.config.getDumpBeanTree());
                bc = (CodeGeneratorClass)generators.get(this.rootElement);
                bc.dumpBeanTree(out, "", this.config.getIndent());
                this.close(out);
            }
            if (this.config.isGenerateTagsFile()) {
                String tagsClassName = "Tags";
                while (this.illegalClassNames.containsKey(tagsClassName)) {
                    tagsClassName = UNIQUE_PREFIX + tagsClassName;
                }
                OutputStream out = this.config.getOutputStreamProvider().getStream(this.genDir, tagsClassName, "java");
                this.generateTagsFile(out, this.packageName, tagsClassName);
                this.close(out);
            }
        }
        if (this.config.getGenerateDotGraph() != null) {
            FileWriter out = new FileWriter(this.config.getGenerateDotGraph());
            this.generateDotGraph(out, this.rootElement.getGraphNode());
            this.close(out);
        }
        if (!this.config.isQuiet()) {
            this.config.messageOut.println(Common.getMessage("MSG_GenerationSummary", this.rootElement.getDTDName(), this.rootElement.getClassType()));
        }
    }

    protected void processFinders(GraphNode rootGraphNode) {
        int size = this.config.sizeFinder();
        for (int i = 0; i < size; ++i) {
            String finderExpr = this.config.getFinder(i);
            this.processFinder(rootGraphNode, finderExpr);
        }
        MetaDD mdd = this.config.getMetaDD();
        for (String finderExpr : mdd.fetchFinderList()) {
            this.processFinder(rootGraphNode, finderExpr);
        }
    }

    protected void processFinder(GraphNode rootGraphNode, String finderExpr) {
        String rootName = rootGraphNode.getName();
        String onExpr = null;
        String findExpr = null;
        boolean isListFindExpr = false;
        String byExpr = null;
        StringTokenizer st = new StringTokenizer(finderExpr);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().intern();
            if (token == "on") {
                onExpr = st.nextToken();
                continue;
            }
            if (token == "find") {
                findExpr = st.nextToken();
                isListFindExpr = false;
                continue;
            }
            if (token == "findall") {
                findExpr = st.nextToken();
                isListFindExpr = true;
                continue;
            }
            if (token == "by") {
                byExpr = st.nextToken();
                continue;
            }
            throw new IllegalArgumentException(Common.getMessage("MSG_BadTokenInFinder", token));
        }
        if (onExpr == null) {
            throw new IllegalArgumentException(Common.getMessage("MSG_MissingOnExpression", finderExpr));
        }
        if (onExpr.startsWith("/" + rootName) && (onExpr = onExpr.substring(rootName.length() + 1, onExpr.length())).startsWith("/")) {
            onExpr = onExpr.substring(1, onExpr.length());
        }
        GraphNode onNode = null;
        if (onExpr.equals("")) {
            onNode = rootGraphNode;
        } else {
            GraphLink gl = null;
            GraphLink.XPathIterator it = rootGraphNode.getGraphLink().xPathIterator(onExpr);
            while (it.hasNext() && (gl = (GraphLink)it.next()) != null) {
            }
            if (gl == null) {
                throw new IllegalArgumentException(Common.getMessage("MSG_UnableToFindExpressionFromFinder", finderExpr));
            }
            onNode = gl.element;
        }
        onNode.addExtraDataIncludeAlias(new Finder(findExpr, byExpr, isListFindExpr));
    }

    protected void setSchemaType(GraphNode[] list) {
        HashMap<String, GraphNode> nodeMap = new HashMap<String, GraphNode>(list.length * 4);
        for (int i = 0; i < list.length; ++i) {
            nodeMap.put(list[i].getNameWithNamespace(), list[i]);
        }
        Object emptyGraphNode = null;
        Iterator it = this.config.readBeanGraphs();
        while (it.hasNext()) {
            BeanGraph bg = (BeanGraph)it.next();
            for (int i = 0; i < bg.sizeSchemaTypeMapping(); ++i) {
                SchemaTypeMappingType stm = bg.getSchemaTypeMapping(i);
                String key = stm.getSchemaTypeNamespace() == null ? stm.getSchemaTypeName() : "{" + stm.getSchemaTypeNamespace() + "}" + stm.getSchemaTypeName();
                if (!nodeMap.containsKey(key)) continue;
                GraphNode node = (GraphNode)nodeMap.get(key);
                node.setJavaType(stm.getJavaType());
                node.setCreated(false);
                if (!stm.isCanBeEmpty()) continue;
                node.setExtendedProperty("can-be-empty", Boolean.TRUE);
            }
        }
    }

    protected void generateInterface(String genDir, String packageName, String name, List methods, String comments, String extendsStatement) throws IOException {
        JavaWriter jw = new JavaWriter();
        jw.bigComment(comments + "\n\n@" + "Generated");
        jw.cr();
        if (packageName != null && !"".equals(packageName)) {
            jw.writePackage(packageName);
            jw.cr();
        }
        jw.writeAccess(0);
        jw.write(" interface ");
        jw.write(name);
        jw.write(" ");
        if (extendsStatement != null) {
            jw.write("extends ", extendsStatement, " ");
        }
        jw.begin();
        for (JavaWriter.Method method : methods) {
            method.writeMethod(jw);
            jw.eol();
            jw.cr();
        }
        jw.end();
        try {
            OutputStream out = this.config.getOutputStreamProvider().getStream(genDir, name, "java");
            jw.writeTo(out);
            this.close(out);
        }
        catch (IOException ioe) {
            this.config.messageOut.println("Failed to generate interface: " + name);
            TraceLogger.error(ioe);
            throw ioe;
        }
    }

    protected BeanGraph generateBeanGraph(GraphNode[] list) {
        BeanGraph bg = new BeanGraph();
        for (int i = 0; i < list.length; ++i) {
            GraphNode node = list[i];
            BeanElement be = (BeanElement)node.getObject();
            SchemaTypeMappingType stm = new SchemaTypeMappingType(node.getName(), be.getFullClassType());
            stm.setRoot(be.isRoot());
            stm.setBean(be.isBean());
            stm.setCanBeEmpty(be.getCanBeEmpty());
            stm.setSchemaTypeNamespace(node.getNamespace());
            bg.addSchemaTypeMapping(stm);
        }
        return bg;
    }

    protected void generateDotGraph(Writer out, GraphNode node) throws IOException {
        out.write("digraph \"" + node.getName() + "\" {\n");
        out.write("\t\"" + node.getName() + "\" [shape=box]\n");
        out.write("\t\"" + node.getName() + "\" -> \"" + node.getGraphLink() + "\";\n");
        this.generateDotGraph(out, node.getGraphLink(), new HashMap());
        out.write("}\n");
    }

    protected void generateDotGraph(Writer out, List children, Map doneLinks) throws IOException {
        for (GraphLink l : children) {
            this.generateDotGraph(out, l, doneLinks);
        }
    }

    protected void generateDotGraph(Writer out, GraphLink l, Map doneLinks) throws IOException {
        if (l == null) {
            return;
        }
        doneLinks.put(l, null);
        out.write("\t\"" + l + "\" [label=\"" + this.dotGraphLabel(l) + "\"];\n");
        GraphNode node = l.element;
        if (node != null) {
            BeanElement be = (BeanElement)node.getObject();
            if (be == null) {
                return;
            }
            String type = be.getClassType();
            out.write("\t\"" + node + "\" [label=\"" + this.dotGraphLabel(node) + "\", shape=box];\n");
            out.write("\t\"" + l + "\" -> \"" + node + "\" [label=\"type of property\", color=darkgreen];\n");
            if ("#PCDATA".equals(l.name) && "String".equals(type)) {
                return;
            }
            AttrProp[] attrs = node.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                String attrName = node.getName() + " attribute " + attrs[i].getName();
                out.write("\t\"" + attrName + "\" [label=\"" + this.dotGraphLabel(attrs[i]) + "\", shape=egg];\n");
                out.write("\t\"" + node + "\" -> \"" + attrName + "\" [label=\"attribute\", color=magenta];\n");
            }
            GraphLink hasAttr = node.getGraphLink();
            if (hasAttr != null && !node.getMarked() && (this.config.isTraceDot() || this.hasData(hasAttr)) && !doneLinks.containsKey(hasAttr)) {
                out.write("\t\"" + node + "\" -> \"" + hasAttr + "\" [label=\"has attr\", color=purple];\n");
                node.setMarked(true);
                this.generateDotGraph(out, hasAttr, doneLinks);
                node.setMarked(false);
            }
        }
        List children = l.getChildren();
        for (GraphLink child : children) {
            out.write("\t\"" + l + "\" -> \"" + child + "\" [label=child, color=blue];\n");
        }
        this.generateDotGraph(out, children, doneLinks);
    }

    private String dotGraphLabel(GraphLink l) {
        if (this.config.isTraceDot()) {
            String elementInstance = TreeBuilder.instanceToString(l.getElementInstance(), true);
            String groupInstance = TreeBuilder.instanceToString(l.getGroupInstance(), true);
            String result = "GraphLink@" + Integer.toHexString(l.hashCode());
            result = l.name == null ? result + " (grouping)" : result + ":" + l.name;
            result = result + "\\n";
            if (!"".equals(elementInstance)) {
                result = result + " element: " + elementInstance;
            }
            if (!"".equals(groupInstance)) {
                result = result + " group: " + groupInstance;
            }
            if (l.isSequenceAnd()) {
                result = result + " ,";
            }
            if (l.isSequenceOr()) {
                result = result + " |";
            }
            return result;
        }
        if (l.name == null) {
            return "GraphLink";
        }
        return "property: " + l.name;
    }

    private String dotGraphLabel(GraphNode node) {
        String result = this.config.isTraceDot() ? "GraphNode@" + Integer.toHexString(node.hashCode()) + ":" + node.toString() : node.getName();
        if (node.getJavaType() != null) {
            result = result + ":" + node.getJavaType();
        }
        return result;
    }

    private String dotGraphLabel(AttrProp attr) {
        return attr.toString();
    }

    private boolean hasData(GraphLink l) {
        while (l != null) {
            if (l.name != null) {
                return true;
            }
            if (l.element != null) {
                return true;
            }
            if (l.getFirstChild() != null && this.hasData(l.getFirstChild())) {
                return true;
            }
            l = l.getSibling();
        }
        return false;
    }

    protected void generateTagsFile(OutputStream out, String packageName, String className) throws IOException {
        JavaWriter jw = new JavaWriter();
        jw.bigComment("This class has all element and attribute names as constants.\n\n@Generated");
        jw.cr();
        jw.writePackage(packageName);
        jw.cr();
        jw.writeClassDecl(className, null, null, 0);
        jw.select(jw.DECL_SECTION);
        for (String constName : this.constNameMap.keySet()) {
            String dtdName = (String)this.constNameMap.get(constName);
            jw.write("public final static String ", constName, " = ");
            jw.writeEol("\"", dtdName, "\"");
        }
        jw.cr();
        jw.select(jw.CONSTRUCTOR_SECTION);
        jw.comment("This class is not to be instantiated.");
        jw.beginConstructor(className, "", null, 3);
        jw.end();
        jw.writeTo(out);
    }

    private MetaElement getMetaElement(MetaDD mdd, String dtdName) {
        return this.getMetaElement(mdd, dtdName, null);
    }

    private MetaElement getMetaElement(MetaDD mdd, String dtdName, String namespace) {
        if (mdd == null) {
            return null;
        }
        int size = mdd.sizeMetaElement();
        for (int i = 0; i < size; ++i) {
            MetaElement e = mdd.getMetaElement(i);
            if (e == null || namespace != null && !namespace.equals(e.getNamespace()) || !e.getDtdName().equals(dtdName)) continue;
            return e;
        }
        return null;
    }

    private void addToImplements(MetaElement e, String interfce) {
        String implList = e.getImplements();
        if (implList == null) {
            e.setImplements(interfce);
            return;
        }
        implList = implList.trim();
        int pos = implList.indexOf(44);
        while (pos >= 0) {
            String impl = implList.substring(0, pos);
            if ((impl = impl.trim()).equals(interfce)) {
                return;
            }
            implList = implList.substring(pos + 1, implList.length());
            implList = implList.trim();
            pos = implList.indexOf(44);
        }
        if (implList.equals(interfce)) {
            return;
        }
        e.setImplements(e.getImplements() + ", " + interfce);
    }

    private void addToBeanInterfaceExtends(MetaElement e, String interfce) {
        String implList = e.getBeanInterfaceExtends();
        if (implList == null) {
            e.setBeanInterfaceExtends(interfce);
            return;
        }
        implList = implList.trim();
        int pos = implList.indexOf(44);
        while (pos >= 0) {
            String impl = implList.substring(0, pos);
            if ((impl = impl.trim()).equals(interfce)) {
                return;
            }
            implList = implList.substring(pos + 1, implList.length());
            implList = implList.trim();
            pos = implList.indexOf(44);
        }
        if (implList.equals(interfce)) {
            return;
        }
        e.setBeanInterfaceExtends(e.getBeanInterfaceExtends() + ", " + interfce);
    }

    protected void close(OutputStream out) throws IOException {
        WriteIfDifferentOutputStream widos;
        out.close();
        if (!this.config.isQuiet() && this.config.isTraceGen() && out instanceof WriteIfDifferentOutputStream && !(widos = (WriteIfDifferentOutputStream)out).isChanged()) {
            this.config.messageOut.println(Common.getMessage("MSG_DidNotChangeFile"));
        }
    }

    protected void close(Writer out) throws IOException {
        out.close();
    }

    protected static class KnownValueEnumeration
    implements DataEnumRestriction {
        private String knownValue;

        protected KnownValueEnumeration(String value) {
            this.knownValue = value;
        }

        @Override
        public void genRestriction(Writer out, String type) throws IOException {
            out.write(JavaUtil.instanceFrom(type, this.knownValue));
        }
    }

    class Finder {
        private String findExpr;
        private String byExpr;
        private boolean listFindExpr;

        public Finder(String findExpr, String byExpr, boolean listFindExpr) {
            this.findExpr = findExpr;
            this.byExpr = byExpr;
            this.listFindExpr = listFindExpr;
        }

        public String getFindExpr() {
            return this.findExpr;
        }

        public String getByExpr() {
            return this.byExpr;
        }

        public boolean isListFindExpr() {
            return this.listFindExpr;
        }

        public String toString() {
            if (this.listFindExpr) {
                return "Finder list " + this.findExpr + " by " + this.byExpr;
            }
            return "Finder " + this.findExpr + " by " + this.byExpr;
        }
    }

    class BeanElement {
        GraphNode node;
        String beanName;
        int type;
        String classType;
        private boolean typeSetExternally = false;
        boolean isRoot;
        boolean isAbstract;
        private boolean canBeEmpty = false;
        private Map usedTypes;
        private int nonAttributePropertyCount = 0;

        BeanElement(GraphNode node) {
            this.node = node;
        }

        void initialize(boolean isRoot) {
            this.beanName = Common.convertName(this.node.getName());
            this.type = 512;
            this.isRoot = isRoot;
            this.calculateType();
        }

        public GraphNode getGraphNode() {
            return this.node;
        }

        public void setNodeCreated(boolean value) {
            this.node.setCreated(value);
            this.calculateType();
        }

        protected void calculateType() {
            GraphNode[] nodes;
            if (!this.node.isCreated()) {
                this.type = 256;
            }
            if ((nodes = this.node.getNodes()).length == 1 && !this.isRoot) {
                if ("#PCDATA".equals(nodes[0].getName())) {
                    this.type = 256;
                } else if ("EMPTY".equals(nodes[0].getName())) {
                    this.type = 768;
                    this.canBeEmpty = true;
                }
            }
        }

        void setCanBeEmpty(boolean value) {
            this.canBeEmpty = value;
            if (this.canBeEmpty) {
                // empty if block
            }
        }

        public void setName(String name) {
            this.beanName = name;
        }

        public String getName() {
            return this.beanName;
        }

        public String getDTDName() {
            return this.node.getName();
        }

        public void setDTDName(String dtdName) {
            this.node.setName(dtdName);
        }

        public String getNamespace() {
            return this.node.getNamespace();
        }

        public boolean isBean() {
            return Common.isBean(this.type);
        }

        public boolean isBoolean() {
            return Common.isBoolean(this.type);
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public String typeToString() {
            switch (this.type) {
                case 256: {
                    return "String";
                }
                case 768: {
                    return "Boolean";
                }
            }
            return this.beanName;
        }

        public String getClassType() {
            if (this.classType == null) {
                return this.typeToString();
            }
            return this.classType;
        }

        public String getFullClassType() {
            String result = this.getClassType();
            if (BeanBuilder.this.packageName == null) {
                return result;
            }
            if (this.isBean() && this.node.isCreated()) {
                return BeanBuilder.this.packageName + "." + result;
            }
            return result;
        }

        public void setClassType(String ct) {
            this.classType = ct;
        }

        public boolean isTypeSetExternally() {
            return this.typeSetExternally;
        }

        public void setTypeSetExternally(boolean value) {
            this.typeSetExternally = value;
        }

        public String toString() {
            return this.beanName + (this.type == 256 ? " \t(String)" : "\t(Bean)");
        }

        public void setUsedTypes(Map usedTypes) {
            this.usedTypes = usedTypes;
        }

        public boolean isUsedType(String type) {
            return this.usedTypes.containsKey(type);
        }

        public boolean getCanBeEmpty() {
            return this.canBeEmpty;
        }

        public String getOutputFileName() {
            if (this.isBean()) {
                return this.getClassType();
            }
            return this.getName();
        }

        public BeanElement getExtension() {
            if (this.node.getExtension() == null || !this.node.getExtension().isCreated()) {
                return null;
            }
            return (BeanElement)this.node.getExtension().getObject();
        }

        public void setNonAttributePropertyCount(int value) {
            this.nonAttributePropertyCount = value;
        }

        public int getNonAttributePropertyCount() {
            return this.nonAttributePropertyCount;
        }
    }
}

