/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.refactoring.php.findusages.RefactoringUtils;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class FindUsages {
    private static final Logger LOG = Logger.getLogger(FindUsages.class.getName());

    private FindUsages() {
    }

    public static boolean canFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (ec == null || ec.getOpenedPanes() == null) {
            return false;
        }
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        return RefactoringUtils.isRefactorable(fo) ? !RefactoringUtils.isOutsidePhp(lookup, fo) : false;
    }

    public static void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringUtils.isFromEditor(ec)) {
            FindUsagesTask.start(ec);
        }
    }

    private static class FindUsagesTask
    extends UserTask {
        private JTextComponent textC;
        private int caret;
        private RefactoringUI ui;

        private FindUsagesTask(EditorCookie ec) {
            this.textC = ec.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            assert (this.caret != -1);
        }

        public static void start(EditorCookie ec) {
            FindUsagesTask t = new FindUsagesTask(ec);
            try {
                ParserManager.parse(Collections.singleton(Source.create((Document)ec.getDocument())), (UserTask)t);
            }
            catch (ParseException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (t.ui != null) {
                UI.openRefactoringUI((RefactoringUI)t.ui, (TopComponent)activetc);
            }
        }

        public void cancel() {
        }

        public void run(ResultIterator resultIterator) throws Exception {
            ParserResult cc = (ParserResult)resultIterator.getParserResult();
            Program root = RefactoringUtils.getRoot(cc);
            if (root == null) {
                LOG.log(Level.FINE, "FAILURE - can't refactor uncompileable sources");
                return;
            }
            WhereUsedSupport ctx = WhereUsedSupport.getInstance(cc, this.caret);
            if (ctx != null && ctx.getName() != null) {
                this.ui = new WhereUsedQueryUI(ctx, cc);
            }
        }
    }
}

