/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.items;

import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.DatabindingCategoryCD;
import org.netbeans.modules.vmd.midp.components.databinding.DataSetAbstractCD;
import org.netbeans.modules.vmd.midp.components.databinding.DataSetConnectorCD;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;

public abstract class DatabindingItemAcceptPresenter
extends AcceptPresenter {
    private final TypeID typeID = DataSetAbstractCD.TYPEID;

    public DatabindingItemAcceptPresenter() {
        super(AcceptPresenter.Kind.COMPONENT_PRODUCER);
    }

    public final boolean isAcceptable(ComponentProducer producer, AcceptSuggestion suggestion) {
        DescriptorRegistry registry = this.getComponent().getDocument().getDescriptorRegistry();
        TypeID producerTypeID = producer.getMainComponentTypeID();
        return registry.isInHierarchy(this.typeID, producerTypeID);
    }

    public final ComponentProducer.Result accept(ComponentProducer producer, AcceptSuggestion suggestion) {
        ComponentProducer.Result result = producer.createComponent(this.getComponent().getDocument());
        DesignComponent component = result.getMainComponent();
        if (component != null) {
            this.notifyCreated(component);
        }
        DesignComponent category = MidpDocumentSupport.getCategoryComponent(component.getDocument(), DatabindingCategoryCD.TYPEID);
        category.addComponent(component);
        return result;
    }

    protected abstract void notifyCreated(DesignComponent var1);

    public static Presenter create(final String ... propertyNames) {
        return new DatabindingItemAcceptPresenter(){

            @Override
            protected void notifyCreated(DesignComponent component) {
                for (String propertyName : propertyNames) {
                    MidpDatabindingSupport.removeUnusedConnector(component, propertyName);
                    this.createConnector(component, propertyName);
                }
            }
        };
    }

    protected void createConnector(DesignComponent dataSet, String propertyName) {
        DesignComponent connector = dataSet.getDocument().createComponent(DataSetConnectorCD.TYPEID);
        connector.writeProperty("property", MidpTypes.createStringValue(propertyName));
        connector.writeProperty("referencedComponent", MidpTypes.createLongValue(this.getComponent().getComponentID()));
        dataSet.addComponent(connector);
        this.getComponent().resetToDefault(propertyName);
    }
}

