/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CppStringTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class CppStringLexer
implements Lexer<CppStringTokenId> {
    private static final int INIT = 0;
    private static final int OTHER = 1;
    private static final int EOF = -1;
    private LexerInput input;
    private TokenFactory<CppStringTokenId> tokenFactory;
    private boolean escapedLF = false;
    private final boolean dblQuoted;
    private int state = 0;

    public CppStringLexer(LexerRestartInfo<CppStringTokenId> info, boolean doubleQuotedString) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.dblQuoted = doubleQuotedString;
        Integer stateObj = (Integer)info.state();
        this.fromState(stateObj);
    }

    public Object state() {
        return this.state;
    }

    private void fromState(Integer state) {
        this.state = state == null ? 0 : state;
    }

    public Token<CppStringTokenId> nextToken() {
        int startState = this.state;
        this.state = 1;
        while (true) {
            int ch = this.read();
            switch (ch) {
                case 76: {
                    if (startState != 0) break;
                    return this.token(CppStringTokenId.PREFIX);
                }
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.token(CppStringTokenId.TEXT);
                    }
                    return null;
                }
                case 39: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    return this.token(CppStringTokenId.SINGLE_QUOTE);
                }
                case 34: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    return this.token(CppStringTokenId.DOUBLE_QUOTE);
                }
                case 92: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    ch = this.read();
                    switch (ch) {
                        case 98: {
                            return this.token(CppStringTokenId.BACKSPACE);
                        }
                        case 101: {
                            return this.token(CppStringTokenId.ANSI_COLOR);
                        }
                        case 102: {
                            return this.token(CppStringTokenId.FORM_FEED);
                        }
                        case 110: {
                            return this.token(CppStringTokenId.NEWLINE);
                        }
                        case 114: {
                            return this.token(CppStringTokenId.CR);
                        }
                        case 116: {
                            return this.token(CppStringTokenId.TAB);
                        }
                        case 39: {
                            return this.token(CppStringTokenId.SINGLE_QUOTE_ESCAPE);
                        }
                        case 34: {
                            return this.token(CppStringTokenId.DOUBLE_QUOTE_ESCAPE);
                        }
                        case 92: {
                            return this.token(CppStringTokenId.BACKSLASH_ESCAPE);
                        }
                        case 117: {
                            while (117 == (ch = this.read())) {
                            }
                            int i = 0;
                            while (true) {
                                if (!((ch = Character.toLowerCase(ch)) >= 48 && ch <= 57 || ch >= 97 && ch <= 102)) {
                                    this.input.backup(1);
                                    return this.token(CppStringTokenId.UNICODE_ESCAPE_INVALID);
                                }
                                if (i == 3) {
                                    return this.token(CppStringTokenId.UNICODE_ESCAPE);
                                }
                                ch = this.read();
                                ++i;
                            }
                        }
                        case 120: {
                            int len = 0;
                            block33: while (true) {
                                switch (this.read()) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        ++len;
                                        continue block33;
                                    }
                                }
                                break;
                            }
                            this.input.backup(1);
                            return this.token(len > 0 ? CppStringTokenId.HEX_ESCAPE : CppStringTokenId.HEX_ESCAPE_INVALID);
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            switch (this.read()) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    switch (this.read()) {
                                        case 48: 
                                        case 49: 
                                        case 50: 
                                        case 51: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 55: {
                                            return this.token(CppStringTokenId.OCTAL_ESCAPE);
                                        }
                                    }
                                    this.input.backup(1);
                                    return this.token(CppStringTokenId.OCTAL_ESCAPE);
                                }
                            }
                            this.input.backup(1);
                            return this.token(CppStringTokenId.OCTAL_ESCAPE);
                        }
                    }
                    this.input.backup(1);
                    return this.token(CppStringTokenId.ESCAPE_SEQUENCE_INVALID);
                }
            }
        }
    }

    protected final Token<CppStringTokenId> token(CppStringTokenId id) {
        return this.token(id, id.fixedText(), PartType.COMPLETE);
    }

    private Token<CppStringTokenId> token(CppStringTokenId id, String fixedText, PartType part) {
        assert (id != null) : "id must be not null";
        Token token = null;
        token = fixedText != null && !this.escapedLF ? this.tokenFactory.getFlyweightToken((TokenId)id, fixedText) : (part != PartType.COMPLETE ? this.tokenFactory.createToken((TokenId)id, this.input.readLength(), part) : this.tokenFactory.createToken((TokenId)id));
        this.escapedLF = false;
        assert (token != null) : "token must be created as result for " + (Object)((Object)id);
        return token;
    }

    protected final int read() {
        boolean skipEscapedLF = true;
        int c = this.input.read();
        if (skipEscapedLF) {
            while (c == 92) {
                int next = this.input.read();
                switch (next) {
                    case 13: {
                        this.input.consumeNewline();
                    }
                    case 10: {
                        this.escapedLF = true;
                        next = this.input.read();
                        break;
                    }
                    default: {
                        this.input.backup(1);
                        assert (c == 92) : "must be backslash " + (char)c;
                        return c;
                    }
                }
                c = next;
            }
        }
        return c;
    }

    public void release() {
    }
}

