/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.util.logging.Logger;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.node.CatalogNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakeDefaultCatalogAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(MakeDefaultCatalogAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(MakeDefaultCatalogAction.class, (String)"MakeDefaultCatalog");
    }

    protected boolean enable(Node[] activatedNodes) {
        CatalogNode node;
        boolean result = false;
        if (activatedNodes.length == 1 && (node = (CatalogNode)((Object)activatedNodes[0].getLookup().lookup(CatalogNode.class))) != null) {
            DatabaseConnector connector = ((DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class)).getConnector();
            result = connector.supportsCommand("SetDefaultDatabaseCommand");
        }
        return result;
    }

    protected void performAction(final Node[] activatedNodes) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                DatabaseConnection connection = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
                String name = ((CatalogNode)((Object)activatedNodes[0].getLookup().lookup(CatalogNode.class))).getName();
                try {
                    connection.setDefaultCatalog(name);
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MakeDefaultCatalogAction.class);
    }
}

