/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.modules.parsing.impl.indexing.IndexDocumentImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.lucene.DocumentUtil;
import org.netbeans.modules.parsing.impl.indexing.lucene.IndexCacheFactory;
import org.netbeans.modules.parsing.impl.indexing.lucene.LMListener;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneDocument;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndexManager;
import org.netbeans.modules.parsing.impl.indexing.lucene.TermComparator;
import org.netbeans.modules.parsing.impl.indexing.lucene.util.Evictable;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class LuceneIndex
implements IndexImpl,
Evictable {
    private static final RequestProcessor RP = new RequestProcessor(LuceneIndex.class.getName(), 1);
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private static final boolean debugIndexMerging = Boolean.getBoolean("LuceneIndex.debugIndexMerge");
    static final int VERSION = 1;
    private static final String CACHE_LOCK_PREFIX = "nb-lock";
    private final URL indexFolderUrl;
    private final File indexFolder;
    private volatile Directory directory;
    private volatile IndexReader reader;
    private volatile boolean closed;
    private boolean valid;
    private volatile boolean empty;
    private static final LMListener lmListener = new LMListener();
    private final List<LuceneDocument> toAdd = new LinkedList<LuceneDocument>();
    private final List<String> toRemove = new LinkedList<String>();
    private final Set<String> staleFiles = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(IndexDocumentImpl document) {
        boolean forceFlush;
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            assert (document instanceof LuceneDocument);
            this.toAdd.add((LuceneDocument)document);
            forceFlush = lmListener.isLowMemory();
        }
        if (forceFlush) {
            try {
                LOGGER.fine("Extra flush forced");
                this.store(false, null);
                System.gc();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, LuceneIndex.annotateException(ioe, this.indexFolder));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocument(String relativePath) {
        boolean forceFlush;
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            this.toRemove.add(relativePath);
            forceFlush = lmListener.isLowMemory();
        }
        if (forceFlush) {
            try {
                LOGGER.fine("Extra flush forced");
                this.store(false, null);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, LuceneIndex.annotateException(ioe, this.indexFolder));
            }
        }
    }

    @Override
    public void store(final boolean optimize, final Iterable<Indexable> indexedIndexables) throws IOException {
        LuceneIndexManager.getDefault().writeAccess(new LuceneIndexManager.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws IOException {
                LinkedList toRemove;
                LinkedList toAdd;
                LuceneIndex.this.checkPreconditions();
                LuceneIndex luceneIndex = LuceneIndex.this;
                synchronized (luceneIndex) {
                    toAdd = new LinkedList(LuceneIndex.this.toAdd);
                    toRemove = new LinkedList(LuceneIndex.this.toRemove);
                    LuceneIndex.this.toAdd.clear();
                    LuceneIndex.this.toRemove.clear();
                    if (!LuceneIndex.this.staleFiles.isEmpty()) {
                        if (indexedIndexables != null) {
                            for (Indexable i : indexedIndexables) {
                                LuceneIndex.this.staleFiles.remove(i.getRelativePath());
                            }
                        } else {
                            for (LuceneDocument ldoc : toAdd) {
                                LuceneIndex.this.staleFiles.remove(ldoc.getSourceName());
                            }
                            LuceneIndex.this.staleFiles.removeAll(toRemove);
                        }
                    }
                }
                if (toAdd.size() > 0 || toRemove.size() > 0) {
                    LuceneIndex.this.flush(LuceneIndex.this.indexFolder, toAdd, toRemove, LuceneIndex.this.directory, lmListener, optimize);
                }
                return null;
            }
        });
    }

    @Override
    public Collection<? extends IndexDocumentImpl> query(final String fieldName, final String value, final QuerySupport.Kind kind, final String ... fieldsToLoad) throws IOException {
        assert (fieldName != null);
        assert (value != null);
        assert (kind != null);
        return LuceneIndexManager.getDefault().readAccess(new LuceneIndexManager.Action<List<IndexDocumentImpl>>(){

            @Override
            public List<IndexDocumentImpl> run() throws IOException {
                LuceneIndex.this.checkPreconditions();
                if (LuceneIndex.this.empty) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Ignoring empty index: {0}", LuceneIndex.this.indexFolder.getAbsolutePath());
                    }
                    return Collections.emptyList();
                }
                IndexReader r = LuceneIndex.this.getReader();
                if (r != null) {
                    return LuceneIndex._query(r, fieldName, value, kind, fieldsToLoad);
                }
                return Collections.emptyList();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileModified(String relativePath) {
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + ", adding stale file: " + relativePath);
            }
            this.staleFiles.add(relativePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends String> getStaleFiles() {
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + ", stale files: " + this.staleFiles);
            }
            return new LinkedList<String>(this.staleFiles);
        }
    }

    public LuceneIndex(URL indexFolderUrl) throws IOException {
        assert (indexFolderUrl != null);
        try {
            this.indexFolderUrl = indexFolderUrl;
            this.indexFolder = new File(indexFolderUrl.toURI());
            this.directory = LuceneIndex.createDirectory(this.indexFolder);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void clear() throws IOException {
        this.checkPreconditions();
        LuceneIndexManager.getDefault().writeAccess(new LuceneIndexManager.Action<Void>(){

            @Override
            public Void run() throws IOException {
                LuceneIndex.this._clear();
                return null;
            }
        });
    }

    @Override
    public boolean isValid() throws IOException {
        this.checkPreconditions();
        boolean res = LuceneIndexManager.getDefault().readAccess(new LuceneIndexManager.Action<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                return LuceneIndex.this.valid;
            }
        });
        if (res) {
            return res;
        }
        res = LuceneIndexManager.getDefault().writeAccess(new LuceneIndexManager.Action<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                boolean res;
                boolean bl = res = LuceneIndex.this.directory.list().length == 0;
                if (!res) {
                    Collection locks = LuceneIndex.this.getOrphanLock();
                    res = locks.isEmpty();
                    if (res) {
                        try {
                            res = IndexReader.indexExists((Directory)LuceneIndex.this.directory);
                        }
                        catch (IOException e) {
                            res = false;
                        }
                        catch (RuntimeException e) {
                            LOGGER.log(Level.INFO, "Broken index: " + LuceneIndex.this.indexFolder.getAbsolutePath(), e);
                            res = false;
                        }
                        if (res) {
                            try {
                                LuceneIndex.this.getReader();
                            }
                            catch (IOException e) {
                                res = false;
                                LuceneIndex.this.clear();
                            }
                            catch (RuntimeException e) {
                                res = false;
                                LuceneIndex.this.clear();
                            }
                        }
                    } else {
                        LOGGER.warning("Broken (locked) index folder: " + LuceneIndex.this.indexFolder.getAbsolutePath());
                        for (String lockName : locks) {
                            LuceneIndex.this.directory.deleteFile(lockName);
                        }
                        LuceneIndex.this.clear();
                    }
                }
                LuceneIndex.this.valid = res;
                return res;
            }
        });
        return res;
    }

    public void close() throws IOException {
        this.checkPreconditions();
        LuceneIndexManager.getDefault().writeAccess(new LuceneIndexManager.Action<Void>(){

            @Override
            public Void run() throws IOException {
                LuceneIndex.this._close();
                return null;
            }
        });
    }

    @Override
    public void evicted() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    LuceneIndexManager.getDefault().writeAccess(new LuceneIndexManager.Action<Void>(){

                        @Override
                        public Void run() throws IOException {
                            LuceneIndex.this._closeReader();
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Evicted index: " + LuceneIndex.this.indexFolder.getAbsolutePath());
                            }
                            return null;
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void _hit() {
        IndexCacheFactory.getDefault().getCache().put(this.indexFolderUrl, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clear() throws IOException {
        block14: {
            this._closeReader();
            try {
                File cacheDir;
                File[] children;
                boolean dirty = false;
                try {
                    String[] content;
                    for (String file : content = this.directory.list()) {
                        try {
                            this.directory.deleteFile(file);
                        }
                        catch (IOException e) {
                            if (!this.directory.fileExists(file)) continue;
                            dirty = true;
                        }
                    }
                }
                finally {
                    this._closeDirectory();
                }
                if (!dirty || (children = (cacheDir = ((FSDirectory)this.directory).getFile()).listFiles()) == null) break block14;
                for (File child : children) {
                    if (child.delete()) continue;
                    Class<?> c = this.directory.getClass();
                    int refCount = -1;
                    try {
                        Field field = c.getDeclaredField("refCount");
                        field.setAccessible(true);
                        refCount = field.getInt(this.directory);
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                    throw new IOException("Cannot delete: " + child.getAbsolutePath() + "(" + child.exists() + "," + child.canRead() + "," + child.canWrite() + "," + cacheDir.canRead() + "," + cacheDir.canWrite() + "," + refCount + ")");
                }
            }
            finally {
                this.directory = LuceneIndex.createDirectory(this.indexFolder);
                this.closed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close() throws IOException {
        try {
            this._closeReader();
        }
        finally {
            this._closeDirectory();
        }
    }

    private void _closeReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private void _closeDirectory() throws IOException {
        this.directory.close();
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IndexDocumentImpl> _query(IndexReader in, String fieldName, String value, QuerySupport.Kind kind, String ... fieldsToLoad) throws IOException {
        LinkedList<IndexDocumentImpl> result = new LinkedList<IndexDocumentImpl>();
        TreeSet<Term> toSearch = new TreeSet<Term>(new TermComparator());
        switch (kind) {
            case EXACT: {
                toSearch.add(new Term(fieldName, value));
                break;
            }
            case PREFIX: {
                Term nameTerm;
                if (value.length() == 0) {
                    if (fieldName.length() == 0) {
                        LuceneIndex.emptyPrefixSearch(in, fieldsToLoad, result);
                        return result;
                    }
                    nameTerm = new Term(fieldName, value);
                    LuceneIndex.fieldSearch(nameTerm, in, toSearch);
                    break;
                }
                nameTerm = new Term(fieldName, value);
                LuceneIndex.prefixSearch(nameTerm, in, toSearch);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                Term nameTerm;
                if (value.length() == 0) {
                    if (fieldName.length() == 0) {
                        LuceneIndex.emptyPrefixSearch(in, fieldsToLoad, result);
                        return result;
                    }
                    nameTerm = new Term(fieldName, value);
                    LuceneIndex.fieldSearch(nameTerm, in, toSearch);
                    break;
                }
                nameTerm = new Term(fieldName, value.toLowerCase());
                LuceneIndex.prefixSearch(nameTerm, in, toSearch);
                break;
            }
            case CAMEL_CASE: {
                int index;
                if (value.length() == 0) {
                    throw new IllegalArgumentException();
                }
                StringBuilder sb = new StringBuilder();
                String prefix = null;
                int lastIndex = 0;
                do {
                    String token = value.substring(lastIndex, (index = LuceneIndex.findNextUpper(value, lastIndex + 1)) == -1 ? value.length() : index);
                    if (lastIndex == 0) {
                        prefix = token;
                    }
                    sb.append(token);
                    sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    lastIndex = index;
                } while (index != -1);
                Pattern pattern = Pattern.compile(sb.toString());
                LuceneIndex.regExpSearch(pattern, new Term(fieldName, prefix), in, toSearch);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (value.length() == 0) {
                    throw new IllegalArgumentException();
                }
                Pattern pattern = Pattern.compile(value, 2);
                if (Character.isJavaIdentifierStart(value.charAt(0))) {
                    LuceneIndex.regExpSearch(pattern, new Term(fieldName, value.toLowerCase()), in, toSearch);
                    break;
                }
                LuceneIndex.regExpSearch(pattern, new Term(fieldName, ""), in, toSearch);
                break;
            }
            case REGEXP: {
                if (value.length() == 0) {
                    throw new IllegalArgumentException();
                }
                Pattern pattern = Pattern.compile(value);
                if (Character.isJavaIdentifierStart(value.charAt(0))) {
                    LuceneIndex.regExpSearch(pattern, new Term(fieldName, value), in, toSearch);
                    break;
                }
                LuceneIndex.regExpSearch(pattern, new Term(fieldName, ""), in, toSearch);
                break;
            }
            case CASE_INSENSITIVE_CAMEL_CASE: {
                int index;
                Term nameTerm;
                if (value.length() == 0) {
                    if (fieldName.length() == 0) {
                        LuceneIndex.emptyPrefixSearch(in, fieldsToLoad, result);
                        return result;
                    }
                    nameTerm = new Term(fieldName, value);
                    LuceneIndex.fieldSearch(nameTerm, in, toSearch);
                    break;
                }
                nameTerm = new Term(fieldName, value.toLowerCase());
                LuceneIndex.prefixSearch(nameTerm, in, toSearch);
                StringBuilder sb = new StringBuilder();
                String prefix = null;
                int lastIndex = 0;
                do {
                    String token = value.substring(lastIndex, (index = LuceneIndex.findNextUpper(value, lastIndex + 1)) == -1 ? value.length() : index);
                    if (lastIndex == 0) {
                        prefix = token;
                    }
                    sb.append(token);
                    sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    lastIndex = index;
                } while (index != -1);
                Pattern pattern = Pattern.compile(sb.toString());
                LuceneIndex.regExpSearch(pattern, new Term(fieldName, prefix), in, toSearch);
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        TermDocs tds = in.termDocs();
        TreeSet<Integer> docNums = new TreeSet<Integer>();
        try {
            int[] docs = new int[25];
            int[] freq = new int[25];
            for (Term t : toSearch) {
                int len;
                tds.seek(t);
                while ((len = tds.read(docs, freq)) > 0) {
                    for (int i = 0; i < len; ++i) {
                        docNums.add(docs[i]);
                    }
                }
            }
        }
        finally {
            tds.close();
        }
        FieldSelector selector = DocumentUtil.selector(fieldsToLoad);
        for (Integer docNum : docNums) {
            Document doc = in.document(docNum.intValue(), selector);
            result.add(new LuceneDocument(doc));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void flush(File indexFolder, List<LuceneDocument> toAdd, List<String> toRemove, Directory directory, LMListener lmListener, boolean optimize) throws IOException {
        LOGGER.log(Level.FINE, "Flushing: {0}", indexFolder);
        try {
            assert (LuceneIndexManager.getDefault().holdsWriteLock());
            this._hit();
            boolean exists = IndexReader.indexExists((Directory)this.directory);
            IndexWriter out = new IndexWriter(directory, (Analyzer)new KeywordAnalyzer(), !exists, IndexWriter.MaxFieldLength.LIMITED);
            try {
                void var10_19;
                if (exists) {
                    Iterator<String> it = toRemove.iterator();
                    while (it.hasNext()) {
                        String string = it.next();
                        it.remove();
                        out.deleteDocuments(DocumentUtil.sourceNameQuery(string));
                    }
                    for (LuceneDocument luceneDocument : toAdd) {
                        out.deleteDocuments(DocumentUtil.sourceNameQuery(luceneDocument.getSourceName()));
                    }
                }
                if (debugIndexMerging) {
                    out.setInfoStream(System.err);
                }
                RAMDirectory memDir = null;
                Object var10_15 = null;
                if (lmListener.isLowMemory()) {
                    IndexWriter indexWriter = out;
                } else {
                    memDir = new RAMDirectory();
                    IndexWriter indexWriter = new IndexWriter((Directory)memDir, (Analyzer)new KeywordAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
                }
                Iterator<LuceneDocument> it = toAdd.iterator();
                while (it.hasNext()) {
                    LuceneDocument doc = it.next();
                    it.remove();
                    var10_19.addDocument(doc.doc);
                    if (memDir != null && lmListener.isLowMemory()) {
                        var10_19.close();
                        out.addIndexesNoOptimize(new Directory[]{memDir});
                        memDir = new RAMDirectory();
                        IndexWriter indexWriter = new IndexWriter((Directory)memDir, (Analyzer)new KeywordAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
                    }
                    LOGGER.log(Level.FINEST, "LuceneDocument merged: {0}", doc);
                }
                if (memDir != null) {
                    var10_19.close();
                    out.addIndexesNoOptimize(new Directory[]{memDir});
                    Object var10_21 = null;
                    memDir = null;
                }
                if (optimize) {
                    out.optimize(false);
                }
            }
            finally {
                this.empty = false;
                try {
                    out.close();
                }
                finally {
                    this.refreshReader();
                }
            }
        }
        catch (LockObtainFailedException e) {
            String msg = "Valid: " + this.valid + " Locks: " + this.getOrphanLock();
            throw (LockObtainFailedException)Exceptions.attachMessage((Throwable)e, (String)msg);
        }
        finally {
            LOGGER.log(Level.FINE, "Index flushed: {0}", indexFolder);
        }
    }

    private void checkPreconditions() throws IOException {
        if (this.closed) {
            throw new IOException("Index already closed: " + this.indexFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader getReader() throws IOException {
        this._hit();
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            Object r = this.reader;
            if (r == null) {
                try {
                    r = this.reader = new NoNormsReader(IndexReader.open((Directory)this.directory));
                }
                catch (FileNotFoundException fnf) {
                    this.empty = true;
                    LOGGER.fine(String.format("LuceneIndex[%s] does not exist.", this.toString()));
                }
                catch (IOException ioe) {
                    throw LuceneIndex.annotateException(ioe, this.indexFolder);
                }
            }
            return r;
        }
    }

    private synchronized void refreshReader() throws IOException {
        IndexReader newReader;
        if (this.reader != null && (newReader = this.reader.reopen()) != this.reader) {
            this.reader.close();
            this.reader = newReader;
        }
    }

    private static Directory createDirectory(File indexFolder) throws IOException {
        assert (indexFolder != null);
        FSDirectory directory = FSDirectory.getDirectory((File)indexFolder);
        directory.getLockFactory().setLockPrefix(CACHE_LOCK_PREFIX);
        return directory;
    }

    private Collection<? extends String> getOrphanLock() {
        String[] content = this.indexFolder.list();
        LinkedList<String> locks = new LinkedList<String>();
        for (String name : content) {
            if (!name.startsWith(CACHE_LOCK_PREFIX)) continue;
            locks.add(name);
        }
        return locks;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.indexFolder.getAbsolutePath() + "]";
    }

    private static IOException annotateException(IOException ioe, File indexFolder) {
        String message;
        File[] children;
        File[] fileArray = children = indexFolder == null ? null : indexFolder.listFiles();
        if (children == null) {
            message = "Non existing index folder";
        } else {
            StringBuilder b = new StringBuilder();
            b.append("Index folder: ").append(indexFolder.getAbsolutePath()).append("\n");
            for (File c : children) {
                b.append(c.getName()).append(" f: ").append(c.isFile()).append(" r: ").append(c.canRead()).append(" w: ").append(c.canWrite()).append("\n");
            }
            message = b.toString();
        }
        return (IOException)Exceptions.attachMessage((Throwable)ioe, (String)message);
    }

    private static void emptyPrefixSearch(IndexReader in, String[] fieldsToLoad, List<? super IndexDocumentImpl> result) throws IOException {
        int bound = in.maxDoc();
        for (int i = 0; i < bound; ++i) {
            Document doc;
            if (in.isDeleted(i) || (doc = in.document(i, DocumentUtil.selector(fieldsToLoad))) == null) continue;
            result.add(new LuceneDocument(doc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fieldSearch(Term valueTerm, IndexReader in, Set<? super Term> toSearch) throws IOException {
        String prefixField = valueTerm.field();
        TermEnum en = in.terms(valueTerm);
        try {
            Term term;
            while ((term = en.term()) != null && prefixField == term.field()) {
                toSearch.add((Term)term);
                if (en.next()) continue;
                break;
            }
        }
        finally {
            en.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prefixSearch(Term valueTerm, IndexReader in, Set<? super Term> toSearch) throws IOException {
        String prefixField = valueTerm.field();
        String name = valueTerm.text();
        TermEnum en = in.terms(valueTerm);
        try {
            Term term;
            while ((term = en.term()) != null && prefixField == term.field() && term.text().startsWith(name)) {
                toSearch.add((Term)term);
                if (en.next()) continue;
                break;
            }
        }
        finally {
            en.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void regExpSearch(Pattern pattern, Term startTerm, IndexReader in, Set<? super Term> toSearch) throws IOException {
        String startPrefix;
        String startText = startTerm.text();
        if (startText.length() > 0) {
            char c;
            StringBuilder startBuilder = new StringBuilder();
            startBuilder.append(startText.charAt(0));
            for (int i = 1; i < startText.length() && Character.isJavaIdentifierPart(c = startText.charAt(i)); ++i) {
                startBuilder.append(c);
            }
            startPrefix = startBuilder.toString();
            startTerm = new Term(startTerm.field(), startPrefix);
        } else {
            startPrefix = startText;
        }
        String camelField = startTerm.field();
        TermEnum en = in.terms(startTerm);
        try {
            Term term;
            while ((term = en.term()) != null && camelField == term.field() && term.text().startsWith(startPrefix)) {
                Matcher m = pattern.matcher(term.text());
                if (m.matches()) {
                    toSearch.add((Term)term);
                }
                if (en.next()) continue;
                break;
            }
        }
        finally {
            en.close();
        }
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static final class NoNormsReader
    extends FilterIndexReader {
        private byte[] norms;

        public NoNormsReader(IndexReader reader) {
            super(reader);
        }

        public byte[] norms(String field) throws IOException {
            byte[] fakes = this.fakeNorms();
            return fakes;
        }

        public void norms(String field, byte[] norm, int offset) throws IOException {
            byte[] fakes = this.fakeNorms();
            System.arraycopy(fakes, 0, norm, offset, fakes.length);
        }

        public boolean hasNorms(String field) throws IOException {
            return false;
        }

        protected void doSetNorm(int doc, String field, byte norm) throws CorruptIndexException, IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doClose() throws IOException {
            NoNormsReader noNormsReader = this;
            synchronized (noNormsReader) {
                this.norms = null;
            }
            super.doClose();
        }

        public IndexReader reopen() throws IOException {
            IndexReader newIn = this.in.reopen();
            if (newIn == this.in) {
                return this;
            }
            return new NoNormsReader(newIn);
        }

        private synchronized byte[] fakeNorms() {
            if (this.norms == null) {
                this.norms = new byte[this.maxDoc()];
                Arrays.fill(this.norms, DefaultSimilarity.encodeNorm((float)1.0f));
            }
            return this.norms;
        }
    }
}

