/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.Project;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.text.NbDocument;

public class ConfigurationHighlightsLayerFactory
implements HighlightsLayerFactory {
    static String PROP_HIGLIGHT_HEADER_LAYER = "mobility-embedded-headers-highlighting-layer";
    static String PROP_HIGLIGHT_BLOCKS_LAYER = "mobility-embedded-blocks-highlighting-layer";
    private static final Logger LOG = Logger.getLogger(ConfigurationHighlightsLayerFactory.class.getName());

    public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
        return new HighlightsLayer[]{HighlightsLayer.create((String)PROP_HIGLIGHT_HEADER_LAYER, (ZOrder)ZOrder.SYNTAX_RACK.forPosition(120), (boolean)true, (HighlightsContainer)new HeadersHighlighting(context.getDocument())), HighlightsLayer.create((String)PROP_HIGLIGHT_BLOCKS_LAYER, (ZOrder)ZOrder.BOTTOM_RACK.forPosition(110), (boolean)true, (HighlightsContainer)new BlocksHighlighting(context.getDocument()))};
    }

    private static final class BlocksHighlighting
    extends AbstractHighlightsContainer
    implements Highlighting {
        private final Document document;
        private final OffsetsBag blocksBag;
        private final AttributeSet activeBlockHighlight;
        private final AttributeSet inactiveBlockHighlight;

        public BlocksHighlighting(Document document) {
            this.document = document;
            this.document.putProperty(PROP_HIGLIGHT_BLOCKS_LAYER, this);
            AttributeSet extendsEolEmptyLine = AttributesUtilities.createImmutable((Object[])new Object[]{HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE, HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE, Boolean.TRUE});
            FontColorSettings settings = (FontColorSettings)MimeLookup.getLookup((String)"text/x-java-preprocessor").lookup(FontColorSettings.class);
            AttributeSet as = settings.getTokenFontColors("pp-active-block");
            this.activeBlockHighlight = as != null ? AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{as, extendsEolEmptyLine}) : null;
            as = settings.getTokenFontColors("pp-inactive-block");
            this.inactiveBlockHighlight = as != null ? AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{as, extendsEolEmptyLine}) : null;
            if (this.activeBlockHighlight != null && this.inactiveBlockHighlight != null) {
                this.blocksBag = new OffsetsBag(document, true);
                this.blocksBag.addHighlightsChangeListener(new HighlightsChangeListener(){

                    public void highlightChanged(HighlightsChangeEvent event) {
                        BlocksHighlighting.this.fireHighlightsChange(event.getStartOffset(), event.getEndOffset());
                    }
                });
                this.updateBags();
            } else {
                this.blocksBag = null;
            }
        }

        public HighlightsSequence getHighlights(int startOffset, int endOffset) {
            if (this.blocksBag != null) {
                return this.blocksBag.getHighlights(startOffset, endOffset);
            }
            return HighlightsSequence.EMPTY;
        }

        @Override
        public void updateBags() {
            Project p = J2MEProjectUtils.getProjectForDocument((Document)this.document);
            if (p == null || !(p instanceof J2MEProject) || this.blocksBag == null) {
                return;
            }
            List blockList = (List)this.document.getProperty("preprocessor.block.list");
            if (blockList == null) {
                return;
            }
            final OffsetsBag bag = new OffsetsBag(this.document, true);
            LOG.log(Level.FINE, "Dumping lineset({0})", blockList.size());
            for (PPBlockInfo b : blockList) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "lineBlock: type={0}, startLine={1}, endLine={2}, active={3}", new Object[]{b.getType(), b.getStartLine(), b.getEndLine(), b.isActive()});
                }
                StyledDocument doc = (StyledDocument)this.document;
                bag.addHighlight(NbDocument.findLineRootElement((StyledDocument)doc).getElement(b.getStartLine() - 1).getStartOffset(), NbDocument.findLineRootElement((StyledDocument)doc).getElement(b.getEndLine() - 1).getEndOffset(), b.isActive() ? this.activeBlockHighlight : this.inactiveBlockHighlight);
            }
            LOG.log(Level.FINE, "-------------------");
            this.document.render(new Runnable(){

                @Override
                public void run() {
                    BlocksHighlighting.this.blocksBag.setHighlights(bag);
                }
            });
        }
    }

    private static final class HeadersHighlighting
    extends AbstractHighlightsContainer
    implements Highlighting {
        private static final Pattern BLOCK_HEADER_PATTERN = Pattern.compile("^\\s*/((/#)|(\\*[\\$#]))\\S");
        private final Document document;
        private final OffsetsBag headersBag;
        private final AttributeSet commandHighlight;

        public HeadersHighlighting(Document document) {
            this.document = document;
            this.document.putProperty(PROP_HIGLIGHT_HEADER_LAYER, this);
            FontColorSettings settings = (FontColorSettings)MimeLookup.getLookup((String)"text/x-java-preprocessor").lookup(FontColorSettings.class);
            this.commandHighlight = settings.getTokenFontColors("pp-command");
            if (this.commandHighlight != null) {
                this.headersBag = new OffsetsBag(document);
                this.headersBag.addHighlightsChangeListener(new HighlightsChangeListener(){

                    public void highlightChanged(HighlightsChangeEvent event) {
                        HeadersHighlighting.this.fireHighlightsChange(event.getStartOffset(), event.getEndOffset());
                    }
                });
                this.updateBags();
            } else {
                this.headersBag = null;
            }
        }

        public HighlightsSequence getHighlights(int startOffset, int endOffset) {
            if (this.headersBag != null) {
                return this.headersBag.getHighlights(startOffset, endOffset);
            }
            return HighlightsSequence.EMPTY;
        }

        @Override
        public void updateBags() {
            Project p = J2MEProjectUtils.getProjectForDocument((Document)this.document);
            if (p == null || !(p instanceof J2MEProject) || this.headersBag == null) {
                return;
            }
            final OffsetsBag bag = new OffsetsBag(this.document, true);
            Element root = NbDocument.findLineRootElement((StyledDocument)((StyledDocument)this.document));
            int count = root.getElementCount();
            try {
                for (int i = 0; i < count; ++i) {
                    Element elm = root.getElement(i);
                    if (!BLOCK_HEADER_PATTERN.matcher(this.document.getText(elm.getStartOffset(), elm.getEndOffset() - elm.getStartOffset()).trim()).find()) continue;
                    bag.addHighlight(elm.getStartOffset(), elm.getEndOffset(), this.commandHighlight);
                }
            }
            catch (BadLocationException ex) {
                return;
            }
            this.document.render(new Runnable(){

                @Override
                public void run() {
                    HeadersHighlighting.this.headersBag.setHighlights(bag);
                }
            });
        }
    }

    static interface Highlighting {
        public void updateBags();
    }
}

