/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.openide.util.NbBundle;

public class TileCellRenderer
extends JComponent
implements ListCellRenderer {
    private static final int MIN_TILE_SIZE = 30;
    private int padX;
    private int padY;
    private static final Color MOST_COLOR = ColorConstants.COLOR_OUTLINE_SELECTED;
    private static final Color NO_COLOR = ColorConstants.COLOR_OUTLINE_PLAIN;
    private static final Color MEDIUM_COLOR = ColorConstants.COLOR_OUTLINE_HILITE;
    private StaticTile tile;
    private boolean isSelected;
    private boolean hasFocus;

    public TileCellRenderer(int n, int n2) {
        this.padX = n;
        this.padY = n2;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return NbBundle.getMessage(TileCellRenderer.class, (String)"TileCellRenderer.tooltip", (Object)this.tile.getIndex());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Color color = this.isSelected && this.hasFocus ? MOST_COLOR : (this.isSelected ? MEDIUM_COLOR : NO_COLOR);
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.padX, this.getHeight());
        graphics.fillRect(this.getWidth() - this.padX, 0, this.padX, this.getHeight());
        graphics.fillRect(this.padX, 0, this.getWidth() - 2 * this.padX, this.padY);
        graphics.fillRect(this.padX, this.getHeight() - this.padY, this.getWidth() - 2 * this.padX, this.padY);
        if (this.tile != null) {
            this.tile.paint((Graphics2D)graphics, this.padX, this.padY, this.getWidth() - 2 * this.padX, this.getHeight() - 2 * this.padY);
        }
        graphics.setColor(Color.WHITE);
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.paintBorder(graphics);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof StaticTile) {
            float f;
            StaticTile staticTile;
            this.tile = staticTile = (StaticTile)object;
            this.isSelected = bl;
            this.hasFocus = bl2;
            int n2 = staticTile.getWidth();
            int n3 = staticTile.getHeight();
            int n4 = n2;
            int n5 = n3;
            if (n2 < n3 && n2 < 30) {
                f = 30.0f / (float)n2;
                n4 = 30;
                n5 = (int)((float)n5 * f);
            } else if (n3 < n2 && n3 < 30) {
                f = 30.0f / (float)n3;
                n5 = 30;
                n4 = (int)((float)n4 * f);
            } else if (n3 == n2 && n3 < 30) {
                n4 = 30;
                n5 = 30;
            }
            Dimension dimension = new Dimension(n4 + 2 * this.padX, n5 + 2 * this.padY);
            this.setPreferredSize(dimension);
            return this;
        }
        throw new IllegalArgumentException("Only org.netbeans.mobility.game.model.Tile or java.lang.Integer can be rendered.");
    }
}

