/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.server.manager.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.identity.profile.api.configurator.Configurator;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.ProviderConfigurator;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.server.manager.api.ServerInstance;
import org.netbeans.modules.identity.server.manager.ui.EditDialogDescriptor;
import org.netbeans.modules.identity.server.manager.ui.UserNamePasswordEditorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ProfileEditorPanel
extends JPanel
implements ChangeListener,
EditDialogDescriptor.Panel {
    private static final long WAIT_TIME = 400L;
    private static final String JKS_EXTENSION = ".jks";
    private static final String HELP_ID = "idmtools_am_config_am_sec_mech";
    private static final String AM_INVALID_KEYSTORE_ERR = "Invalid KeyStore";
    private transient ProviderConfigurator configurator;
    private transient SecurityMechanism secMech;
    private ServerInstance instance;
    private Collection<ChangeListener> listeners;
    private Throwable cause;
    private State state;
    private JButton addButton;
    private JButton browseButton;
    private JLabel certSettingsLabel;
    private JButton editButton;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JLabel keyAliasLabel;
    private JTextField keyAliasTF;
    private JLabel keyPasswordLabel;
    private JPasswordField keyPasswordTF;
    private JLabel keystoreLocationLabel;
    private JTextField keystoreLocationTF;
    private JLabel keystorePasswordLabel;
    private JPasswordField keystorePasswordTF;
    private JButton removeButton;
    private JCheckBox signResponseCB;
    private JCheckBox useDefaultKeyStoreCB;
    private JTable userNameTable;
    private JScrollPane userNameTableScrollPane;
    private JLabel usernameInfoDescLabel;
    private JLabel usernameInfoLabel;

    public ProfileEditorPanel(SecurityMechanism securityMechanism, ServerInstance serverInstance) {
        this.initComponents();
        this.secMech = securityMechanism;
        this.instance = serverInstance;
        this.listeners = new ArrayList<ChangeListener>();
        this.state = State.INITIALIZING;
        this.initVisualState();
        this.initConfiguratorAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfiguratorAsync() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                ProfileEditorPanel.this.initConfigurator();
            }
        };
        thread.start();
        thread = new Thread(){

            @Override
            public void run() {
                ProfileEditorPanel.this.pingServer();
            }
        };
        thread.start();
        ProfileEditorPanel profileEditorPanel = this;
        synchronized (profileEditorPanel) {
            try {
                this.wait(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void initConfigurator() {
        try {
            this.configurator = ProviderConfigurator.getConfigurator((String)this.secMech.getName(), (ProviderConfigurator.Type)ProviderConfigurator.Type.WSP, (Configurator.AccessMethod)Configurator.AccessMethod.DYNAMIC, (Object)this.instance.getServerProperties(), (String)this.instance.getID());
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ProfileEditorPanel.this.configurator.addModifier(ProviderConfigurator.Configurable.SIGN_RESPONSE, (Object)ProfileEditorPanel.this.signResponseCB);
                    ProfileEditorPanel.this.configurator.addModifier(ProviderConfigurator.Configurable.USE_DEFAULT_KEYSTORE, (Object)ProfileEditorPanel.this.useDefaultKeyStoreCB);
                    ProfileEditorPanel.this.configurator.addModifier(ProviderConfigurator.Configurable.KEYSTORE_LOCATION, (Object)ProfileEditorPanel.this.keystoreLocationTF);
                    ProfileEditorPanel.this.configurator.addModifier(ProviderConfigurator.Configurable.KEYSTORE_PASSWORD, (Object)ProfileEditorPanel.this.keystorePasswordTF);
                    ProfileEditorPanel.this.configurator.addModifier(ProviderConfigurator.Configurable.KEY_ALIAS, (Object)ProfileEditorPanel.this.keyAliasTF);
                    ProfileEditorPanel.this.configurator.addModifier(ProviderConfigurator.Configurable.KEY_PASSWORD, (Object)ProfileEditorPanel.this.keyPasswordTF);
                    ProfileEditorPanel.this.configurator.addModifier(ProviderConfigurator.Configurable.USERNAME_PASSWORD_PAIRS, (Object)ProfileEditorPanel.this.userNameTable);
                    ProfileEditorPanel.this.enableAllComponents();
                    ProfileEditorPanel.this.initUserNameTable();
                    ProfileEditorPanel.this.updateVisualState();
                }
            });
            this.updateState(State.INITIALIZED);
            this.configurator.addChangeListener((ChangeListener)this);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ConfiguratorException configuratorException) {
            this.cause = configuratorException.getCause();
            this.updateState(State.INIT_FAILED);
        }
    }

    private void pingServer() {
        if (!this.instance.isRunning()) {
            this.updateState(State.NOT_RUNNING);
        }
    }

    private synchronized void updateState(State state) {
        this.state = state;
        this.fireStateChanged();
    }

    private void initUserNameTable() {
        if (this.secMech.isPasswordCredentialRequired()) {
            final ListSelectionModel listSelectionModel = this.userNameTable.getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    if (listSelectionModel.isSelectionEmpty()) {
                        ProfileEditorPanel.this.editButton.setEnabled(false);
                        ProfileEditorPanel.this.removeButton.setEnabled(false);
                    } else {
                        ProfileEditorPanel.this.editButton.setEnabled(true);
                        ProfileEditorPanel.this.removeButton.setEnabled(true);
                    }
                }
            });
            TableColumn tableColumn = this.userNameTable.getColumn(this.userNameTable.getColumnName(1));
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object object) {
                    if (object instanceof String) {
                        StringBuffer stringBuffer = new StringBuffer((String)object);
                        int n = stringBuffer.length();
                        for (int i = 0; i < n; ++i) {
                            stringBuffer.setCharAt(i, '*');
                        }
                        object = stringBuffer.toString();
                    }
                    super.setValue(object);
                }
            });
        }
    }

    private void initVisualState() {
        if (this.secMech.isLiberty()) {
            this.signResponseCB.setSelected(true);
            this.signResponseCB.setEnabled(false);
        }
        if (!this.secMech.isPasswordCredentialRequired()) {
            this.userNameTableScrollPane.setVisible(false);
            this.addButton.setVisible(false);
            this.editButton.setVisible(false);
            this.removeButton.setVisible(false);
            this.usernameInfoLabel.setVisible(false);
            this.usernameInfoDescLabel.setVisible(false);
        }
    }

    private void updateVisualState() {
        if (this.secMech.isPasswordCredentialRequired()) {
            if (this.signResponseCB.isSelected()) {
                this.certSettingsLabel.setEnabled(true);
                this.useDefaultKeyStoreCB.setEnabled(true);
                if (this.useDefaultKeyStoreCB.isSelected()) {
                    this.updateKeystoreVisualState(false);
                } else {
                    this.updateKeystoreVisualState(true);
                }
            } else {
                this.certSettingsLabel.setEnabled(false);
                this.useDefaultKeyStoreCB.setEnabled(false);
                this.updateKeystoreVisualState(false);
            }
        } else if (this.useDefaultKeyStoreCB.isSelected()) {
            this.updateKeystoreVisualState(false);
        } else {
            this.updateKeystoreVisualState(true);
        }
    }

    private void updateKeystoreVisualState(boolean bl) {
        this.keystoreLocationTF.setEnabled(bl);
        this.keystoreLocationLabel.setEnabled(bl);
        this.keystorePasswordTF.setEnabled(bl);
        this.keystorePasswordLabel.setEnabled(bl);
        this.keyAliasTF.setEnabled(bl);
        this.keyAliasLabel.setEnabled(bl);
        this.keyPasswordLabel.setEnabled(bl);
        this.keyPasswordTF.setEnabled(bl);
        if (bl) {
            if (this.instance.isLocal()) {
                this.browseButton.setEnabled(true);
            } else {
                this.browseButton.setEnabled(false);
            }
        } else {
            this.browseButton.setEnabled(false);
        }
    }

    public void enableAllComponents() {
        if (!this.secMech.isLiberty()) {
            this.signResponseCB.setEnabled(true);
        }
        this.certSettingsLabel.setEnabled(true);
        this.useDefaultKeyStoreCB.setEnabled(true);
        this.keystoreLocationTF.setEnabled(true);
        this.keystoreLocationLabel.setEnabled(true);
        this.keystorePasswordTF.setEnabled(true);
        this.keystorePasswordLabel.setEnabled(true);
        this.keyAliasTF.setEnabled(true);
        this.keyAliasLabel.setEnabled(true);
        this.browseButton.setEnabled(true);
        this.userNameTableScrollPane.setEnabled(true);
        this.addButton.setEnabled(true);
        this.usernameInfoLabel.setEnabled(true);
        this.usernameInfoDescLabel.setEnabled(true);
    }

    public void save() {
        if (this.configurator != null) {
            this.configurator.save();
        }
    }

    @Override
    public JComponent[] getEditableComponents() {
        return new JComponent[0];
    }

    public synchronized String checkValues() {
        switch (this.state) {
            case INITIALIZING: {
                return "Status:" + NbBundle.getMessage(ProfileEditorPanel.class, (String)"MSG_Initializing");
            }
            case NOT_RUNNING: {
                return NbBundle.getMessage(ProfileEditorPanel.class, (String)"MSG_ServerNotRunning");
            }
            case INIT_FAILED: {
                return NbBundle.getMessage(ProfileEditorPanel.class, (String)"MSG_InitFailed", (Object)this.cause.toString());
            }
            case INITIALIZED: {
                String string = this.configurator.getError();
                if (string != null && string.startsWith(AM_INVALID_KEYSTORE_ERR)) {
                    string = NbBundle.getMessage(ProfileEditorPanel.class, (String)"ERR_InvalidKeystore");
                }
                return string;
            }
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showUserNamePasswordEditor(boolean bl) {
        final UserNamePasswordEditorPanel userNamePasswordEditorPanel = new UserNamePasswordEditorPanel(bl, this.getUserNames());
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.userNameTable.getModel();
        int n = -1;
        if (!bl) {
            n = this.userNameTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            userNamePasswordEditorPanel.setUserName((String)defaultTableModel.getValueAt(n, 0));
            userNamePasswordEditorPanel.setPassword((String)defaultTableModel.getValueAt(n, 1));
        } else {
            n = defaultTableModel.getRowCount();
        }
        EditDialogDescriptor editDialogDescriptor = new EditDialogDescriptor(userNamePasswordEditorPanel, NbBundle.getMessage(ProfileEditorPanel.class, (String)"TTL_User"), bl, userNamePasswordEditorPanel.getEditableComponents(), this.getHelpCtx()){

            @Override
            public String validate() {
                return userNamePasswordEditorPanel.checkValues();
            }
        };
        Dialog dialog = null;
        try {
            dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialogDescriptor);
            dialog.setVisible(true);
            if (editDialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                String string = userNamePasswordEditorPanel.getUserName();
                String string2 = userNamePasswordEditorPanel.getPassword();
                if (!bl) {
                    defaultTableModel.setValueAt(string, n, 0);
                    defaultTableModel.setValueAt(string2, n, 1);
                    defaultTableModel.fireTableRowsUpdated(n, n);
                } else {
                    defaultTableModel.insertRow(n, new Object[]{string, string2});
                    defaultTableModel.fireTableRowsInserted(n, n);
                }
            }
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
    }

    private String[] getUserNames() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.userNameTable.getModel();
        int n = defaultTableModel.getRowCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)defaultTableModel.getValueAt(i, 0);
        }
        return stringArray;
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.signResponseCB = new JCheckBox();
        this.certSettingsLabel = new JLabel();
        this.keystoreLocationLabel = new JLabel();
        this.keystoreLocationTF = new JTextField();
        this.keystorePasswordLabel = new JLabel();
        this.keyAliasLabel = new JLabel();
        this.keyAliasTF = new JTextField();
        this.browseButton = new JButton();
        this.userNameTableScrollPane = new JScrollPane();
        this.userNameTable = new JTable();
        this.usernameInfoLabel = new JLabel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.usernameInfoDescLabel = new JLabel();
        this.keystorePasswordTF = new JPasswordField();
        this.useDefaultKeyStoreCB = new JCheckBox();
        this.keyPasswordLabel = new JLabel();
        this.keyPasswordTF = new JPasswordField();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/identity/server/manager/ui/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.signResponseCB, (String)resourceBundle.getString("LBL_SignResponse"));
        this.signResponseCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.signResponseCB.setEnabled(false);
        this.signResponseCB.setMargin(new Insets(0, 0, 0, 0));
        this.signResponseCB.setOpaque(false);
        this.signResponseCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditorPanel.this.signResponseCBActionPerformed(actionEvent);
            }
        });
        this.certSettingsLabel.setText(resourceBundle.getString("LBL_CertificateSettings"));
        this.certSettingsLabel.setEnabled(false);
        this.keystoreLocationLabel.setLabelFor(this.keystoreLocationTF);
        Mnemonics.setLocalizedText((JLabel)this.keystoreLocationLabel, (String)resourceBundle.getString("LBL_KeyStoreLocation"));
        this.keystoreLocationLabel.setEnabled(false);
        this.keystoreLocationTF.setEnabled(false);
        this.keystoreLocationTF.setNextFocusableComponent(this.browseButton);
        this.keystorePasswordLabel.setLabelFor(this.keystorePasswordTF);
        Mnemonics.setLocalizedText((JLabel)this.keystorePasswordLabel, (String)resourceBundle.getString("LBL_KeystorePassword"));
        this.keystorePasswordLabel.setEnabled(false);
        this.keyAliasLabel.setLabelFor(this.keyAliasTF);
        Mnemonics.setLocalizedText((JLabel)this.keyAliasLabel, (String)resourceBundle.getString("LBL_KeyAlias"));
        this.keyAliasLabel.setEnabled(false);
        this.keyAliasTF.setEnabled(false);
        this.keyAliasTF.setNextFocusableComponent(this.keyPasswordTF);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)resourceBundle.getString("LBL_Browse"));
        this.browseButton.setEnabled(false);
        this.browseButton.setNextFocusableComponent(this.keystorePasswordTF);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditorPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.userNameTableScrollPane.setEnabled(false);
        this.userNameTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.userNameTableScrollPane.setViewportView(this.userNameTable);
        this.usernameInfoLabel.setLabelFor(this.userNameTable);
        Mnemonics.setLocalizedText((JLabel)this.usernameInfoLabel, (String)resourceBundle.getString("LBL_UsernameTokenProfileInfo"));
        this.usernameInfoLabel.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)resourceBundle.getString("LBL_Add"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditorPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)resourceBundle.getString("LBL_Edit"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditorPanel.this.editButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)resourceBundle.getString("LBL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditorPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.usernameInfoDescLabel.setText(resourceBundle.getString("LBL_UsernameInfoDesc"));
        this.usernameInfoDescLabel.setEnabled(false);
        this.keystorePasswordTF.setEnabled(false);
        this.keystorePasswordTF.setNextFocusableComponent(this.keyAliasTF);
        Mnemonics.setLocalizedText((AbstractButton)this.useDefaultKeyStoreCB, (String)resourceBundle.getString("LBL_UseDefaultKeyStore"));
        this.useDefaultKeyStoreCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useDefaultKeyStoreCB.setEnabled(false);
        this.useDefaultKeyStoreCB.setMargin(new Insets(0, 0, 0, 0));
        this.useDefaultKeyStoreCB.setNextFocusableComponent(this.keystoreLocationTF);
        this.useDefaultKeyStoreCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditorPanel.this.useDefaultKeyStoreCBActionPerformed(actionEvent);
            }
        });
        this.keyPasswordLabel.setLabelFor(this.keyPasswordTF);
        Mnemonics.setLocalizedText((JLabel)this.keyPasswordLabel, (String)resourceBundle.getString("LBL_KeyAliasPassword"));
        this.keyPasswordLabel.setEnabled(false);
        this.keyPasswordTF.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.useDefaultKeyStoreCB)).add((Component)this.signResponseCB).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.certSettingsLabel).addPreferredGap(0, 316, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.keystorePasswordLabel).add((Component)this.keyAliasLabel).add((Component)this.keystoreLocationLabel).add((Component)this.keyPasswordLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.keyPasswordTF, -1, 346, Short.MAX_VALUE).add((Component)this.keyAliasTF, -1, 346, Short.MAX_VALUE).add((Component)this.keystorePasswordTF, -1, 346, Short.MAX_VALUE).add(2, (Component)this.keystoreLocationTF, -1, 346, Short.MAX_VALUE)).add(7, 7, 7))).addPreferredGap(0).add((Component)this.browseButton)).add((Component)this.usernameInfoLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.editButton).addPreferredGap(0).add((Component)this.removeButton)).add((Component)this.usernameInfoDescLabel, -2, 558, Short.MAX_VALUE).add(2, (Component)this.userNameTableScrollPane, -1, 558, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.signResponseCB).addPreferredGap(0).add((Component)this.certSettingsLabel).addPreferredGap(0).add((Component)this.useDefaultKeyStoreCB, -2, 15, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keystoreLocationLabel).add((Component)this.browseButton).add((Component)this.keystoreLocationTF, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keystorePasswordLabel).add((Component)this.keystorePasswordTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyAliasLabel).add((Component)this.keyAliasTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyPasswordLabel).add((Component)this.keyPasswordTF, -2, -1, -2)).addPreferredGap(0).add((Component)this.usernameInfoLabel).addPreferredGap(0).add((Component)this.usernameInfoDescLabel).addPreferredGap(0).add((Component)this.userNameTableScrollPane, -2, 86, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.addButton).add((Component)this.editButton).add((Component)this.removeButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void useDefaultKeyStoreCBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    return file.getName().endsWith(ProfileEditorPanel.JKS_EXTENSION);
                }
                return true;
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ProfileEditorPanel.class, (String)"TXT_JavaKeyStore");
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.keystoreLocationTF.setText(jFileChooser.getSelectedFile().getPath());
        }
    }

    private void signResponseCBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.userNameTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.userNameTable.getModel();
        String string = (String)defaultTableModel.getValueAt(n, 0);
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ProfileEditorPanel.class, (String)"LBL_ReallyRemove", (Object)string), NbBundle.getMessage(ProfileEditorPanel.class, (String)"TTL_RemoveUser"), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION) {
            defaultTableModel.removeRow(n);
            defaultTableModel.fireTableRowsDeleted(n, n);
        }
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        this.showUserNamePasswordEditor(false);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.showUserNamePasswordEditor(true);
    }

    private static enum State {
        INITIALIZING,
        INITIALIZED,
        NOT_RUNNING,
        INIT_FAILED;

    }
}

