/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.CloseableURLClassLoader;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.Paths;
import com.sun.tools.javac.file.RegularFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.SymbolArchive;
import com.sun.tools.javac.file.ZipArchive;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.file.ZipFileIndexArchive;
import com.sun.tools.javac.main.JavacOption;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.main.RecognizedOptions;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacFileManager
implements StandardJavaFileManager {
    boolean useZipFileIndex;
    protected Log log;
    private Paths paths;
    private Options options;
    private FSInfo fsInfo;
    private final File uninited = new File("U N I N I T E D");
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    private File classOutDir = this.uninited;
    private File sourceOutDir = this.uninited;
    protected boolean mmappedIO;
    protected boolean ignoreSymbolFile;
    protected String classLoaderClass;
    protected Charset charset;
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';
    Map<File, Archive> archives = new HashMap<File, Archive>();
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final RelativePath.RelativeDirectory symbolFilePrefix = new RelativePath.RelativeDirectory("META-INF/sym/rt.jar/");
    private final Map<JavaFileObject, SoftReference<CharBuffer>> contentCache = new HashMap<JavaFileObject, SoftReference<CharBuffer>>();
    private String defaultEncodingName;
    private final ByteBufferCache byteBufferCache;
    private static JavacOption[] javacFileManagerOptions = RecognizedOptions.getJavacFileManagerOptions(new RecognizedOptions.GrumpyHelper());

    public static char[] toArray(CharBuffer buffer) {
        if (buffer.hasArray()) {
            return ((CharBuffer)buffer.compact().flip()).array();
        }
        return buffer.toString().toCharArray();
    }

    public static void preRegister(final Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make() {
                return new JavacFileManager(context, true, null);
            }
        });
    }

    public JavacFileManager(Context context, boolean register, Charset charset) {
        if (register) {
            context.put(JavaFileManager.class, this);
        }
        this.byteBufferCache = new ByteBufferCache();
        this.charset = charset;
        this.setContext(context);
    }

    public void setContext(Context context) {
        this.log = Log.instance(context);
        if (this.paths == null) {
            this.paths = Paths.instance(context);
        } else {
            this.paths.setContext(context);
        }
        this.options = Options.instance(context);
        this.fsInfo = FSInfo.instance(context);
        this.useZipFileIndex = System.getProperty("useJavaUtilZip") == null;
        this.mmappedIO = this.options.get("mmappedIO") != null;
        this.ignoreSymbolFile = this.options.get("ignore.symbol.file") != null;
        this.classLoaderClass = this.options.get("procloader");
    }

    public JavaFileObject getFileForInput(String name) {
        return this.getRegularFile(new File(name));
    }

    public JavaFileObject getRegularFile(File file) {
        return new RegularFileObject(this, file);
    }

    public JavaFileObject getFileForOutput(String classname, JavaFileObject.Kind kind, JavaFileObject sibling) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, classname, kind, sibling);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        ListBuffer<File> files = new ListBuffer<File>();
        for (String name : names) {
            files.append(new File(JavacFileManager.nullCheck(name)));
        }
        return this.getJavaFileObjectsFromFiles(files.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList((Object[])JavacFileManager.nullCheck(names)));
    }

    protected JavaFileObject.Kind getKind(String extension) {
        if (extension.equals(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (extension.equals(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (extension.equals(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    private static boolean isValidName(String name) {
        for (String s : name.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String className) {
        if (!JavacFileManager.isValidName(className)) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
    }

    private static void validatePackageName(String packageName) {
        if (packageName.length() > 0 && !JavacFileManager.isValidName(packageName)) {
            throw new IllegalArgumentException("Invalid packageName name: " + packageName);
        }
    }

    public static void testName(String name, boolean isValidPackageName, boolean isValidClassName) {
        try {
            JavacFileManager.validatePackageName(name);
            if (!isValidPackageName) {
                throw new AssertionError((Object)("Invalid package name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidPackageName) {
                throw new AssertionError((Object)("Valid package name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", name);
        }
        try {
            JavacFileManager.validateClassName(name);
            if (!isValidClassName) {
                throw new AssertionError((Object)("Invalid class name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidClassName) {
                throw new AssertionError((Object)("Valid class name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", name);
        }
    }

    private static void printAscii(String format, Object ... args) {
        String message;
        try {
            String ascii = "US-ASCII";
            message = new String(String.format(null, format, args).getBytes("US-ASCII"), "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        System.out.println(message);
    }

    private void listDirectory(File directory, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> l) {
        block12: {
            block11: {
                List<String> files;
                Archive archive = this.archives.get(directory);
                boolean isFile = this.fsInfo.isFile(directory);
                if (archive == null && !isFile) break block11;
                if (archive == null) {
                    try {
                        archive = this.openArchive(directory);
                    }
                    catch (IOException ex) {
                        this.log.error("error.reading.file", directory, ex.getLocalizedMessage());
                        return;
                    }
                }
                if ((files = archive.getFiles(subdirectory)) != null) {
                    while (!files.isEmpty()) {
                        String file = (String)files.head;
                        if (this.isValidFile(file, fileKinds)) {
                            l.append(archive.getFileObject(subdirectory, file));
                        }
                        files = files.tail;
                    }
                }
                if (!recurse) break block12;
                for (RelativePath.RelativeDirectory s : archive.getSubdirectories()) {
                    if (!subdirectory.contains(s)) continue;
                    this.listDirectory(directory, s, fileKinds, false, l);
                }
                break block12;
            }
            File d = subdirectory.getFile(directory);
            if (!this.caseMapCheck(d, subdirectory)) {
                return;
            }
            File[] files = d.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                String fname = f.getName();
                if (f.isDirectory()) {
                    if (!recurse || !SourceVersion.isIdentifier(fname)) continue;
                    this.listDirectory(directory, new RelativePath.RelativeDirectory(subdirectory, fname), fileKinds, recurse, l);
                    continue;
                }
                if (!this.isValidFile(fname, fileKinds)) continue;
                RegularFileObject fe = new RegularFileObject(this, fname, new File(d, fname));
                l.append(fe);
            }
        }
    }

    private boolean isValidFile(String s, Set<JavaFileObject.Kind> fileKinds) {
        int lastDot = s.lastIndexOf(".");
        String extn = lastDot == -1 ? s : s.substring(lastDot);
        JavaFileObject.Kind kind = this.getKind(extn);
        return fileKinds.contains((Object)kind);
    }

    private boolean caseMapCheck(File f, RelativePath name) {
        String path;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException ex) {
            return false;
        }
        char[] pcs = path.toCharArray();
        char[] ncs = name.path.toCharArray();
        int i = pcs.length - 1;
        int j = ncs.length - 1;
        while (i >= 0 && j >= 0) {
            while (i >= 0 && pcs[i] == File.separatorChar) {
                --i;
            }
            while (j >= 0 && ncs[j] == '/') {
                --j;
            }
            if (i < 0 || j < 0) continue;
            if (pcs[i] != ncs[j]) {
                return false;
            }
            --i;
            --j;
        }
        return j < 0;
    }

    protected Archive openArchive(File zipFileName) throws IOException {
        Archive archive = this.archives.get(zipFileName);
        if (archive == null) {
            File origZipFileName = zipFileName;
            if (!this.ignoreSymbolFile && this.paths.isBootClassPathRtJar(zipFileName)) {
                File file = zipFileName.getParentFile().getParentFile();
                if (new File(file.getName()).equals(new File("jre"))) {
                    file = file.getParentFile();
                }
                for (String name : symbolFileLocation) {
                    file = new File(file, name);
                }
                if (file.exists()) {
                    zipFileName = file;
                }
            }
            try {
                ZipFile zdir = null;
                boolean usePreindexedCache = false;
                String preindexCacheLocation = null;
                if (!this.useZipFileIndex) {
                    zdir = new ZipFile(zipFileName);
                } else {
                    usePreindexedCache = this.options.get("usezipindex") != null;
                    preindexCacheLocation = this.options.get("java.io.tmpdir");
                    String optCacheLoc = this.options.get("cachezipindexdir");
                    if (optCacheLoc != null && optCacheLoc.length() != 0) {
                        File cacheDir;
                        if (optCacheLoc.startsWith("\"")) {
                            optCacheLoc = optCacheLoc.endsWith("\"") ? optCacheLoc.substring(1, optCacheLoc.length() - 1) : optCacheLoc.substring(1);
                        }
                        if ((cacheDir = new File(optCacheLoc)).exists() && cacheDir.canWrite() && !(preindexCacheLocation = optCacheLoc).endsWith("/") && !preindexCacheLocation.endsWith(File.separator)) {
                            preindexCacheLocation = preindexCacheLocation + File.separator;
                        }
                    }
                }
                archive = origZipFileName == zipFileName ? (!this.useZipFileIndex ? new ZipArchive(this, zdir) : new ZipFileIndexArchive(this, ZipFileIndex.getZipFileIndex(zipFileName, null, usePreindexedCache, preindexCacheLocation, this.options.get("writezipindexfiles") != null))) : (!this.useZipFileIndex ? new SymbolArchive(this, origZipFileName, zdir, symbolFilePrefix) : new ZipFileIndexArchive(this, ZipFileIndex.getZipFileIndex(zipFileName, symbolFilePrefix, usePreindexedCache, preindexCacheLocation, this.options.get("writezipindexfiles") != null)));
            }
            catch (FileNotFoundException ex) {
                archive = new MissingArchive(zipFileName);
            }
            catch (IOException ex) {
                if (zipFileName.exists()) {
                    this.log.error("error.reading.file", zipFileName, ex.getLocalizedMessage());
                }
                archive = new MissingArchive(zipFileName);
            }
            this.archives.put(origZipFileName, archive);
        }
        return archive;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
    }

    @Override
    public void close() {
        Iterator<Archive> i = this.archives.values().iterator();
        while (i.hasNext()) {
            Archive a = i.next();
            i.remove();
            try {
                a.close();
            }
            catch (IOException iOException) {}
        }
    }

    CharBuffer getCachedContent(JavaFileObject file) {
        SoftReference<CharBuffer> r = this.contentCache.get(file);
        return r == null ? null : r.get();
    }

    void cache(JavaFileObject file, CharBuffer cb) {
        this.contentCache.put(file, new SoftReference<CharBuffer>(cb));
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    protected String getEncodingName() {
        String encName = this.options.get(OptionName.ENCODING);
        if (encName == null) {
            return this.getDefaultEncodingName();
        }
        return encName;
    }

    protected Source getSource() {
        String sourceName = this.options.get(OptionName.SOURCE);
        Source source = null;
        if (sourceName != null) {
            source = Source.lookup(sourceName);
        }
        return source != null ? source : Source.DEFAULT;
    }

    ByteBuffer makeByteBuffer(InputStream in) throws IOException {
        int limit = in.available();
        if (this.mmappedIO && in instanceof FileInputStream) {
            FileInputStream fin = (FileInputStream)in;
            return fin.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, limit);
        }
        if (limit < 1024) {
            limit = 1024;
        }
        ByteBuffer result = this.byteBufferCache.get(limit);
        int position = 0;
        while (in.available() != 0) {
            int count;
            if (position >= limit) {
                result = ByteBuffer.allocate(limit <<= 1).put((ByteBuffer)result.flip());
            }
            if ((count = in.read(result.array(), position, limit - position)) < 0) break;
            result.position(position += count);
        }
        return (ByteBuffer)result.flip();
    }

    void recycleByteBuffer(ByteBuffer bb) {
        this.byteBufferCache.put(bb);
    }

    CharsetDecoder getDecoder(String encodingName, boolean ignoreEncodingErrors) {
        Charset cs = this.charset == null ? Charset.forName(encodingName) : this.charset;
        CharsetDecoder decoder = cs.newDecoder();
        CodingErrorAction action = ignoreEncodingErrors ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return decoder.onMalformedInput(action).onUnmappableCharacter(action);
    }

    CharBuffer decode(ByteBuffer inbuf, boolean ignoreEncodingErrors) {
        CoderResult result;
        CharsetDecoder decoder;
        String encodingName = this.getEncodingName();
        try {
            decoder = this.getDecoder(encodingName, ignoreEncodingErrors);
        }
        catch (IllegalCharsetNameException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        catch (UnsupportedCharsetException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float factor = decoder.averageCharsPerByte() * 0.8f + decoder.maxCharsPerByte() * 0.2f;
        CharBuffer dest = CharBuffer.allocate(10 + (int)((float)inbuf.remaining() * factor));
        while (true) {
            result = decoder.decode(inbuf, dest, true);
            dest.flip();
            if (result.isUnderflow()) {
                if (dest.limit() == dest.capacity()) {
                    dest = CharBuffer.allocate(dest.capacity() + 1).put(dest);
                    dest.flip();
                }
                return dest;
            }
            if (result.isOverflow()) {
                int newCapacity = 10 + dest.capacity() + (int)((float)inbuf.remaining() * decoder.maxCharsPerByte());
                dest = CharBuffer.allocate(newCapacity).put(dest);
                continue;
            }
            if (!result.isMalformed() && !result.isUnmappable()) break;
            if (!this.getSource().allowEncodingErrors()) {
                this.log.error(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", this.charset == null ? encodingName : this.charset.name());
            } else {
                this.log.warning(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", this.charset == null ? encodingName : this.charset.name());
            }
            inbuf.position(inbuf.position() + result.length());
            dest.position(dest.limit());
            dest.limit(dest.capacity());
            dest.put('\ufffd');
        }
        throw new AssertionError(result);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        ListBuffer<URL> lb = new ListBuffer<URL>();
        for (File file : path) {
            try {
                lb.append(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        URL[] urls = lb.toArray(new URL[lb.size()]);
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (this.classLoaderClass != null) {
            try {
                Class<ClassLoader> loader = Class.forName(this.classLoaderClass).asSubclass(ClassLoader.class);
                Class[] constrArgTypes = new Class[]{URL[].class, ClassLoader.class};
                Constructor<ClassLoader> constr = loader.getConstructor(constrArgTypes);
                return constr.newInstance(urls, classLoader);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (Closeable.class.isAssignableFrom(URLClassLoader.class)) {
            return new URLClassLoader(urls, classLoader);
        }
        try {
            return new CloseableURLClassLoader(urls, classLoader);
        }
        catch (Throwable t) {
            return new URLClassLoader(urls, classLoader);
        }
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        JavacFileManager.nullCheck(packageName);
        JavacFileManager.nullCheck(kinds);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return List.nil();
        }
        RelativePath.RelativeDirectory subdirectory = RelativePath.RelativeDirectory.forPackage(packageName);
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (File file : path) {
            this.listDirectory(file, subdirectory, kinds, recurse, results);
        }
        return results.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        file.getClass();
        location.getClass();
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        if (file instanceof BaseFileObject) {
            return ((BaseFileObject)file).inferBinaryName(path);
        }
        throw new IllegalArgumentException(file.getClass().getName());
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        JavacFileManager.nullCheck(a);
        JavacFileManager.nullCheck(b);
        if (!(a instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + a);
        }
        if (!(b instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + b);
        }
        return a.equals(b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        for (JavacOption o : javacFileManagerOptions) {
            if (!o.matches(current)) continue;
            if (o.hasArg() ? remaining.hasNext() && !o.process(this.options, current, remaining.next()) : !o.process(this.options, current)) {
                return true;
            }
            throw new IllegalArgumentException(current);
        }
        return false;
    }

    @Override
    public int isSupportedOption(String option) {
        for (JavacOption o : javacFileManagerOptions) {
            if (!o.matches(option)) continue;
            return o.hasArg() ? 1 : 0;
        }
        return -1;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, RelativePath.RelativeFile.forClass(className, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(relativeName)) {
            throw new IllegalArgumentException("Invalid relative name: " + relativeName);
        }
        RelativePath.RelativeFile name = packageName.length() == 0 ? new RelativePath.RelativeFile(relativeName) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(packageName), relativeName);
        return this.getFileForInput(location, name);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, RelativePath.RelativeFile name) throws IOException {
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        for (File file : path) {
            if (file.isDirectory()) {
                File f = name.getFile(file);
                if (!f.exists()) continue;
                return new RegularFileObject(this, f);
            }
            Archive a = this.openArchive(file);
            if (!a.contains(name)) continue;
            return a.getFileObject(name.dirname(), name.basename());
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, RelativePath.RelativeFile.forClass(className, kind), sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(relativeName)) {
            throw new IllegalArgumentException("relativeName is invalid");
        }
        RelativePath.RelativeFile name = packageName.length() == 0 ? new RelativePath.RelativeFile(relativeName) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(packageName), relativeName);
        return this.getFileForOutput(location, name, sibling);
    }

    /*
     * Enabled aggressive block sorting
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile fileName, FileObject sibling) throws IOException {
        File dir;
        block7: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    dir = this.getClassOutDir();
                    break block7;
                } else {
                    File siblingDir = null;
                    if (sibling != null && sibling instanceof RegularFileObject) {
                        siblingDir = ((RegularFileObject)sibling).file.getParentFile();
                    }
                    return new RegularFileObject(this, new File(siblingDir, fileName.basename()));
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                dir = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                Paths.Path path = this.paths.getPathForLocation(location);
                dir = null;
                Iterator i$ = path.iterator();
                if (i$.hasNext()) {
                    File f;
                    dir = f = (File)i$.next();
                }
            }
        }
        File file = fileName.getFile(dir);
        return new RegularFileObject(this, file);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<RegularFileObject> result = files instanceof Collection ? new ArrayList(((Collection)files).size()) : new ArrayList<RegularFileObject>();
        for (File file : files) {
            result.add(new RegularFileObject(this, JavacFileManager.nullCheck(file)));
        }
        return result;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList((Object[])JavacFileManager.nullCheck(files)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        File dir;
        JavacFileManager.nullCheck(location);
        this.paths.lazy();
        File file = dir = location.isOutputLocation() ? this.getOutputDirectory(path) : null;
        if (location == StandardLocation.CLASS_OUTPUT) {
            this.classOutDir = this.getOutputLocation(dir, OptionName.D);
        } else if (location == StandardLocation.SOURCE_OUTPUT) {
            this.sourceOutDir = this.getOutputLocation(dir, OptionName.S);
        } else {
            this.paths.setPathForLocation(location, path);
        }
    }

    private File getOutputDirectory(Iterable<? extends File> path) throws IOException {
        if (path == null) {
            return null;
        }
        Iterator<? extends File> pathIter = path.iterator();
        if (!pathIter.hasNext()) {
            throw new IllegalArgumentException("empty path for directory");
        }
        File dir = pathIter.next();
        if (pathIter.hasNext()) {
            throw new IllegalArgumentException("path too long for directory");
        }
        if (!dir.exists()) {
            throw new FileNotFoundException(dir + ": does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IOException(dir + ": not a directory");
        }
        return dir;
    }

    private File getOutputLocation(File dir, OptionName defaultOptionName) {
        if (dir != null) {
            return dir;
        }
        String arg = this.options.get(defaultOptionName);
        if (arg == null) {
            return null;
        }
        return new File(arg);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        this.paths.lazy();
        if (location == StandardLocation.CLASS_OUTPUT) {
            return this.getClassOutDir() == null ? null : List.of(this.getClassOutDir());
        }
        if (location == StandardLocation.SOURCE_OUTPUT) {
            return this.getSourceOutDir() == null ? null : List.of(this.getSourceOutDir());
        }
        return this.paths.getPathForLocation(location);
    }

    private File getClassOutDir() {
        if (this.classOutDir == this.uninited) {
            this.classOutDir = this.getOutputLocation(null, OptionName.D);
        }
        return this.classOutDir;
    }

    private File getSourceOutDir() {
        if (this.sourceOutDir == this.uninited) {
            this.sourceOutDir = this.getOutputLocation(null, OptionName.S);
        }
        return this.sourceOutDir;
    }

    protected static boolean isRelativeUri(URI uri) {
        if (uri.isAbsolute()) {
            return false;
        }
        String path = uri.normalize().getPath();
        if (path.length() == 0) {
            return false;
        }
        char first = path.charAt(0);
        return first != '.' && first != '/';
    }

    protected static boolean isRelativeUri(String u) {
        try {
            return JavacFileManager.isRelativeUri(new URI(u));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static String getRelativeName(File file) {
        String result;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(result = file.getPath().replace(File.separatorChar, '/'))) {
            return result;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    private static <T> T nullCheck(T o) {
        o.getClass();
        return o;
    }

    private static <T> Iterable<T> nullCheck(Iterable<T> it) {
        for (T t : it) {
            t.getClass();
        }
        return it;
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;

        private ByteBufferCache() {
        }

        ByteBuffer get(int capacity) {
            if (capacity < 20480) {
                capacity = 20480;
            }
            ByteBuffer result = this.cached != null && this.cached.capacity() >= capacity ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(capacity + capacity >> 1);
            this.cached = null;
            return result;
        }

        void put(ByteBuffer x) {
            this.cached = x;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MissingArchive
    implements Archive {
        final File zipFileName;

        public MissingArchive(File name) {
            this.zipFileName = name;
        }

        @Override
        public boolean contains(RelativePath name) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public JavaFileObject getFileObject(RelativePath.RelativeDirectory subdirectory, String file) {
            return null;
        }

        @Override
        public List<String> getFiles(RelativePath.RelativeDirectory subdirectory) {
            return List.nil();
        }

        @Override
        public Set<RelativePath.RelativeDirectory> getSubdirectories() {
            return Collections.emptySet();
        }

        public String toString() {
            return "MissingArchive[" + this.zipFileName + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Archive {
        public void close() throws IOException;

        public boolean contains(RelativePath var1);

        public JavaFileObject getFileObject(RelativePath.RelativeDirectory var1, String var2);

        public List<String> getFiles(RelativePath.RelativeDirectory var1);

        public Set<RelativePath.RelativeDirectory> getSubdirectories();
    }
}

