/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;

public abstract class JsRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    private boolean cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelRequest() {
        JsRefactoringPlugin jsRefactoringPlugin = this;
        synchronized (jsRefactoringPlugin) {
            this.cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isCancelled() {
        JsRefactoringPlugin jsRefactoringPlugin = this;
        synchronized (jsRefactoringPlugin) {
            return this.cancelled;
        }
    }

    protected static final Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        if (bl) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    protected final Collection<ModificationResult> processFiles(Set<FileObject> set, TransformTask transformTask) {
        HashSet<Source> hashSet = new HashSet<Source>(2 * set.size());
        for (FileObject fileObject : set) {
            if (!RetoucheUtils.isJsFile(fileObject) || !JsUtils.isJsFile((FileObject)fileObject) && fileObject.getSize() >= 0x100000L) continue;
            hashSet.add(Source.create((FileObject)fileObject));
        }
        try {
            for (Source source : hashSet) {
                ParserManager.parse(Collections.singletonList(source), (UserTask)transformTask);
            }
            return transformTask.results;
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    protected abstract class TransformTask
    extends UserTask {
        private final Collection<ModificationResult> results = new ArrayList<ModificationResult>();

        protected TransformTask() {
        }

        public final void run(ResultIterator resultIterator) throws ParseException {
            this.visit(resultIterator);
            JsRefactoringPlugin.this.fireProgressListenerStep();
        }

        protected abstract Collection<ModificationResult> process(JsParseResult var1);

        private void visit(ResultIterator resultIterator) throws ParseException {
            if (resultIterator.getSnapshot().getMimeType().equals("text/javascript")) {
                JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                Embedding embedding = this.process(jsParseResult);
                this.results.addAll((Collection<ModificationResult>)embedding);
            }
            for (Embedding embedding : resultIterator.getEmbeddings()) {
                this.visit(resultIterator.getResultIterator(embedding));
            }
        }
    }
}

