/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GoToSuperTypeAction
extends BaseAction {
    public GoToSuperTypeAction() {
        super("goto-super-implementation", 132);
        this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString("goto-super-implementation"));
        String string = NbBundle.getBundle(JavaKit.class).getString("goto-super-implementation-trimmed");
        this.putValue("trimmed-text", string);
        this.putValue("PopupMenuText", string);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (javaSource == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToSupport.class, (String)"WARN_CannotGoToGeneric", (Object)1));
            return;
        }
        final ArrayList<ElementDescription> arrayList = new ArrayList<ElementDescription>();
        final AnnotationType[] annotationTypeArray = new AnnotationType[1];
        final int n = jTextComponent.getCaretPosition();
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    ExecutableElement executableElement = GoToSuperTypeAction.resolveMethodElement((CompilationInfo)compilationController, n);
                    if (executableElement == null) {
                        executableElement = GoToSuperTypeAction.resolveMethodElement((CompilationInfo)compilationController, n + 1);
                    }
                    if (executableElement == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    annotationTypeArray[0] = ComputeOverriding.detectOverrides((CompilationInfo)compilationController, (TypeElement)executableElement.getEnclosingElement(), executableElement, arrayList);
                }
            }, true);
            if (annotationTypeArray[0] == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            Point point = new Point(jTextComponent.modelToView(jTextComponent.getCaretPosition()).getLocation());
            SwingUtilities.convertPointToScreen(point, jTextComponent);
            IsOverriddenAnnotation.performGoToAction(annotationTypeArray[0], arrayList, point, "");
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static ExecutableElement resolveMethodElement(CompilationInfo compilationInfo, int n) {
        TreePath treePath;
        for (treePath = compilationInfo.getTreeUtilities().pathFor(n); treePath != null && treePath.getLeaf().getKind() != Tree.Kind.METHOD; treePath = treePath.getParentPath()) {
        }
        if (treePath == null) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.METHOD) {
            return null;
        }
        return (ExecutableElement)element;
    }
}

