/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.customwizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.SrcDocPathsPanel;
import org.netbeans.modules.mobility.cldcplatform.customwizard.ClasspathPanel;
import org.netbeans.modules.mobility.cldcplatform.customwizard.CommandLinesPanel;
import org.netbeans.modules.mobility.cldcplatform.customwizard.WizardPanel;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;

public class InstallerIterator
implements WizardDescriptor.InstantiatingIterator {
    private static InstallerIterator INSTANCE;
    ArrayList<ChangeListener> listeners = new ArrayList();
    int current;
    private WizardDescriptor.FinishablePanel[] panels;
    private WizardDescriptor wizardDescriptor;

    public static synchronized InstallerIterator getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new InstallerIterator();
        }
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void fireChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.current];
    }

    public String name() {
        return "Add Custom Mobile Platform";
    }

    public boolean hasNext() {
        return this.current < this.panels.length - 1 && this.current().isValid();
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public void nextPanel() {
        assert (this.hasNext());
        ++this.current;
    }

    public void previousPanel() {
        assert (this.hasPrevious());
        --this.current;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        this.current = 0;
        this.panels = new WizardDescriptor.FinishablePanel[]{new WizardPanel(new CommandLinesPanel()), new WizardPanel(new ClasspathPanel()), new SrcDocPathsPanel.WizardPanel(true)};
        String[] strs = new String[this.panels.length];
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = this.panels[i].getComponent().getName();
        }
        ((JComponent)this.panels[0].getComponent()).putClientProperty("WizardPanel_contentData", strs);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public Set<J2MEPlatform> instantiate() throws IOException {
        J2MEPlatform platform = (J2MEPlatform)((Object)this.wizardDescriptor.getProperty("Platform"));
        DataObject dao = platform != null ? J2MEPlatform.createPlatform(platform) : null;
        return dao != null ? Collections.singleton(platform) : Collections.EMPTY_SET;
    }
}

