/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.api.SunURIManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.PlatformFactory;
import org.netbeans.modules.j2ee.sun.ide.j2ee.PlatformImpl;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.CustomizerSupport;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class DeploymentManagerProperties {
    public static final String DOMAIN_ATTR = "DOMAIN";
    public static final String HTTP_MONITOR_ATTR = "HttpMonitorOn";
    public static final String HTTP_PROXY_SYNCHED_ATTR = "HttpProxySynced";
    public static final String DIRDEPLOYMENT_POSSIBLE_ATTR = "DirectoryDeploymentPossible";
    public static final String PASSWORD_ATTR = "password";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String LOCATION_ATTR = "LOCATION";
    public static final String HTTP_PORT_NUMBER_ATTR = "httpportnumber";
    public static final String AVK_INSTRUMENTED_ATTR = "AVKTurnedOn";
    public static final String DRIVER_DEPLOYMENT_ATTR = "DriverDeploymentEnabled";
    public static final String DATABASE_START_ATTR = "DatabaseStartEnabled";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_JAVADOCS = "javadocs";
    private final InstanceProperties instanceProperties;
    private final SunDeploymentManagerInterface sunDM;

    public DeploymentManagerProperties(DeploymentManager deploymentManager) {
        this.sunDM = (SunDeploymentManagerInterface)deploymentManager;
        InstanceProperties instanceProperties = SunURIManager.getInstanceProperties((File)this.sunDM.getPlatformRoot(), (String)this.sunDM.getHost(), (int)this.sunDM.getPort());
        String string = this.sunDM.getNonAdminPortNumber();
        if (string == null) {
            string = "8080";
        }
        if (instanceProperties == null) {
            try {
                instanceProperties = SunURIManager.createInstanceProperties((File)this.sunDM.getPlatformRoot(), (String)this.sunDM.getHost(), (String)("" + this.sunDM.getPort()), (String)this.sunDM.getUserName(), (String)this.sunDM.getPassword(), (String)(this.sunDM.getHost() + ":" + this.sunDM.getPort()));
                if (null != instanceProperties) {
                    instanceProperties.setProperty(HTTP_PORT_NUMBER_ATTR, string);
                }
            }
            catch (InstanceCreationException instanceCreationException) {
                // empty catch block
            }
        }
        if (instanceProperties != null && instanceProperties.getProperty(HTTP_PORT_NUMBER_ATTR) == null) {
            instanceProperties.setProperty(HTTP_PORT_NUMBER_ATTR, string);
        }
        this.instanceProperties = instanceProperties;
    }

    public String getDomainName() {
        String string = "";
        if (this.instanceProperties == null) {
            return string;
        }
        string = this.instanceProperties.getProperty(DOMAIN_ATTR);
        if (null == string || string.trim().length() == 0) {
            string = "";
        }
        return string;
    }

    public void setDomainName(String string) {
        this.instanceProperties.setProperty(DOMAIN_ATTR, string);
    }

    public String getLocation() {
        File file = this.sunDM.getPlatformRoot();
        String string = null;
        if (null != file && file.exists()) {
            string = file.getAbsolutePath();
        }
        if (this.instanceProperties == null) {
            return string;
        }
        String string2 = this.instanceProperties.getProperty(LOCATION_ATTR);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public void setLocation(String string) {
        if (this.instanceProperties == null) {
            return;
        }
        this.instanceProperties.setProperty(LOCATION_ATTR, string);
    }

    public String getPassword() {
        if (this.instanceProperties == null) {
            return null;
        }
        return DeploymentManagerProperties.getPassword(this.instanceProperties);
    }

    public static String getPassword(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty(PASSWORD_ATTR);
        String string2 = instanceProperties.getProperty("url");
        char[] cArray = Keyring.read((String)string2);
        if (null == cArray || cArray.length < 1 || !"this really long string is used to identify a password that has been stored in the Keyring".equals(string)) {
            cArray = string.toCharArray();
            if (null != string2) {
                Keyring.save((String)string2, (char[])cArray, (String)"a Glassfish/SJSAS passord");
                instanceProperties.setProperty(PASSWORD_ATTR, "this really long string is used to identify a password that has been stored in the Keyring");
            }
        } else {
            string = String.copyValueOf(cArray);
        }
        return string;
    }

    public void setPassword(String string) {
        String string2 = this.instanceProperties.getProperty("url");
        if (null == string2) {
            return;
        }
        Keyring.save((String)string2, (char[])string.toCharArray(), (String)"a Glassfish/SJSAS passord");
    }

    public String getUserName() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty("username");
    }

    public void setUserName(String string) {
        this.instanceProperties.setProperty("username", string);
    }

    public String getHttpMonitorOn() {
        if (this.instanceProperties == null) {
            return "false";
        }
        String string = this.instanceProperties.getProperty(HTTP_MONITOR_ATTR);
        if (string == null) {
            return "false";
        }
        return string;
    }

    public void setHttpMonitorOn(String string) {
        this.instanceProperties.setProperty(HTTP_MONITOR_ATTR, string);
    }

    public String getHttpPortNumber() {
        if (this.instanceProperties == null) {
            return "8080";
        }
        return this.instanceProperties.getProperty(HTTP_PORT_NUMBER_ATTR);
    }

    public void setHttpPortNumber(String string) {
        this.instanceProperties.setProperty(HTTP_PORT_NUMBER_ATTR, string);
    }

    public String getDisplayName() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty(DISPLAY_NAME_ATTR);
    }

    public String getUrl() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty("url");
    }

    public InstanceProperties getInstanceProperties() {
        return this.instanceProperties;
    }

    public boolean getAVKOn() {
        if (this.instanceProperties == null) {
            return false;
        }
        String string = this.instanceProperties.getProperty(AVK_INSTRUMENTED_ATTR);
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public void setAVKOn(boolean bl) {
        this.instanceProperties.setProperty(AVK_INSTRUMENTED_ATTR, Boolean.toString(bl));
    }

    public void setJavadocs(List<URL> list) {
        this.instanceProperties.setProperty(PROP_JAVADOCS, CustomizerSupport.buildPath(list));
        PlatformImpl platformImpl = (PlatformImpl)new PlatformFactory().getJ2eePlatformImpl((DeploymentManager)this.sunDM);
        platformImpl.notifyLibrariesChanged();
    }

    public void setSources(List<URL> list) {
        this.instanceProperties.setProperty(PROP_SOURCES, CustomizerSupport.buildPath(list));
        PlatformImpl platformImpl = (PlatformImpl)new PlatformFactory().getJ2eePlatformImpl((DeploymentManager)this.sunDM);
        platformImpl.notifyLibrariesChanged();
    }

    public List<URL> getClasses() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        PlatformImpl platformImpl = (PlatformImpl)new PlatformFactory().getJ2eePlatformImpl((DeploymentManager)this.sunDM);
        for (LibraryImplementation libraryImplementation : platformImpl.getLibraries()) {
            arrayList.addAll(libraryImplementation.getContent("classpath"));
        }
        return arrayList;
    }

    public List<URL> getSources() {
        String string = this.instanceProperties.getProperty(PROP_SOURCES);
        if (string == null) {
            return new ArrayList<URL>();
        }
        return CustomizerSupport.tokenizePath(string);
    }

    public List<URL> getJavadocs() {
        String string = this.instanceProperties.getProperty(PROP_JAVADOCS);
        if (string == null) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            try {
                File file = InstalledFileLocator.getDefault().locate("docs/javaee6-doc-api.zip", null, false);
                if (file != null) {
                    arrayList.add(DeploymentManagerProperties.fileToUrl(file));
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            }
            return arrayList;
        }
        return CustomizerSupport.tokenizePath(string);
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    public boolean isSyncHttpProxyOn() {
        if (this.instanceProperties == null) {
            return true;
        }
        String string = this.instanceProperties.getProperty(HTTP_PROXY_SYNCHED_ATTR);
        if (string == null) {
            this.instanceProperties.setProperty(HTTP_PROXY_SYNCHED_ATTR, "true");
            string = this.instanceProperties.getProperty(HTTP_PROXY_SYNCHED_ATTR);
        }
        return Boolean.valueOf(string);
    }

    public void setSyncHttpProxyOn(boolean bl) {
        this.instanceProperties.setProperty(HTTP_PROXY_SYNCHED_ATTR, Boolean.toString(bl));
    }

    public boolean isDirectoryDeploymentPossible() {
        if (this.instanceProperties == null) {
            return true;
        }
        String string = this.instanceProperties.getProperty(DIRDEPLOYMENT_POSSIBLE_ATTR);
        if (string == null) {
            this.instanceProperties.setProperty(DIRDEPLOYMENT_POSSIBLE_ATTR, this.sunDM.isLocal() + "");
            string = this.instanceProperties.getProperty(DIRDEPLOYMENT_POSSIBLE_ATTR);
        }
        return Boolean.valueOf(string);
    }

    public void setDirectoryDeploymentPossible(boolean bl) {
        this.instanceProperties.setProperty(DIRDEPLOYMENT_POSSIBLE_ATTR, Boolean.toString(bl));
    }

    public int getDeploymentTimeout() {
        String string = this.instanceProperties.getProperty("deploymentTimeout");
        if (string == null) {
            this.instanceProperties.setProperty("deploymentTimeout", Integer.toString(144));
            string = this.instanceProperties.getProperty("deploymentTimeout");
        }
        return Integer.parseInt(string);
    }

    public void setDeploymentTimeout(int n) {
        this.instanceProperties.setProperty("deploymentTimeout", Integer.toString(n));
    }

    public int getStartupTimeout() {
        String string = this.instanceProperties.getProperty("startupTimeout");
        if (string == null) {
            this.instanceProperties.setProperty("startupTimeout", Integer.toString(288));
            string = this.instanceProperties.getProperty("startupTimeout");
        }
        return Integer.parseInt(string);
    }

    public void setStartupTimeout(int n) {
        this.instanceProperties.setProperty("startupTimeout", Integer.toString(n));
    }

    public File getDriverLocation() {
        String string = this.getLocation();
        String string2 = this.getDomainName();
        String string3 = new File(string).getAbsolutePath();
        string = string3 + File.separator + string2 + File.separator + "lib";
        return new File(string);
    }

    public boolean isDriverDeploymentEnabled() {
        if (this.instanceProperties == null) {
            return true;
        }
        String string = this.instanceProperties.getProperty(DRIVER_DEPLOYMENT_ATTR);
        if (string == null) {
            this.instanceProperties.setProperty(DRIVER_DEPLOYMENT_ATTR, "true");
            string = this.instanceProperties.getProperty(DRIVER_DEPLOYMENT_ATTR);
        }
        return Boolean.valueOf(string);
    }

    public void setDriverDeploymentEnabled(boolean bl) {
        this.instanceProperties.setProperty(DRIVER_DEPLOYMENT_ATTR, Boolean.toString(bl));
    }

    public boolean isDatabaseStartEnabled() {
        if (this.instanceProperties == null) {
            return true;
        }
        String string = this.instanceProperties.getProperty(DATABASE_START_ATTR);
        if (string == null) {
            this.instanceProperties.setProperty(DATABASE_START_ATTR, "true");
            string = this.instanceProperties.getProperty(DATABASE_START_ATTR);
        }
        return Boolean.valueOf(string);
    }

    public void setDatabaseStartEnabled(boolean bl) {
        this.instanceProperties.setProperty(DATABASE_START_ATTR, Boolean.toString(bl));
    }

    public SunDeploymentManagerInterface getSunDeploymentManager() {
        return this.sunDM;
    }
}

