/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.schema.completion.util.DefaultModelProvider;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CompletionContextImpl
extends CompletionContext {
    public static final String PREFIX = "ns";
    public static final String XSI_SCHEMALOCATION = "schemaLocation";
    public static final String XSI_NONS_SCHEMALOCATION = "noNamespaceSchemaLocation";
    private static final Logger _logger = Logger.getLogger(CompletionContextImpl.class.getName());
    private int completionAtOffset = -1;
    private FileObject primaryFile;
    private String typedChars;
    private TokenItem token;
    private SyntaxElement element;
    private String attribute;
    private CompletionUtil.DocRoot docRoot;
    private char lastTypedChar;
    private CompletionContext.CompletionType completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
    private List<QName> pathFromRoot;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private String defaultNamespace;
    private BaseDocument document;
    private HashMap<String, CompletionModelProvider.CompletionModel> nsModelMap = new HashMap();
    private List<CompletionModelProvider.CompletionModel> noNSModels = new ArrayList<CompletionModelProvider.CompletionModel>();
    private HashMap<String, String> declaredNamespaces = new HashMap();
    private HashMap<String, String> suggestedNamespaces = new HashMap();
    private HashMap<String, String> specialNamespaceMap = new HashMap();
    private CompletionModelProvider.CompletionModel noNamespaceModel;
    private transient List<String> existingAttributes;
    private boolean specialCompletion;

    public CompletionContextImpl(FileObject primaryFile, XMLSyntaxSupport support, int offset) {
        try {
            this.completionAtOffset = offset;
            this.primaryFile = primaryFile;
            this.document = support.getDocument();
            this.element = support.getElementChain(offset);
            this.token = support.getPreviousToken(offset);
            this.docRoot = CompletionUtil.getDocRoot((Document)this.document);
            this.lastTypedChar = support.lastTypedChar();
            this.populateNamespaces();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, ex.getMessage());
        }
    }

    @Override
    public CompletionContext.CompletionType getCompletionType() {
        return this.completionType;
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public List<QName> getPathFromRoot() {
        return this.pathFromRoot;
    }

    @Override
    public FileObject getPrimaryFile() {
        return this.primaryFile;
    }

    @Override
    public BaseDocument getBaseDocument() {
        return this.document;
    }

    @Override
    public HashMap<String, String> getDeclaredNamespaces() {
        return this.declaredNamespaces;
    }

    @Override
    public String getTypedChars() {
        return this.typedChars;
    }

    public boolean isSchemaAwareCompletion() {
        return this.schemaLocation != null || this.noNamespaceSchemaLocation != null;
    }

    public List<URI> getSchemas() {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (this.schemaLocation != null) {
            CompletionUtil.loadSchemaURIs(this.schemaLocation, uris, false);
            return uris;
        }
        if (this.noNamespaceSchemaLocation != null) {
            CompletionUtil.loadSchemaURIs(this.noNamespaceSchemaLocation, uris, true);
            return uris;
        }
        return uris;
    }

    private void populateNamespaces() {
        if (this.docRoot == null) {
            return;
        }
        String tagName = this.docRoot.getName();
        String defNS = "xmlns";
        String temp = CompletionUtil.getPrefixFromTag(tagName);
        if (temp != null) {
            defNS = defNS + ":" + temp;
        }
        List<CompletionUtil.DocRootAttribute> attributes = this.docRoot.getAttributes();
        for (int index = 0; index < attributes.size(); ++index) {
            CompletionUtil.DocRootAttribute attr = attributes.get(index);
            String attrName = attr.getName();
            if (CompletionUtil.getLocalNameFromTag(attrName).equals(XSI_SCHEMALOCATION)) {
                this.schemaLocation = attr.getValue().trim();
                continue;
            }
            if (CompletionUtil.getLocalNameFromTag(attrName).equals(XSI_NONS_SCHEMALOCATION)) {
                this.noNamespaceSchemaLocation = attr.getValue().trim();
                continue;
            }
            if (!attrName.startsWith("xmlns")) continue;
            if (attrName.equals(defNS)) {
                this.defaultNamespace = attr.getValue();
            }
            this.declaredNamespaces.put(attrName, attr.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenSequence getTokenSequence() {
        TokenSequence tokenSequence = null;
        try {
            this.document.readLock();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
            tokenSequence = tokenHierarchy.tokenSequence();
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
        }
        finally {
            this.document.readUnlock();
        }
        return tokenSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTagAttributeRequired(TokenSequence tokenSequence) {
        boolean isTagLastCharFound;
        int caretPos = this.completionAtOffset;
        tokenSequence.move(caretPos);
        tokenSequence.moveNext();
        Token tok = tokenSequence.token();
        if (tok == null) {
            return false;
        }
        TokenId tokID = tok.id();
        if (tokID.equals(XMLTokenId.TAG) && CompletionUtil.isEndTagSuffix(tok) && tokenSequence.offset() + 1 == caretPos) {
            return false;
        }
        boolean isAttributeOrSpace = tokID.equals(XMLTokenId.ARGUMENT) || tokID.equals(XMLTokenId.WS);
        boolean bl = isTagLastCharFound = tokID.equals(XMLTokenId.TAG) && (CompletionUtil.isTagLastChar(tok) || CompletionUtil.isEndTagSuffix(tok));
        do {
            if (tokID.equals(XMLTokenId.TAG)) {
                int tokOffset;
                int tagNameEndPos;
                if (CompletionUtil.isEndTagPrefix(tok)) return false;
                String tagName = CompletionUtil.getTokenTagName(tok);
                if (tagName != null && (tagNameEndPos = (tokOffset = tokenSequence.offset()) + "<".length() + tagName.length()) < caretPos && (isAttributeOrSpace || isTagLastCharFound)) {
                    return true;
                }
            }
            if (!tokenSequence.movePrevious()) return false;
            tok = tokenSequence.token();
            tokID = tok.id();
        } while (!CompletionUtil.isEndTagSuffix(tok) && !CompletionUtil.isTagLastChar(tok));
        return false;
    }

    public boolean initContext() {
        TokenSequence tokenSequence = this.getTokenSequence();
        try {
            if (this.isTagAttributeRequired(tokenSequence)) {
                this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE;
                this.pathFromRoot = this.getPathFromRoot(this.element);
                return true;
            }
            int id = this.token.getTokenID().getNumericID();
            block1 : switch (id) {
                case 1: {
                    String chars = this.token.getImage().trim();
                    String previousTokenText = this.token.getPrevious().getImage().trim();
                    if (chars != null && chars.startsWith("&")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                        break;
                    }
                    if (chars != null && chars.equals("") && previousTokenText.endsWith(">")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                        this.pathFromRoot = this.getPathFromRoot(this.element);
                        break;
                    }
                    if (chars != null && chars.startsWith("<")) {
                        this.typedChars = chars.substring(1);
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                        this.pathFromRoot = this.getPathFromRoot(this.element);
                        break;
                    }
                    if (chars != null && previousTokenText.equals(">")) {
                        if (!chars.equals("") && !chars.equals(">")) {
                            this.typedChars = chars;
                        }
                        this.pathFromRoot = this.getPathFromRoot(this.element);
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT_VALUE;
                        break;
                    }
                    if (chars != null && !chars.equals("<") && previousTokenText.equals(">")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    }
                    break;
                }
                case 8: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                    this.pathFromRoot = this.getPathFromRoot(this.element);
                    break;
                }
                case 4: {
                    if (this.element instanceof EndTag) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                        break;
                    }
                    if (this.element instanceof EmptyTag) {
                        EmptyTag tag = (EmptyTag)this.element;
                        if (CompletionUtil.isCaretInsideTag(this.completionAtOffset, tokenSequence)) break;
                        if (this.element.getElementOffset() + 1 == this.completionAtOffset || this.token.getOffset() + this.token.getImage().length() == this.completionAtOffset) {
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                            this.pathFromRoot = this.getPathFromRoot(this.element.getPrevious());
                            break;
                        }
                        if (this.completionAtOffset > this.element.getElementOffset() + 1 && this.completionAtOffset <= this.element.getElementOffset() + 1 + tag.getTagName().length()) {
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                            int index = this.completionAtOffset - this.element.getElementOffset() - 1;
                            this.typedChars = index < 0 ? tag.getTagName() : tag.getTagName().substring(0, index);
                            this.pathFromRoot = this.getPathFromRoot(this.element.getPrevious());
                        }
                        break;
                    }
                    if (this.element instanceof StartTag) {
                        if (this.token != null && this.token.getImage().trim().equals(">")) {
                            this.pathFromRoot = this.getPathFromRoot(this.element);
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT_VALUE;
                            break;
                        }
                        if (this.element.getElementOffset() + 1 == this.completionAtOffset) {
                            this.typedChars = null;
                        } else {
                            StartTag tag = (StartTag)this.element;
                            int index = this.completionAtOffset - this.element.getElementOffset() - 1;
                            this.typedChars = index < 0 ? tag.getTagName() : tag.getTagName().substring(0, index);
                        }
                    }
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                    this.pathFromRoot = this.getPathFromRoot(this.element.getPrevious());
                    break;
                }
                case 5: {
                    break;
                }
                case 11: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    break;
                }
                case 6: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    break;
                }
                case 7: {
                    String str;
                    if (this.token.getNext() == null) {
                        this.typedChars = this.lastTypedChar == '\'' || this.lastTypedChar == '\"' ? null : this.token.getImage().substring(1, this.token.getImage().indexOf(">"));
                    }
                    if (this.lastTypedChar != '\'' && this.lastTypedChar != '\"' && (str = this.token.getImage()) != null && !str.equals("\"\"") && !str.equals("''") && (str.startsWith("\"") || str.startsWith("'")) && (str.endsWith("\"") || str.endsWith("'"))) {
                        this.typedChars = str.substring(1, str.length() - 1);
                        if (this.completionAtOffset == this.token.getOffset() + 1) {
                            this.typedChars = "";
                        }
                    }
                    this.attribute = this.element.getPrevious().toString();
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE_VALUE;
                    this.pathFromRoot = this.getPathFromRoot(this.element);
                    for (TokenItem t = this.token; t != null; t = t.getPrevious()) {
                        int nId = t.getTokenID().getNumericID();
                        if (nId != 5) continue;
                        this.attribute = t.getImage();
                        break block1;
                    }
                    break;
                }
                case 2: {
                    TokenItem prev;
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    for (prev = this.token.getPrevious(); prev != null && prev.getTokenID().getNumericID() == 2; prev = prev.getPrevious()) {
                    }
                    if ((prev.getTokenID().getNumericID() == 7 || prev.getTokenID().getNumericID() == 4) && prev.getImage().startsWith("</")) {
                    }
                    break;
                }
                default: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.INFO, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
            return false;
        }
        return true;
    }

    public List<CompletionUtil.DocRootAttribute> getDocRootAttributes() {
        return this.docRoot.getAttributes();
    }

    public CompletionUtil.DocRoot getDocRoot() {
        return this.docRoot;
    }

    public String getAttribute() {
        return this.attribute;
    }

    private List<QName> getPathFromRoot(SyntaxElement se) {
        if (se == null) {
            return null;
        }
        Stack<Tag> stack = new Stack<Tag>();
        if (se instanceof EmptyTag) {
            stack.push((Tag)se);
        }
        while (se != null) {
            if (se instanceof EndTag || se instanceof StartTag && stack.isEmpty()) {
                stack.push((Tag)se);
                se = se.getPrevious();
                continue;
            }
            if (se instanceof StartTag) {
                StartTag start = (StartTag)se;
                if (stack.peek() instanceof EndTag) {
                    EndTag end = (EndTag)stack.peek();
                    if (end.getTagName().equals(start.getTagName())) {
                        stack.pop();
                    }
                } else {
                    stack.push((Tag)se);
                }
            }
            se = se.getPrevious();
        }
        return this.createPath(stack);
    }

    private ArrayList<QName> createPath(Stack<Tag> stack) {
        ArrayList<QName> path = new ArrayList<QName>();
        ListIterator tags = stack.listIterator();
        while (tags.hasNext()) {
            Tag tag = (Tag)tags.next();
            path.add(0, this.createQName(tag));
            if (this.isRoot(tag, tags.hasNext() ? (Tag)tags.next() : null)) {
                return path;
            }
            tags.previous();
        }
        return path;
    }

    private boolean isRoot(Tag thisTag, Tag previousTag) {
        String namespace;
        if (previousTag == null) {
            return true;
        }
        String prefix = CompletionUtil.getPrefixFromTag(thisTag.getTagName());
        Attr namespaceAttr = null;
        namespaceAttr = prefix == null ? thisTag.getAttributeNode("xmlns") : thisTag.getAttributeNode("xmlns:" + prefix);
        if (namespaceAttr != null && !(namespace = namespaceAttr.getValue()).equals(this.defaultNamespace)) {
            String nnsl;
            String sl = this.getAttributeValue(thisTag, XSI_SCHEMALOCATION);
            if (sl != null) {
                this.schemaLocation = sl;
            }
            if ((nnsl = this.getAttributeValue(thisTag, XSI_NONS_SCHEMALOCATION)) != null) {
                this.noNamespaceSchemaLocation = nnsl;
            }
            if (prefix != null) {
                this.declaredNamespaces.put("xmlns:" + prefix, namespace);
            }
            return true;
        }
        if (this.defaultNamespace == null) {
            return false;
        }
        return !this.fromSameNamespace(thisTag, previousTag);
    }

    private String getAttributeValue(Tag tag, String attrName) {
        NamedNodeMap attrs = tag.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name == null || !name.contains(attrName)) continue;
            return attr.getNodeValue();
        }
        return null;
    }

    private QName createQName(Tag tag) {
        QName qname = null;
        String tagName = tag.getTagName();
        String prefix = CompletionUtil.getPrefixFromTag(tagName);
        String lName = CompletionUtil.getLocalNameFromTag(tagName);
        if (prefix == null) {
            Attr attrNode = tag.getAttributeNode("xmlns");
            if (attrNode == null) {
                qname = new QName(this.defaultNamespace, lName);
            } else {
                String ns = attrNode.getValue();
                qname = new QName(ns, lName);
            }
        } else {
            Attr attrNode = tag.getAttributeNode("xmlns:" + prefix);
            if (attrNode != null) {
                String ns = attrNode.getValue();
                qname = new QName(ns, lName, prefix);
            } else {
                qname = new QName(this.declaredNamespaces.get("xmlns:" + prefix), lName, prefix);
            }
        }
        return qname;
    }

    private boolean fromSameNamespace(Tag current, Tag previous) {
        String prevPrefix = CompletionUtil.getPrefixFromTag(previous.getTagName());
        String thisPrefix = CompletionUtil.getPrefixFromTag(current.getTagName());
        String thisNS = thisPrefix == null ? this.declaredNamespaces.get("xmlns") : this.declaredNamespaces.get("xmlns:" + thisPrefix);
        String prevNS = prevPrefix == null ? this.declaredNamespaces.get("xmlns") : this.declaredNamespaces.get("xmlns:" + prevPrefix);
        return thisNS == null && prevNS == null || thisNS != null && thisNS.equals(prevNS) || prevNS != null && prevNS.equals(thisNS);
    }

    public CompletionModelProvider.CompletionModel getActiveNoNSModel() {
        return this.noNamespaceModel;
    }

    public HashMap<String, CompletionModelProvider.CompletionModel> getCompletionModelMap() {
        return this.nsModelMap;
    }

    public List<CompletionModelProvider.CompletionModel> getNoNamespaceModels() {
        return this.noNSModels;
    }

    public List<CompletionModelProvider.CompletionModel> getCompletionModels() {
        ArrayList<CompletionModelProvider.CompletionModel> models = new ArrayList<CompletionModelProvider.CompletionModel>();
        models.addAll(this.nsModelMap.values());
        models.addAll(this.noNSModels);
        return models;
    }

    public void addCompletionModel(CompletionModelProvider.CompletionModel cm) {
        String tns = cm.getTargetNamespace();
        if (tns == null && !this.noNSModels.contains(cm)) {
            this.noNSModels.add(cm);
            return;
        }
        if (this.nsModelMap.get(tns) == null) {
            this.nsModelMap.put(tns, cm);
        }
    }

    public boolean initModels() {
        Lookup.Template templ = new Lookup.Template(CompletionModelProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(templ);
        Collection impls = result.allInstances();
        if (impls == null || impls.size() == 0) {
            return false;
        }
        for (Object obj : impls) {
            CompletionModelProvider modelProvider = (CompletionModelProvider)obj;
            List<CompletionModelProvider.CompletionModel> models = modelProvider.getModels(this);
            if (models == null || models.size() == 0) continue;
            for (CompletionModelProvider.CompletionModel m : models) {
                this.populateModelMap(m);
            }
        }
        if (this.noNamespaceSchemaLocation != null && this.noNSModels.size() == 1) {
            this.noNamespaceModel = this.noNSModels.get(0);
        }
        if (this.nsModelMap.size() == 0 && this.noNSModels.size() == 0) {
            this.specialCompletion();
        }
        return this.nsModelMap.size() != 0 || this.noNSModels.size() != 0;
    }

    private void populateModelMap(CompletionModelProvider.CompletionModel m) {
        String tns;
        Schema schema;
        SchemaModel sm;
        if (m != null && (sm = m.getSchemaModel()) != null && (schema = sm.getSchema()) != null && (tns = schema.getTargetNamespace()) != null) {
            this.nsModelMap.put(tns, m);
            return;
        }
        this.noNSModels.add(m);
    }

    private void specialCompletion() {
        if (this.primaryFile == null) {
            return;
        }
        this.specialCompletion = true;
        this.specialNamespaceMap = CompletionUtil.getNamespacesFromStartTags((Document)this.document);
        for (String temp : this.specialNamespaceMap.keySet()) {
            try {
                DefaultModelProvider provider = new DefaultModelProvider(this);
                CompletionModelProvider.CompletionModel cm = provider.getCompletionModel(new URI(temp), false);
                this.populateModelMap(cm);
            }
            catch (Exception ex) {
                _logger.log(Level.INFO, null, ex);
            }
        }
    }

    String suggestPrefix(String tns) {
        String ns;
        if (tns == null) {
            return null;
        }
        if (this.isSpecialCompletion()) {
            return this.specialNamespaceMap.get(tns);
        }
        for (String key : this.getDeclaredNamespaces().keySet()) {
            ns = this.getDeclaredNamespaces().get(key);
            if (!ns.equals(tns)) continue;
            return key;
        }
        for (String key : this.suggestedNamespaces.keySet()) {
            ns = this.suggestedNamespaces.get(key);
            if (!ns.equals(tns)) continue;
            return key;
        }
        int index = this.suggestedNamespaces.size() + 1;
        String prefix = PREFIX + index;
        String nsDecl = "xmlns:" + prefix;
        while (this.getDeclaredNamespaces().get(nsDecl) != null) {
            prefix = PREFIX + index++;
            nsDecl = "xmlns:" + prefix;
        }
        this.suggestedNamespaces.put(prefix, tns);
        return prefix;
    }

    public boolean isPrefixBeingUsed(String prefix) {
        return this.getDeclaredNamespaces().get("xmlns:" + prefix) != null;
    }

    public boolean isSpecialCompletion() {
        return this.specialCompletion;
    }

    public boolean canReplace(String text) {
        String name;
        if (this.completionType == CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT && this.element instanceof Tag && (name = ((Tag)this.element).getTagName()) != null && name.equals(this.typedChars) && text.equals(name)) {
            return false;
        }
        if (this.completionType == CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE) {
            Element e = CompletionUtil.findAXIElementAtContext(this);
            for (AbstractAttribute a : e.getAttributes()) {
                if (!a.getName().equals(this.typedChars)) continue;
                return false;
            }
        }
        return true;
    }

    public String getTargetNamespaceByPrefix(String prefix) {
        for (CompletionModelProvider.CompletionModel cm : this.getCompletionModelMap().values()) {
            if (!prefix.equals(cm.getSuggestedPrefix())) continue;
            return cm.getTargetNamespace();
        }
        return null;
    }

    List<String> getExistingAttributes() {
        if (this.existingAttributes != null) {
            return this.existingAttributes;
        }
        this.existingAttributes = new ArrayList<String>();
        for (TokenItem item = this.token.getPrevious(); item != null && item.getTokenID().getNumericID() != 4; item = item.getPrevious()) {
            if (item.getTokenID().getNumericID() != 5) continue;
            this.existingAttributes.add(item.getImage());
        }
        return this.existingAttributes;
    }
}

