/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.api.sql.execute.SQLExecutor;
import org.netbeans.modules.db.mysql.spi.sample.SampleProvider;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.JarFileSystem;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class BaseSampleProvider
implements SampleProvider {
    private static final Logger LOGGER = Logger.getLogger(BaseSampleProvider.class.getName());
    private static final BaseSampleProvider DEFAULT = new BaseSampleProvider();
    private static ArrayList<String> SAMPLES = new ArrayList();
    private static final String MODULE_JAR_FILE = "modules/org-netbeans-modules-db-mysql.jar";
    private static final String RESOURCE_DIR_PATH = "org/netbeans/modules/db/mysql/resources";

    private String getMessage(String key, String ... values) {
        return NbBundle.getMessage(BaseSampleProvider.class, (String)key, (Object[])values);
    }

    public static BaseSampleProvider getDefault() {
        return DEFAULT;
    }

    @Override
    public void create(String sampleName, DatabaseConnection dbconn) throws DatabaseException {
        if (sampleName == null) {
            throw new NullPointerException();
        }
        if (!SAMPLES.contains(sampleName)) {
            throw new DatabaseException(this.getMessage("MSG_SampleNotSupported", sampleName));
        }
        if (!this.checkInnodbSupport(dbconn.getJDBCConnection())) {
            throw new DatabaseException(this.getMessage("MSG_NoSampleWithoutInnoDB", new String[0]));
        }
        String sql = BaseSampleProvider.getSqlText(sampleName);
        SQLExecutor.execute((DatabaseConnection)dbconn, (String)sql);
    }

    @Override
    public boolean supportsSample(String name) {
        return SAMPLES.contains(name);
    }

    private boolean checkInnodbSupport(Connection conn) throws DatabaseException {
        try {
            ResultSet rs = conn.createStatement().executeQuery("SHOW STORAGE ENGINES");
            while (rs.next()) {
                if (!"INNODB".equals(rs.getString(1).toUpperCase()) || !"YES".equals(rs.getString(2).toUpperCase()) && !"DEFAULT".equals(rs.getString(2).toUpperCase())) continue;
                return true;
            }
            return false;
        }
        catch (SQLException sqle) {
            throw new DatabaseException((Throwable)sqle);
        }
    }

    @Override
    public List<String> getSampleNames() {
        return SAMPLES;
    }

    private static String getSqlText(String sampleName) throws DatabaseException {
        FileObject sqlfile = BaseSampleProvider.getSampleFile(sampleName);
        StringBuilder builder = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(sqlfile.getInputStream()));
            char[] cbuf = new char[100];
            while (true) {
                int numread;
                if ((numread = reader.read(cbuf)) < 0) {
                    reader.close();
                    break;
                }
                builder.append(cbuf, 0, numread);
            }
        }
        catch (IOException ioe) {
            throw new DatabaseException((Throwable)ioe);
        }
        return builder.toString().trim();
    }

    private static FileObject getSampleFile(String sampleName) throws DatabaseException {
        try {
            File jarfile = InstalledFileLocator.getDefault().locate(MODULE_JAR_FILE, null, false);
            JarFileSystem jarfs = new JarFileSystem();
            jarfs.setJarFile(jarfile);
            String filename = "/create-" + sampleName + ".sql";
            return jarfs.findResource(RESOURCE_DIR_PATH + filename);
        }
        catch (Exception e) {
            DatabaseException dbe = new DatabaseException(Utils.getMessage("MSG_ErrorLoadingSampleSQL", sampleName, e.getMessage()));
            dbe.initCause((Throwable)e);
            throw dbe;
        }
    }

    static {
        SAMPLES.add("sample");
        SAMPLES.add("vir");
        SAMPLES.add("travel");
    }
}

