/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestNodeAction;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.ui.OutputUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

abstract class BaseTestMethodNodeAction
extends TestNodeAction {
    private static final Logger LOGGER = Logger.getLogger(BaseTestMethodNodeAction.class.getName());
    protected final Testcase testcase;
    protected final Project project;
    protected final String name;

    public BaseTestMethodNodeAction(Testcase testcase, Project project, String name) {
        this.testcase = testcase;
        this.project = project;
        this.name = name;
    }

    public Object getValue(String key) {
        if ("Name".equals(key)) {
            return this.name;
        }
        return super.getValue(key);
    }

    protected String getTestMethod() {
        return BaseTestMethodNodeAction.getTestMethod(this.testcase);
    }

    static final String getTestMethod(Testcase testcase) {
        return testcase.getClassName() + "/" + testcase.getName();
    }

    protected FileObject getTestSourceRoot() {
        return BaseTestMethodNodeAction.getTestSourceRoot(this.project);
    }

    static final FileObject getTestSourceRoot(Project project) {
        RubyBaseProject baseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        FileObject[] testRoots = baseProject.getTestSourceRootFiles();
        return 0 == testRoots.length ? project.getProjectDirectory() : testRoots[0];
    }

    protected TestRunner getTestRunner(TestRunner.TestType testType) {
        Collection testRunners = Lookup.getDefault().lookupAll(TestRunner.class);
        for (TestRunner each : testRunners) {
            if (!each.supports(testType)) continue;
            return each;
        }
        return null;
    }

    protected void doRspecRun(FileObject testFile, ExecutionUtils.FileLocation location) {
    }

    protected final void runRspec() {
        if (this.testcase.getLocation() == null) {
            return;
        }
        ExecutionUtils.FileLocation location = ExecutionUtils.getLocation((String)this.testcase.getLocation());
        if (location == null) {
            return;
        }
        FileObject testFile = OutputUtils.findFile(location.file, (LineConvertors.FileLocator)this.project.getLookup().lookup(LineConvertors.FileLocator.class));
        if (testFile == null) {
            return;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)testFile);
        if (!this.project.equals(owner)) {
            LOGGER.fine("Resolving FileObject for " + this.getTestMethod() + "/" + testFile + " failed." + "Got " + owner + ", expected " + this.project);
        }
        this.doRspecRun(testFile, location);
    }
}

