/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.DepScanningSettings;
import org.netbeans.modules.java.hints.options.HintsPanelLogic;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.options.editor.spi.OptionsFilter;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class HintsPanel
extends JPanel
implements TreeCellRenderer {
    private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();
    private JCheckBox renderer = new JCheckBox();
    private HintsPanelLogic logic;
    private final DefaultTreeModel errorTreeModel;
    DefaultMutableTreeNode extraNode = new DefaultMutableTreeNode(NbBundle.getMessage(HintsPanel.class, (String)"CTL_DepScanning"));
    private JPanel customizerPanel;
    private JLabel descriptionLabel;
    private JPanel descriptionPanel;
    private JEditorPane descriptionTextArea;
    private JPanel detailsPanel;
    private JTree errorTree;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JPanel optionsPanel;
    private JComboBox severityComboBox;
    private JLabel severityLabel;
    private JCheckBox toProblemCheckBox;
    private JPanel treePanel;
    private final Map<HintMetadata, TreePath> hint2Path = new HashMap<HintMetadata, TreePath>();

    HintsPanel(@NullAllowed OptionsFilter optionsFilter) {
        this.initComponents();
        this.descriptionTextArea.setContentType("text/html");
        this.errorTree.setCellRenderer(this);
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        this.errorTree.getSelectionModel().setSelectionMode(1);
        this.toProblemCheckBox.setVisible(false);
        this.update();
        this.errorTreeModel = this.constructTM(RulesManager.getInstance().allHints.keySet());
        if (optionsFilter != null) {
            optionsFilter.installFilteringModel(this.errorTree, (TreeModel)this.errorTreeModel, (OptionsFilter.Acceptor)new AcceptorImpl());
        } else {
            this.errorTree.setModel(this.errorTreeModel);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.treePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.errorTree = new JTree();
        this.detailsPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.severityLabel = new JLabel();
        this.severityComboBox = new JComboBox();
        this.toProblemCheckBox = new JCheckBox();
        this.customizerPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionTextArea = new JEditorPane();
        this.descriptionLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setOpaque(false);
        this.treePanel.setOpaque(false);
        this.treePanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.errorTree);
        this.errorTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleName"));
        this.errorTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleDescription"));
        this.treePanel.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.treePanel);
        this.detailsPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.detailsPanel.setOpaque(false);
        this.detailsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.severityLabel.setLabelFor(this.severityComboBox);
        Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.optionsPanel.add((Component)this.severityLabel, gridBagConstraints);
        this.severityLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.severityLabel.AccessibleContext.accessibleDescription"));
        this.severityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.optionsPanel.add((Component)this.severityComboBox, gridBagConstraints);
        this.severityComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"AN_Show_As_Combo"));
        this.severityComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"AD_Show_As_Combo"));
        Mnemonics.setLocalizedText((AbstractButton)this.toProblemCheckBox, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_InTasklist_CheckBox"));
        this.toProblemCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toProblemCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.toProblemCheckBox, gridBagConstraints);
        this.customizerPanel.setOpaque(false);
        this.customizerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.customizerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.detailsPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.descriptionPanel.setOpaque(false);
        this.descriptionPanel.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.jScrollPane2.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.descriptionPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTextArea);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.descriptionPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.detailsPanel.add((Component)this.descriptionPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.detailsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleDescription"));
    }

    synchronized void update() {
        if (this.logic != null) {
            this.logic.disconnect();
        }
        this.logic = new HintsPanelLogic();
        this.logic.connect(this.errorTree, this.errorTreeModel, this.severityLabel, this.severityComboBox, this.toProblemCheckBox, this.customizerPanel, this.descriptionTextArea);
    }

    void cancel() {
        this.logic.disconnect();
        this.logic = null;
    }

    boolean isChanged() {
        return this.logic != null ? this.logic.isChanged() : false;
    }

    void applyChanges() {
        this.logic.applyChanges();
        this.logic.disconnect();
        this.logic = null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.renderer.setBackground(bl ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
        this.renderer.setForeground(bl ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
        this.renderer.setEnabled(true);
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object2 instanceof HintsPanelLogic.HintCategory) {
            HintsPanelLogic.HintCategory hintCategory = (HintsPanelLogic.HintCategory)object2;
            this.renderer.setText(hintCategory.displayName);
            if (this.logic != null) {
                this.renderer.setSelected(this.logic.isSelected((DefaultMutableTreeNode)object));
            }
        } else if (object2 instanceof HintMetadata) {
            HintMetadata hintMetadata = (HintMetadata)object2;
            this.renderer.setText(hintMetadata.displayName);
            if (this.logic != null) {
                Preferences preferences = this.logic.getCurrentPrefernces(hintMetadata.id);
                this.renderer.setSelected(HintsSettings.isEnabled(hintMetadata, preferences));
            }
        } else {
            this.renderer.setText(object.toString());
            if (object == this.extraNode && this.logic != null) {
                this.renderer.setSelected(this.logic.getCurrentDependencyTracking() != DepScanningSettings.DependencyTracking.DISABLED);
            }
        }
        return this.renderer;
    }

    static String getFileObjectLocalizedName(FileObject fileObject) {
        Object object = fileObject.getAttribute("SystemFileSystem.localizingBundle");
        if (object instanceof String) {
            String string = (String)object;
            try {
                ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
                String string2 = resourceBundle.getString(fileObject.getPath());
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return fileObject.getPath();
    }

    private DefaultTreeModel constructTM(Collection<? extends HintMetadata> collection) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        TreeMap<HintsPanelLogic.HintCategory, TreeSet<HintMetadata>> treeMap = new TreeMap<HintsPanelLogic.HintCategory, TreeSet<HintMetadata>>(new Comparator<HintsPanelLogic.HintCategory>(){

            @Override
            public int compare(HintsPanelLogic.HintCategory hintCategory, HintsPanelLogic.HintCategory hintCategory2) {
                return HintsPanel.compare(hintCategory.displayName, hintCategory2.displayName);
            }
        });
        HashMap<String, HintsPanelLogic.HintCategory> hashMap = new HashMap<String, HintsPanelLogic.HintCategory>();
        for (HintMetadata object2 : collection) {
            TreeSet<HintMetadata> treeSet;
            if (object2.kind != HintMetadata.Kind.HINT && object2.kind != HintMetadata.Kind.SUGGESTION) continue;
            object = (HintsPanelLogic.HintCategory)hashMap.get(object2.category);
            if (object == null) {
                object = new HintsPanelLogic.HintCategory(object2.category);
                hashMap.put(object2.category, (HintsPanelLogic.HintCategory)object);
            }
            if ((treeSet = (Collection)treeMap.get(object)) == null) {
                treeSet = new TreeSet<HintMetadata>(new Comparator<HintMetadata>(){

                    @Override
                    public int compare(HintMetadata hintMetadata, HintMetadata hintMetadata2) {
                        return HintsPanel.compare(hintMetadata.displayName, hintMetadata2.displayName);
                    }
                });
                treeMap.put((HintsPanelLogic.HintCategory)object, treeSet);
            }
            treeSet.add(object2);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            object = new DefaultMutableTreeNode(entry.getKey());
            for (HintMetadata hintMetadata : (Collection)entry.getValue()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(hintMetadata);
                ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode2);
                this.hint2Path.put(hintMetadata, new TreePath(new Object[]{defaultMutableTreeNode, object, defaultMutableTreeNode2}));
            }
            defaultMutableTreeNode.add((MutableTreeNode)object);
        }
        defaultMutableTreeNode.add(this.extraNode);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    void select(HintMetadata hintMetadata) {
        TreePath treePath = this.hint2Path.get(hintMetadata);
        this.errorTree.setSelectionPath(treePath);
        this.errorTree.scrollPathToVisible(treePath);
    }

    private static int compare(String string, String string2) {
        return HintsPanel.clearNonAlpha(string).compareToIgnoreCase(HintsPanel.clearNonAlpha(string2));
    }

    private static String clearNonAlpha(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static final class AcceptorImpl
    implements OptionsFilter.Acceptor {
        private AcceptorImpl() {
        }

        public boolean accept(Object object, String string) {
            if (string.isEmpty()) {
                return true;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            HintMetadata hintMetadata = (HintMetadata)defaultMutableTreeNode.getUserObject();
            string = string.toLowerCase();
            if (hintMetadata.displayName.toLowerCase().contains(string)) {
                return true;
            }
            if (hintMetadata.description.toLowerCase().contains(string)) {
                return true;
            }
            for (String string2 : hintMetadata.suppressWarnings) {
                if (!string2.toLowerCase().contains(string)) continue;
                return true;
            }
            return false;
        }
    }
}

