/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class OverridableMethodCallInConstructor {
    public static ErrorDescription hint(HintContext hintContext) {
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)hintContext.getPath().getLeaf();
        CompilationInfo compilationInfo = hintContext.getInfo();
        TreePath treePath = Utilities.findEnclosingMethodOrConstructor(hintContext, hintContext.getPath());
        if (treePath == null) {
            return null;
        }
        Element element = hintContext.getInfo().getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.CONSTRUCTOR) {
            return null;
        }
        Element element2 = compilationInfo.getTrees().getElement(new TreePath(hintContext.getPath(), methodInvocationTree.getMethodSelect()));
        if (element2 == null || element2.getKind() != ElementKind.METHOD) {
            return null;
        }
        Element element3 = element2.getEnclosingElement();
        if (element3 == null || element3.getKind() != ElementKind.CLASS) {
            return null;
        }
        if (!((Object)element3).equals(element.getEnclosingElement())) {
            return null;
        }
        if (element3.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        Set<Modifier> set = element2.getModifiers();
        if (set.contains((Object)Modifier.PRIVATE) || set.contains((Object)Modifier.FINAL) || set.contains((Object)Modifier.STATIC)) {
            return null;
        }
        if (!OverridableMethodCallInConstructor.invocationOnThis(methodInvocationTree)) {
            return null;
        }
        TreePath treePath2 = hintContext.getInfo().getTrees().getPath(element2);
        if (treePath2 == null || hintContext.getInfo().getTreeUtilities().isSynthetic(treePath2)) {
            return null;
        }
        return ErrorDescriptionFactory.forName(hintContext, methodInvocationTree, NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"MSG_org.netbeans.modules.java.hints.OverridableMethodCallInConstructor"), OverridableMethodCallInConstructor.computeFixes((MethodTree)treePath2.getLeaf(), element3, hintContext));
    }

    private static Fix[] computeFixes(MethodTree methodTree, Element element, HintContext hintContext) {
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        ClassTree classTree = hintContext.getInfo().getTrees().getTree((TypeElement)element);
        arrayList.add(FixFactory.addModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getInfo().getCompilationUnit(), (Tree)classTree.getModifiers()), Collections.singleton(Modifier.FINAL), NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"FIX_MakeClass", (Object)"final", (Object)classTree.getSimpleName())));
        Set<Modifier> set = methodTree.getModifiers().getFlags();
        arrayList.add(FixFactory.addModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getInfo().getCompilationUnit(), (Tree)methodTree.getModifiers()), Collections.singleton(Modifier.FINAL), NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"FIX_MakeMethod", (Object)"final", (Object)methodTree.getName())));
        arrayList.add(FixFactory.addModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getInfo().getCompilationUnit(), (Tree)methodTree.getModifiers()), Collections.singleton(Modifier.STATIC), NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"FIX_MakeMethod", (Object)"static", (Object)methodTree.getName())));
        arrayList.add(FixFactory.changeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getInfo().getCompilationUnit(), (Tree)methodTree.getModifiers()), Collections.singleton(Modifier.PRIVATE), set, NbBundle.getMessage(OverridableMethodCallInConstructor.class, (String)"FIX_MakeMethod", (Object)"private", (Object)methodTree.getName())));
        return arrayList.toArray(new Fix[arrayList.size()]);
    }

    private static boolean invocationOnThis(MethodInvocationTree methodInvocationTree) {
        ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
        switch (expressionTree.getKind()) {
            case IDENTIFIER: {
                return true;
            }
            case MEMBER_SELECT: {
                if (((MemberSelectTree)expressionTree).getExpression().getKind() != Tree.Kind.IDENTIFIER) break;
                IdentifierTree identifierTree = (IdentifierTree)((MemberSelectTree)expressionTree).getExpression();
                return identifierTree.getName().contentEquals("this");
            }
        }
        return false;
    }
}

