/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.gsfret;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.gsfret.InstantRenamePerformer;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class InstantRenameAction
extends BaseAction {
    public InstantRenameAction() {
        super("in-place-refactoring", 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        String ident = null;
        final int caret = target.getCaretPosition();
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        try {
            doc.readLock();
            ident = Utilities.getIdentifier((BaseDocument)doc, (int)caret);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            doc.readUnlock();
        }
        try {
            if (ident == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)"Cannot perform rename here.");
                return;
            }
            if (SourceUtils.isScanInProgress()) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)"Scanning In Progress");
                return;
            }
            Source js = Source.forFileObject(DataLoadersBridge.getDefault().getFileObject(target));
            if (js == null) {
                return;
            }
            final boolean[] wasResolved = new boolean[1];
            final String[] message = new String[1];
            final Set[] changePoints = new Set[1];
            js.runUserActionTask(new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    if (controller.toPhase(Phase.RESOLVED).compareTo(Phase.RESOLVED) < 0) {
                        return;
                    }
                    Document doc = target.getDocument();
                    BaseDocument baseDoc = (BaseDocument)doc;
                    List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDoc, caret);
                    Language language = null;
                    for (Language l : list) {
                        if (l.getInstantRenamer() == null) continue;
                        language = l;
                        break;
                    }
                    if (language != null) {
                        InstantRenamer renamer = language.getInstantRenamer();
                        assert (renamer != null);
                        String[] descRetValue = new String[1];
                        if (renamer == null || !renamer.isRenameAllowed((CompilationInfo)controller, caret, descRetValue)) {
                            wasResolved[0] = false;
                            message[0] = descRetValue[0];
                            return;
                        }
                        wasResolved[0] = true;
                        Set regions = renamer.getRenameRegions((CompilationInfo)controller, caret);
                        if (regions != null && regions.size() > 0) {
                            changePoints[0] = regions;
                        }
                    }
                }
            }, true);
            if (wasResolved[0]) {
                if (changePoints[0] != null) {
                    this.doInstantRename(changePoints[0], target, caret, ident);
                } else {
                    this.doFullRename((EditorCookie)DataLoadersBridge.getDefault().getCookie(target, EditorCookie.class), DataLoadersBridge.getDefault().getNodeDelegate(target));
                }
            } else {
                if (message[0] == null) {
                    message[0] = NbBundle.getMessage(InstantRenameAction.class, (String)"InstantRenameDenied");
                }
                Utilities.setStatusBoldText((JTextComponent)target, (String)message[0]);
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    protected Class getShortDescriptionBundleClass() {
        return InstantRenameAction.class;
    }

    private void doInstantRename(Set<OffsetRange> changePoints, JTextComponent target, int caret, String ident) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(target, changePoints, caret);
    }

    private void doFullRename(EditorCookie ec, Node n) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)ec);
        ic.add((Object)n);
        AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
        Action a = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)actionContext);
        a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }
}

