/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.Project;
import org.apache.tools.bzip2.CBZip2InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static final Pack200.Packer packer = Pack200.newPacker();
    private static final Pack200.Unpacker unpacker = Pack200.newUnpacker();
    private static byte[] buffer = new byte[102400];
    private static Project project = null;
    private static boolean tarInitialized = false;
    private static String tarExecutable = null;
    private static boolean lsInitialized = false;
    private static String lsExecutable = null;
    public static final int MAX_EXECUTION_TIME = 300000;
    public static final String MAX_EXECUTION_TIME_PROPERTY = "process.max.execution.time";
    public static final int MAX_DELAY = 50;
    public static final int DELTA_DELAY = 1;
    public static final int INITIAL_DELAY = 1;
    public static final String ARG_PREFIX = "-J";
    public static final String XMX_ARG = "-Xmx";
    public static final String PERM_SIZE_ARG = "-XX:PermSize=";
    public static final String MAX_PERM_SIZE_ARG = "-XX:MaxPermSize=";
    public static final String CLASSPATH_ARG = "-cp";
    public static final String VERIFIER_CLASSNAME = "org.netbeans.installer.infra.build.ant.utils.VerifyFile";
    public static final String CLASSPATH_VALUE_PROPERTY = "custom.tasks.cls";
    public static final String MD5 = "MD5";
    public static final String JAR_EXTENSION = ".jar";
    public static final String SUN_MICR_RSA = "META-INF/SUN_MICR.RSA";
    public static final String SUN_MICR_SF = "META-INF/SUN_MICR.SF";
    public static final String NEWLINE_REGEXP = "(?:\n\r|\r\n|\n|\r)";
    public static final String SLASH = "/";
    public static final String UBERKEY = "uberkey";
    public static final String UBERKEY_REGEXP = "uberkey=(.*)$";
    public static final String UTF8 = "UTF-8";
    public static final String OS_NAME = "os.name";
    public static final String WINDOWS = "Windows";
    public static final boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_HOME_VALUE = System.getProperty("java.home");
    public static final String JAVA = "bin/java";
    public static final String JAVA_EXE = "bin\\java.exe";
    private static final String VERIFICATION_JAVA_EXECUTABLE = JAVA_HOME_VALUE + File.separator + (IS_WINDOWS ? "bin\\java.exe" : "bin/java");
    private static final String PACKER_EXECUTABLE = JAVA_HOME_VALUE + (IS_WINDOWS ? "\\bin\\pack200.exe" : "/bin/pack200");
    private static final String UNPACKER_EXECUTABLE = JAVA_HOME_VALUE + (IS_WINDOWS ? "\\bin\\unpack200.exe" : "/bin/unpack200");
    private static final String NATIVE_UNZIP_EXECUTABLE = IS_WINDOWS ? "unzip.exe" : "unzip";
    private static final String NATIVE_TAR_EXECUTABLE = IS_WINDOWS ? "tar.exe" : "tar";
    private static final String NATIVE_GTAR_EXECUTABLE = IS_WINDOWS ? "gtar.exe" : "gtar";
    private static final String NATIVE_GNUTAR_EXECUTABLE = IS_WINDOWS ? "gnutar.exe" : "gnutar";
    public static final String PACKER_EXECUTABLE_PROPERTY = "pack200.executable";
    public static final String UNPACKER_EXECUTABLE_PROPERTY = "unpack200.executable";
    public static final String TAR_EXECUTABLE_PROPERTY = "tar.executable";
    public static final String UNZIP_EXECUTABLE_PROPERTY = "unzip.executable";
    public static final String LS_EXECUTABLE_PROPERTY = "ls.executable";
    public static final String JARSIGNER_EXECUTABLE_PROPERTY = "jarsigner.executable";
    public static final String VERIFICATION_JAVA_EXECUTABLE_PROPERTY = "verification.java.executable";
    public static final String DEFAULT_EXECUTABLE_PERMISSION_FILE_PROP = "default.file.executable.permissions";
    public static final String DEFAULT_NOT_EXECUTABLE_PERMISSION_FILE_PROP = "default.file.not.executable.permissions";
    public static final String DEFAULT_PERMISSION_DIR_PROP = "default.dir.permissions";
    private static final String JARSIGNER_EXECUTABLE = JAVA_HOME_VALUE + (IS_WINDOWS ? "\\..\\bin\\jarsigner.exe" : "/../bin/jarsigner");
    private static final String LS_EXECUTABLE = IS_WINDOWS ? "ls.exe" : "ls";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String[] EXECUTABLE_EXTENSIONS = new String[]{"so", "a", "jnilib", "dylib", "sl", "sh", "pl", "rb", "py", "command"};
    public static final String[] NOT_EXECUTABLE_EXTENSIONS = new String[]{"jar", "zip", "gz", "bzip2", "tgz", "txt", "xml", "html", "htm", "pdf", "conf", "css", "java"};
    public static final int DEFAULT_EXECUTABLE_PERMISSION_FILE = 755;
    public static final int DEFAULT_NOT_EXECUTABLE_PERMISSION_FILE = 644;
    public static final int DEFAULT_PERMISSION_DIR = 755;

    public static void setProject(Project project) {
        Utils.project = project;
    }

    public static String getMd5(File file) throws IOException {
        return Utils.getDigest(file, MD5);
    }

    public static boolean isEmpty(File file) {
        return file.listFiles().length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJarFile(File file) {
        if (file.getName().endsWith(JAR_EXTENSION)) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSigned(File file) throws IOException {
        JarFile jar = new JarFile(file);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            boolean signatureInfoPresent = false;
            boolean signatureFilePresent = false;
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (!entryName.startsWith("META-INF/")) continue;
                if (entryName.endsWith(".RSA") || entryName.endsWith(".DSA")) {
                    signatureFilePresent = true;
                    if (!signatureInfoPresent) continue;
                    break;
                }
                if (!entryName.endsWith(".SF")) continue;
                signatureInfoPresent = true;
                if (!signatureFilePresent) continue;
                break;
            }
            boolean bl = signatureFilePresent && signatureInfoPresent;
            return bl;
        }
        finally {
            jar.close();
        }
    }

    public static boolean pack(File source, File target) throws IOException {
        return "true".equals(project.getProperty("use.internal.packer")) ? Utils.packInternally(source, target) : Utils.packExternally(source, target);
    }

    private static boolean packExternally(File source, File target) throws IOException {
        boolean result = false;
        String xmx = "-J-Xmx" + project.getProperty("pack200.xmx");
        String permSize = "-J-XX:PermSize=" + project.getProperty("pack200.perm.size");
        String maxPermSize = "-J-XX:MaxPermSize=" + project.getProperty("pack200.max.perm.size");
        Results results = Utils.run(Utils.getPackerExecutable(), xmx, permSize, maxPermSize, target.getAbsolutePath(), source.getAbsolutePath());
        if (results.getExitcode() == 0) {
            result = true;
        } else {
            System.out.println(results.getStdout());
            System.out.println(results.getStderr());
            System.out.println(results.getExitcode());
            result = false;
        }
        if (result) {
            target.setLastModified(source.lastModified());
        }
        return result;
    }

    public static boolean packInternally(File source, File target) throws IOException {
        try {
            JarFile jarFile = new JarFile(source);
            FileOutputStream outputStream = new FileOutputStream(target);
            packer.pack(jarFile, (OutputStream)outputStream);
            jarFile.close();
            outputStream.close();
            target.setLastModified(source.lastModified());
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean unpack(File source, File target) throws IOException {
        return "true".equals(project.getProperty("use.internal.unpacker")) ? Utils.unpackInternally(source, target) : Utils.unpackExternally(source, target);
    }

    private static boolean unpackExternally(File source, File target) throws IOException {
        boolean result = false;
        Results results = Utils.run(Utils.getUnPackerExecutable(), "-J-Xmx" + project.getProperty("pack200.xmx"), "-J-XX:PermSize=" + project.getProperty("pack200.perm.size"), "-J-XX:MaxPermSize=" + project.getProperty("pack200.max.perm.size"), source.getAbsolutePath(), target.getAbsolutePath());
        if (results.getExitcode() == 0) {
            result = true;
        } else {
            System.out.println(results.getStdout());
            System.out.println(results.getStderr());
            System.out.println(results.getExitcode());
            result = false;
        }
        if (result) {
            target.setLastModified(source.lastModified());
        }
        return result;
    }

    public static boolean unpackInternally(File source, File target) throws IOException {
        try {
            JarOutputStream os = new JarOutputStream(new FileOutputStream(target));
            unpacker.unpack(source, os);
            os.close();
            target.setLastModified(source.lastModified());
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean verify(File file) throws IOException {
        Results results = Utils.runClass(VERIFIER_CLASSNAME, file.getAbsolutePath());
        if (results.getExitcode() == 0) {
            return true;
        }
        System.out.println(results.getStdout());
        System.out.println(results.getStderr());
        System.out.println(results.getExitcode());
        return false;
    }

    public static boolean verifyJad(File file) throws IOException {
        File jad;
        String name = file.getName();
        if (name.endsWith(JAR_EXTENSION) && (jad = new File(file.getParent(), name.substring(0, name.length() - 4) + ".jad")).exists()) {
            FileInputStream fis = new FileInputStream(jad);
            String string = ((Object)Utils.read(fis)).toString();
            fis.close();
            Matcher matcher = Pattern.compile("MIDlet-Jar-Size: ([0-9]+).*").matcher(string);
            if (matcher.find()) {
                long size = new Long(matcher.group(1));
                long realSize = file.length();
                if (realSize != size) {
                    System.out.println("... java descriptor file exist : " + jad);
                    System.out.println("... expected jar size : " + size);
                    System.out.println("... real jar size : " + realSize);
                    return false;
                }
            }
        }
        return true;
    }

    public static CharSequence read(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        byte[] buffer = new byte[1024];
        while (in.available() > 0) {
            int read = in.read(buffer);
            String readString = new String(buffer, 0, read);
            for (String string : readString.split(NEWLINE_REGEXP)) {
                builder.append(string).append(LINE_SEPARATOR);
            }
        }
        return builder;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        while (in.available() > 0) {
            read = in.read(buffer);
            if (read <= 0) continue;
            out.write(buffer, 0, read);
        }
    }

    public static void unzip(File file, File directory) throws IOException {
        ZipFile zip = new ZipFile(file);
        if (directory.exists() && directory.isFile()) {
            throw new IOException("Directory is an existing file, cannot unzip.");
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Cannot create directory");
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File entryFile = new File(directory, entry.getName());
            if (entry.getName().endsWith(SLASH)) {
                entryFile.mkdirs();
            } else {
                InputStream in = zip.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryFile);
                Utils.copy(in, (OutputStream)out);
                in.close();
                ((OutputStream)out).close();
            }
            entryFile.setLastModified(entry.getTime());
        }
        zip.close();
    }

    public static void nativeUnzip(File file, File directory) throws IOException {
        Results results;
        String[] command = new String[]{Utils.getUnzipExecutable(), file.getAbsolutePath(), "-d", directory.getAbsolutePath()};
        if (project != null) {
            project.log("            running command: " + Arrays.asList(command));
        }
        if ((results = Utils.run(command)).getExitcode() != 0) {
            System.out.println(results.getStdout());
            System.out.println(results.getStderr());
            throw new IOException();
        }
    }

    private static final String findTarExecutable() {
        if (!tarInitialized) {
            for (String s : new String[]{NATIVE_GNUTAR_EXECUTABLE, NATIVE_GTAR_EXECUTABLE, NATIVE_TAR_EXECUTABLE}) {
                try {
                    Utils.run(s);
                    tarExecutable = s;
                    break;
                }
                catch (IOException ex) {
                }
            }
        }
        tarInitialized = true;
        return tarExecutable;
    }

    private static final String findLsExecutable() {
        if (!lsInitialized) {
            try {
                Utils.run(LS_EXECUTABLE);
                lsExecutable = LS_EXECUTABLE;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lsInitialized = true;
        }
        return lsExecutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nativeUntar(File file, File directory) throws IOException {
        String tar;
        boolean gzipCompression = file.getName().endsWith(".tar.gz") || file.getName().endsWith(".tgz");
        boolean bzip2Compression = file.getName().endsWith(".tar.bz2") || file.getName().endsWith(".tar.bzip2");
        File tempSource = null;
        if (gzipCompression || bzip2Compression) {
            tempSource = File.createTempFile("temp-tar-file", ".tar", directory);
            if (project != null) {
                project.log("... extract compressed tar archive to temporary file " + tempSource);
            }
            FileInputStream fis = new FileInputStream(file);
            GZIPInputStream is = gzipCompression ? new GZIPInputStream(fis) : new CBZip2InputStream((InputStream)fis);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(tempSource);
                Utils.copy(is, (OutputStream)fos);
            }
            catch (IOException e) {
                if (fos != null) {
                    fos.close();
                    fos = null;
                }
                tempSource.delete();
                throw e;
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                ((InputStream)is).close();
            }
        }
        if ((tar = Utils.getTarExecutable()) == null) {
            throw new IOException("... native tar executable not available");
        }
        String[] command = new String[]{tar, "xvf", (tempSource != null ? tempSource : file).getName(), "-C", directory.getAbsolutePath().replace("\\", SLASH)};
        if (project != null) {
            project.log("            running command: " + Arrays.asList(command));
        }
        try {
            Results results = Utils.run((tempSource != null ? tempSource : file).getAbsoluteFile().getParentFile(), command);
            if (results.getExitcode() != 0) {
                System.out.println(results.getStdout());
                System.out.println(results.getStderr());
                throw new IOException();
            }
        }
        finally {
            if (tempSource != null) {
                tempSource.delete();
            }
        }
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                Utils.delete(child);
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static long size(File file) {
        long size = 0L;
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                size += Utils.size(child);
            }
        }
        return size + file.length();
    }

    public static String toAscii(String string) {
        Properties properties = new Properties();
        properties.put(UBERKEY, string);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            properties.store(outputStream, "");
        }
        catch (IOException e) {
            e.printStackTrace();
            return string;
        }
        Matcher matcher = Pattern.compile(UBERKEY_REGEXP, 8).matcher(outputStream.toString());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return string;
    }

    public static void write(File file, CharSequence chars) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);
        writer.write(((Object)chars).toString());
        writer.close();
    }

    public static void copy(File source, OutputStream target) throws IOException {
        FileInputStream input = new FileInputStream(source);
        Utils.copy(input, target);
        input.close();
    }

    public static void copy(File source, File target) throws IOException {
        FileOutputStream out = new FileOutputStream(target);
        Utils.copy(source, (OutputStream)out);
        out.close();
    }

    public static String post(String url, Map<String, Object> args) throws IOException {
        String boundary = "---------------" + Math.random();
        byte[] realBoundary = ("--" + boundary).getBytes(UTF8);
        byte[] endBoundary = ("--" + boundary + "--").getBytes(UTF8);
        byte[] crlf = new byte[]{13, 10};
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.connect();
        OutputStream out = connection.getOutputStream();
        for (String key : args.keySet()) {
            Object value = args.get(key);
            out.write(realBoundary);
            out.write(crlf);
            if (value instanceof File) {
                File file = (File)value;
                out.write(("Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + file.getName() + "\"").getBytes(UTF8));
                out.write(crlf);
                out.write("Content-Type: application/octet-stream".getBytes(UTF8));
                out.write(crlf);
                out.write(crlf);
                Utils.copy(file, out);
            }
            if (value instanceof String) {
                String string = (String)value;
                out.write(("Content-Disposition: form-data; name=\"" + key + "\"").getBytes(UTF8));
                out.write(crlf);
                out.write(crlf);
                out.write(string.getBytes(UTF8));
            }
            out.write(crlf);
        }
        out.write(endBoundary);
        out.close();
        return "" + connection.getResponseCode() + " " + connection.getResponseMessage();
    }

    public static Results sign(File file, String keystore, String alias, String password) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(Utils.getJarSignerExecutable());
        command.add("-keystore");
        command.add(keystore);
        command.add(file.getAbsolutePath());
        command.add(alias);
        Process process = new ProcessBuilder(command).start();
        process.getOutputStream().write(password.getBytes());
        return Utils.handleProcess(process);
    }

    private static int getPermissionsAnalized(File file) {
        if (file.isDirectory()) {
            return Utils.getIntegerValue(DEFAULT_PERMISSION_DIR_PROP, 755);
        }
        return Utils.isExecutableAnalized(file) ? Utils.getIntegerValue(DEFAULT_EXECUTABLE_PERMISSION_FILE_PROP, 755) : Utils.getIntegerValue(DEFAULT_NOT_EXECUTABLE_PERMISSION_FILE_PROP, 644);
    }

    private static final int getIntegerValue(String prop, int defaultValue) {
        int result;
        block3: {
            result = defaultValue;
            String value = project.getProperty(prop);
            if (value != null && !value.equals("")) {
                try {
                    result = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    if (project == null) break block3;
                    project.log("Error while parsing property " + prop + " which value is [" + value + "]" + " but should be integer", (Throwable)e, 1);
                }
            }
        }
        return result;
    }

    private static final boolean isExecutableAnalized(File file) {
        block9: {
            int index = file.getName().lastIndexOf(".");
            String ext = index != -1 ? file.getName().substring(index + 1) : "";
            for (String e : EXECUTABLE_EXTENSIONS) {
                if (!ext.equals(e)) continue;
                return true;
            }
            for (String e : NOT_EXECUTABLE_EXTENSIONS) {
                if (!ext.equals(e)) continue;
                return false;
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                byte[] bytes = new byte[64];
                int c = fis.read(bytes);
                if (c >= 4) {
                    String s;
                    String[] array;
                    if (bytes[0] == 127 && bytes[1] == 69 && bytes[2] == 76 && bytes[3] == 70) {
                        return true;
                    }
                    if (bytes[0] == 35 && bytes[1] == 33 && (array = (s = new String(bytes, 0, c)).split("(?:\r\n|\n|\r)")).length > 0 && array[0].replaceAll("#!(\\s)+/", "#!/").startsWith("#!/")) {
                        return true;
                    }
                }
            }
            catch (IOException e) {
                if (fis == null) break block9;
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static int getPermissions(File file) {
        try {
            String lsExec = Utils.getLsExecutable();
            if (lsExec == null) {
                return Utils.getPermissionsAnalized(file);
            }
            Results results = Utils.run(file.getParentFile(), lsExec, "-ld", file.getName());
            String output = ((Object)results.getStdout()).toString().trim();
            if (project != null) {
                project.log("            " + output);
            } else {
                System.out.println(output);
            }
            int permissions = 0;
            if (output.length() < 9) {
                return 777;
            }
            for (int i = 0; i < 9; ++i) {
                char character = output.charAt(i + 1);
                if (i % 3 == 0) {
                    permissions *= 10;
                }
                if (character == '-') continue;
                if (i % 3 == 0 && character == 'r') {
                    permissions += 4;
                    continue;
                }
                if (i % 3 == 1 && character == 'w') {
                    permissions += 2;
                    continue;
                }
                if (i % 3 == 2 && character == 'x') {
                    ++permissions;
                    continue;
                }
                return 777;
            }
            return permissions;
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDigest(File file, String algorithm) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.reset();
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                while (((InputStream)input).available() > 0) {
                    md.update(buffer, 0, ((InputStream)input).read(buffer));
                }
            }
            finally {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            byte[] bytes = md.digest();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                String byteHex = Integer.toHexString(b);
                if (byteHex.length() == 1) {
                    byteHex = "0" + byteHex;
                }
                if (byteHex.length() > 2) {
                    byteHex = byteHex.substring(byteHex.length() - 2);
                }
                builder.append(byteHex);
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Could not find the aglorithm");
        }
    }

    private static Results runClass(String clazz, String ... args) throws IOException {
        String classPath = project.getProperty(CLASSPATH_VALUE_PROPERTY);
        ArrayList<String> command = new ArrayList<String>();
        command.add(Utils.getVerificationJavaExecutable());
        command.add(CLASSPATH_ARG);
        command.add(classPath);
        command.add(clazz);
        command.addAll(Arrays.asList(args));
        return Utils.run(command.toArray(new String[command.size()]));
    }

    private static Results handleProcess(Process process) throws IOException {
        StringBuilder processStdOut = new StringBuilder();
        StringBuilder processStdErr = new StringBuilder();
        int errorCode = 0;
        boolean doRun = true;
        long delay = 1L;
        String projectMaxTime = project.getProperty(MAX_EXECUTION_TIME_PROPERTY);
        long maxExecutionTime = projectMaxTime != null ? Long.parseLong(projectMaxTime) : 300000L;
        long start = System.currentTimeMillis();
        long end = start + maxExecutionTime;
        while (doRun && (maxExecutionTime == 0L || System.currentTimeMillis() < end)) {
            try {
                Thread.sleep(delay);
                if (delay < 50L) {
                    ++delay;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                errorCode = process.exitValue();
                doRun = false;
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
            CharSequence string = Utils.read(process.getInputStream());
            if (string.length() > 0) {
                processStdOut.append(string);
            }
            if ((string = Utils.read(process.getErrorStream())).length() <= 0) continue;
            processStdErr.append(string);
        }
        process.destroy();
        return new Results(processStdOut, processStdErr, errorCode);
    }

    private static Results run(String ... command) throws IOException {
        Process process = new ProcessBuilder(command).start();
        return Utils.handleProcess(process);
    }

    private static Results run(File directory, String ... command) throws IOException {
        Process process = new ProcessBuilder(command).directory(directory).start();
        return Utils.handleProcess(process);
    }

    public static String getPackerExecutable() {
        return Utils.getExecutable(PACKER_EXECUTABLE_PROPERTY, PACKER_EXECUTABLE);
    }

    public static String getUnPackerExecutable() {
        return Utils.getExecutable(UNPACKER_EXECUTABLE_PROPERTY, UNPACKER_EXECUTABLE);
    }

    public static String getLsExecutable() {
        String value = project.getProperty(LS_EXECUTABLE_PROPERTY);
        return value == null || value.equals("") ? Utils.findLsExecutable() : value;
    }

    public static String getUnzipExecutable() {
        return Utils.getExecutable(UNZIP_EXECUTABLE_PROPERTY, NATIVE_UNZIP_EXECUTABLE);
    }

    public static String getTarExecutable() {
        String value = project.getProperty(TAR_EXECUTABLE_PROPERTY);
        return value == null || value.equals("") ? Utils.findTarExecutable() : value;
    }

    public static String getJarSignerExecutable() {
        return Utils.getExecutable(JARSIGNER_EXECUTABLE_PROPERTY, JARSIGNER_EXECUTABLE);
    }

    public static String getVerificationJavaExecutable() {
        return Utils.getExecutable(VERIFICATION_JAVA_EXECUTABLE_PROPERTY, VERIFICATION_JAVA_EXECUTABLE);
    }

    private static String getExecutable(String propName, String defaultValue) {
        String value = project.getProperty(propName);
        return value == null || value.equals("") ? defaultValue : value;
    }

    public static final String resolveProperty(String string) {
        return Utils.resolveProperty(string, project);
    }

    public static final String resolveProperty(String string, Project prj) {
        ArrayList<String> resolving = new ArrayList<String>();
        return Utils.resolveProperty(string, prj, resolving);
    }

    private static final String resolveProperty(String string, Project prj, List<String> resolving) {
        if (string == null || string.equals("")) {
            return string;
        }
        StringBuilder result = new StringBuilder(string.length());
        StringBuilder buf = null;
        Stack<StringBuilder> started = new Stack<StringBuilder>();
        boolean inside = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': {
                    if (i + 1 < string.length() && string.charAt(i + 1) == '{') {
                        if (inside) {
                            started.push(buf);
                        }
                        ++i;
                        inside = true;
                        buf = new StringBuilder();
                        continue block4;
                    }
                    (inside ? buf : result).append("$");
                    continue block4;
                }
                case '}': {
                    if (inside) {
                        String resolved;
                        String propValue;
                        String propName = buf.toString();
                        if (resolving.contains(propName)) {
                            propValue = null;
                        } else {
                            resolving.add(propName);
                            propValue = Utils.resolveProperty(prj.getProperty(propName), prj, resolving);
                            resolving.remove(propName);
                        }
                        String string2 = resolved = propValue != null ? propValue : "${" + propName + "}";
                        if (!started.empty()) {
                            buf = ((StringBuilder)started.pop()).append(resolved);
                            continue block4;
                        }
                        result.append(resolved);
                        inside = false;
                        continue block4;
                    }
                    result.append(c);
                    continue block4;
                }
                default: {
                    (inside ? buf : result).append(c);
                }
            }
        }
        if (inside) {
            do {
                if (!started.empty()) {
                    buf = ((StringBuilder)started.pop()).append("${").append((CharSequence)buf);
                    continue;
                }
                result.append("${").append((CharSequence)buf);
                buf = null;
            } while (buf != null);
        }
        return result.toString();
    }

    private Utils() {
    }

    public static class Results {
        private CharSequence stdout;
        private CharSequence stderr;
        private int exitcode;

        public Results(CharSequence stdout, CharSequence stderr, int exitcode) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.exitcode = exitcode;
        }

        public CharSequence getStdout() {
            return this.stdout;
        }

        public CharSequence getStderr() {
            return this.stderr;
        }

        public int getExitcode() {
            return this.exitcode;
        }
    }
}

