/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support.dragging;

import java.awt.Component;
import java.awt.Point;
import java.awt.Shape;
import org.netbeans.modules.dlight.extras.api.support.dragging.Draggable;

public abstract class AbstractDraggable
implements Draggable {
    private final Component component;
    private boolean dragging;
    private int draggingShift;
    private Draggable leftBound;
    private Draggable rightBound;

    public AbstractDraggable(Component component) {
        this.component = component;
    }

    @Override
    public final void setLeftBound(Draggable leftBound) {
        this.leftBound = leftBound;
    }

    @Override
    public final void setRightBound(Draggable rightBound) {
        this.rightBound = rightBound;
    }

    @Override
    public abstract int getPosition();

    protected abstract void setPosition(int var1, boolean var2);

    protected abstract Shape getShape();

    @Override
    public final boolean containsPoint(Point p) {
        return this.getShape().contains(p);
    }

    @Override
    public final void startDragging(Point p) {
        if (!this.dragging) {
            this.dragging = true;
            this.draggingShift = this.getPosition() - p.x;
        }
    }

    @Override
    public final void dragTo(Point p, boolean isAdjusting) {
        if (this.dragging) {
            int leftBoundPos = this.leftBound == null ? 0 : this.leftBound.getPosition();
            int rightBoundPos = this.rightBound == null ? this.component.getWidth() - 1 : this.rightBound.getPosition();
            int newPos = p.x + this.draggingShift;
            if (newPos < leftBoundPos) {
                newPos = leftBoundPos;
            } else if (rightBoundPos < newPos) {
                newPos = rightBoundPos;
            }
            this.setPosition(newPos, isAdjusting);
        }
    }

    @Override
    public final void finishDragging() {
        if (this.dragging) {
            this.dragging = false;
        }
    }
}

