/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.ruby.lexer.RubyStringTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public final class RubyStringLexer
implements Lexer<RubyStringTokenId> {
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<RubyStringTokenId> tokenFactory;
    private final boolean substituting;

    public RubyStringLexer(LexerRestartInfo<RubyStringTokenId> info, boolean substituting) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.substituting = substituting;
        assert (info.state() == null);
    }

    public Object state() {
        return null;
    }

    public Token<RubyStringTokenId> nextToken() {
        return this.substituting ? this.nextTokenDoubleQuotes() : this.nextTokenSingleQuotes();
    }

    public Token<RubyStringTokenId> nextTokenSingleQuotes() {
        while (true) {
            int ch = this.input.read();
            switch (ch) {
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.token(RubyStringTokenId.STRING_TEXT);
                    }
                    return null;
                }
                case 92: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)RubyStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    ch = this.input.read();
                    switch (ch) {
                        case 39: 
                        case 92: {
                            return this.token(RubyStringTokenId.STRING_ESCAPE);
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            return this.token(RubyStringTokenId.STRING_TEXT);
                        }
                    }
                    return this.token(RubyStringTokenId.STRING_INVALID);
                }
            }
        }
    }

    public Token<RubyStringTokenId> nextTokenDoubleQuotes() {
        while (true) {
            int ch = this.input.read();
            block0 : switch (ch) {
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.token(RubyStringTokenId.STRING_TEXT);
                    }
                    return null;
                }
                case 35: {
                    int c;
                    int f = this.input.read();
                    if (f != 123) break;
                    if (this.input.readLength() > 2) {
                        this.input.backup(2);
                        return this.tokenFactory.createToken((TokenId)RubyStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    while ((c = this.input.read()) != -1 && c != 125) {
                    }
                    return this.token(RubyStringTokenId.EMBEDDED_RUBY);
                }
                case 92: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)RubyStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    ch = this.input.read();
                    switch (ch) {
                        case 120: {
                            if (RubyStringLexer.isHexDigit(this.input.read())) {
                                if (RubyStringLexer.isHexDigit(this.input.read())) {
                                    return this.token(RubyStringTokenId.STRING_ESCAPE);
                                }
                                this.input.backup(2);
                                break block0;
                            }
                            this.input.backup(1);
                            break block0;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            switch (this.input.read()) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    switch (this.input.read()) {
                                        case 48: 
                                        case 49: 
                                        case 50: 
                                        case 51: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 55: {
                                            return this.token(RubyStringTokenId.STRING_ESCAPE);
                                        }
                                    }
                                    this.input.backup(1);
                                    break;
                                }
                                default: {
                                    this.input.backup(1);
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 99: {
                            int next = this.input.read();
                            if (next == 120) {
                                return this.token(RubyStringTokenId.STRING_ESCAPE);
                            }
                            this.input.backup(1);
                            break block0;
                        }
                        case 67: {
                            int next = this.input.read();
                            if (next == 45) {
                                next = this.input.read();
                                if (next == 120) {
                                    return this.token(RubyStringTokenId.STRING_ESCAPE);
                                }
                                this.input.backup(2);
                                break block0;
                            }
                            this.input.backup(1);
                            break block0;
                        }
                        case 77: {
                            int next = this.input.read();
                            if (next == 45) {
                                next = this.input.read();
                                if (next == 120) {
                                    return this.token(RubyStringTokenId.STRING_ESCAPE);
                                }
                                this.input.backup(2);
                                break block0;
                            }
                            this.input.backup(1);
                            break block0;
                        }
                        default: {
                            return this.token(RubyStringTokenId.STRING_ESCAPE);
                        }
                    }
                }
            }
        }
    }

    private static boolean isHexDigit(int c) {
        return Character.isDigit(c) || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private Token<RubyStringTokenId> token(RubyStringTokenId id) {
        return this.tokenFactory.createToken((TokenId)id);
    }

    public void release() {
    }
}

