/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class HashNameAnalyzer {
    private static final Pattern CONFIGURATION_OPTIONS = Pattern.compile(".*(Configuration options|Supported options|=== Options|Options are:).*");
    private static final Pattern HASH_NAME = Pattern.compile(".*(?:<tt>|\\[):(\\w+)(?:</tt>|\\]).*");
    private final List<String> rdocs;
    private final String paramName;

    private HashNameAnalyzer(String paramName, List<String> rdocs) {
        this.paramName = paramName;
        this.rdocs = rdocs;
    }

    static String collect(String paramName, List<String> rdocs) {
        if (rdocs.isEmpty()) {
            return "";
        }
        HashNameAnalyzer analyzer = new HashNameAnalyzer(paramName, rdocs);
        return analyzer.collect();
    }

    private String collect() {
        ArrayList<String> result = new ArrayList<String>();
        boolean confOptsFound = false;
        for (String line : this.rdocs) {
            String name;
            Matcher matcher;
            if (CONFIGURATION_OPTIONS.matcher(line).matches()) {
                confOptsFound = true;
                continue;
            }
            if (!confOptsFound || !(matcher = HASH_NAME.matcher(line)).matches() || result.contains(name = matcher.group(1))) continue;
            result.add(matcher.group(1));
        }
        return this.toIndexerFormat(result);
    }

    private String toIndexerFormat(List<String> hashNames) {
        if (hashNames.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.paramName + "(=>");
        Iterator<String> it = hashNames.iterator();
        while (it.hasNext()) {
            String hashName = it.next();
            result.append(hashName);
            if (!it.hasNext()) continue;
            result.append("|");
        }
        result.append(")");
        return result.toString();
    }
}

