/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.header;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class WriterUtil {
    private static Pattern whitespace = Pattern.compile("\\s");
    private static Pattern whitespaceOrQuote = Pattern.compile("[\\s\"]");

    WriterUtil() {
    }

    public static void appendQuotedMediaType(StringBuilder b, String value) {
        if (value == null) {
            return;
        }
        Matcher m = whitespaceOrQuote.matcher(value);
        boolean quote = m.find();
        if (quote) {
            b.append('\"');
        }
        WriterUtil.appendEscapingQuotes(b, value);
        if (quote) {
            b.append('\"');
        }
    }

    public static void appendQuotedIfWhitespace(StringBuilder b, String value) {
        if (value == null) {
            return;
        }
        Matcher m = whitespace.matcher(value);
        boolean quote = m.find();
        if (quote) {
            b.append('\"');
        }
        WriterUtil.appendEscapingQuotes(b, value);
        if (quote) {
            b.append('\"');
        }
    }

    public static void appendQuoted(StringBuilder b, String value) {
        b.append('\"');
        WriterUtil.appendEscapingQuotes(b, value);
        b.append('\"');
    }

    public static void appendEscapingQuotes(StringBuilder b, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                b.append('\\');
            }
            b.append(c);
        }
    }
}

