/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.openide.util.NbBundle;

public class UnknownFunctionRule
extends PHPRule {
    private static final Collection<String> IGNORED = new TreeSet<String>(Arrays.asList("die", "empty", "eval", "exit", "isset", "print", "unset"));

    @Override
    public void visit(FunctionInvocation functionInvocation) {
        Set<FunctionElement> functions;
        String fname;
        ASTNode parent = this.context.path.get(0);
        if (!(parent instanceof MethodInvocation || parent instanceof StaticMethodInvocation || (fname = CodeUtils.extractFunctionName(functionInvocation)) == null || IGNORED.contains(fname.toLowerCase()) || (functions = this.context.getIndex().getFunctions(NameKind.exact(fname))).size() != 0)) {
            FunctionName funcName = functionInvocation.getFunctionName();
            OffsetRange range = new OffsetRange(funcName.getStartOffset(), funcName.getEndOffset());
            Hint hint = new Hint((Rule)this, this.getDisplayName(), this.context.parserResult.getSnapshot().getSource().getFileObject(), range, null, 500);
            this.addResult(hint);
        }
        super.visit(functionInvocation);
    }

    public String getId() {
        return "unknown.function";
    }

    public String getDescription() {
        return NbBundle.getMessage(UnknownFunctionRule.class, (String)"UnknownFunctionDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UnknownFunctionRule.class, (String)"UnknownFunctionDispName");
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }
}

