/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.openide.util.Parameters;

public final class ConstantElementImpl
extends FullyQualifiedElementImpl
implements ConstantElement {
    public static final String IDX_FIELD = "const";
    private final String value;

    private ConstantElementImpl(QualifiedName qualifiedName, String value, int offset, String fileUrl, ElementQuery elementQuery) {
        super(qualifiedName.toName().toString(), qualifiedName.toNamespaceName().toString(), fileUrl, offset, elementQuery);
        this.value = value;
    }

    public static Set<ConstantElement> fromSignature(IndexQueryImpl indexQuery, IndexResult indexResult) {
        return ConstantElementImpl.fromSignature(NameKind.empty(), indexQuery, indexResult);
    }

    public static Set<ConstantElement> fromSignature(NameKind query, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<ConstantElement> retval = values.length > 0 ? new HashSet<ConstantElement>() : Collections.emptySet();
        for (String val : values) {
            ConstantElement constant = ConstantElementImpl.fromSignature(query, indexQuery, indexResult, Signature.get(val));
            if (constant == null) continue;
            retval.add(constant);
        }
        return retval;
    }

    private static ConstantElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature sig) {
        ConstantSignatureParser signParser = new ConstantSignatureParser(sig);
        ConstantElementImpl retval = null;
        if (ConstantElementImpl.matchesQuery(query, signParser)) {
            retval = new ConstantElementImpl(signParser.getQualifiedName(), signParser.getValue(), signParser.getOffset(), indexResult.getUrl().toString(), (ElementQuery)indexScopeQuery);
        }
        return retval;
    }

    private static boolean matchesQuery(NameKind query, ConstantSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(ConstantElement.KIND, signParser.getQualifiedName());
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return ConstantElement.KIND;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        QualifiedName namespaceName = this.getNamespaceName();
        sb.append(namespaceName.toString()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getValue()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        this.checkConstantSignature(sb);
        return sb.toString();
    }

    private void checkConstantSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            ConstantSignatureParser parser = new ConstantSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getQualifiedName().toName().toString()));
            assert (this.getNamespaceName().equals(parser.getQualifiedName().toNamespaceName()));
            assert (this.getOffset() == parser.getOffset());
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    private static class ConstantSignatureParser {
        private final Signature signature;

        ConstantSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.signature.string(3), this.signature.string(1));
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        String getValue() {
            return this.signature.string(4);
        }
    }
}

