/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConvertIfToUnless
extends RubyAstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.IFNODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        ParserResult info = context.parserResult;
        IfNode ifNode = (IfNode)node;
        Node condition = ifNode.getCondition();
        if (condition == null) {
            return;
        }
        if (ifNode.getElseBody() != null && ifNode.getElseBody().getNodeType() == NodeType.IFNODE) {
            return;
        }
        if (condition.getNodeType() == NodeType.NOTNODE || condition.getNodeType() == NodeType.NEWLINENODE && condition.childNodes().size() == 1 && ((Node)condition.childNodes().get(0)).getNodeType() == NodeType.NOTNODE) {
            try {
                ConvertToUnlessFix fix;
                BaseDocument doc = context.doc;
                int keywordOffset = ConvertIfToUnless.findKeywordOffset(context, ifNode);
                if (keywordOffset == -1 || keywordOffset > doc.getLength() - 1) {
                    return;
                }
                OffsetRange range = AstUtilities.getRange((Node)node);
                if (RubyUtils.isRhtmlDocument((Document)doc) || RubyUtils.isYamlDocument((Document)doc)) {
                    if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) == OffsetRange.NONE) {
                        return;
                    }
                    try {
                        doc.readLock();
                        TokenHierarchy th = TokenHierarchy.get((Document)doc);
                        TokenSequence ts = th.tokenSequence();
                        ts.move(range.getStart());
                        if (!ts.moveNext() && !ts.movePrevious()) {
                            return;
                        }
                        if (ts.offset() + ts.token().length() < range.getEnd()) {
                            return;
                        }
                    }
                    finally {
                        if (doc != null) {
                            doc.readUnlock();
                        }
                    }
                }
                if ((fix = new ConvertToUnlessFix(context, ifNode)).getEditList() == null) {
                    return;
                }
                List<ConvertToUnlessFix> fixes = Collections.singletonList(fix);
                String displayName = NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnless");
                Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixes, 500);
                result.add(desc);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public String getId() {
        return "ConvertIfToUnless";
    }

    public String getDescription() {
        return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnlessDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnless");
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    static int findKeywordOffset(RubyRuleContext context, IfNode ifNode) throws BadLocationException {
        BaseDocument doc = context.doc;
        ParserResult info = context.parserResult;
        int astIfOffset = ifNode.getPosition().getStartOffset();
        int lexIfOffset = LexUtilities.getLexerOffset((Parser.Result)info, (int)astIfOffset);
        if (lexIfOffset == -1 || lexIfOffset > doc.getLength()) {
            return -1;
        }
        String statement = doc.getText(lexIfOffset, 2);
        if (statement.equals("if")) {
            if (lexIfOffset > 3 && "elsif".equals(statement = doc.getText(lexIfOffset - 3, 5))) {
                return -1;
            }
            return lexIfOffset;
        }
        if (statement.equals("un")) {
            return lexIfOffset;
        }
        int conditionStart = LexUtilities.getLexerOffset((Parser.Result)info, (int)AstUtilities.getRange((Node)ifNode.getCondition()).getStart());
        int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)conditionStart);
        if (lineStart != -1 && lineStart < conditionStart) {
            String line = doc.getText(lineStart, conditionStart - lineStart).trim();
            if (line.endsWith("elsif")) {
                return -1;
            }
            if (line.endsWith("if")) {
                return lineStart + line.length() - 2;
            }
            if (line.endsWith("unless")) {
                return lineStart + line.length() - 6;
            }
        }
        return -1;
    }

    private class ConvertToUnlessFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final IfNode ifNode;

        public ConvertToUnlessFix(RubyRuleContext context, IfNode ifNode) {
            this.context = context;
            this.ifNode = ifNode;
        }

        public String getDescription() {
            String to;
            String from;
            String lif = "if";
            String lunless = "unless";
            if (this.ifNode.getThenBody() != null) {
                from = lif;
                to = lunless;
            } else {
                from = lunless;
                to = lif;
            }
            return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnlessFix", (Object)from, (Object)to);
        }

        public void implement() throws Exception {
            EditList edits = this.getEditList();
            if (edits != null) {
                edits.apply();
            }
        }

        public EditList getEditList() {
            BaseDocument doc = this.context.doc;
            try {
                int keywordOffset;
                Node notNode = this.ifNode.getCondition();
                if (notNode.getNodeType() != NodeType.NOTNODE) {
                    Node firstChild;
                    assert (notNode.getNodeType() == NodeType.NEWLINENODE);
                    Node node = firstChild = notNode.childNodes().size() == 1 ? (Node)notNode.childNodes().get(0) : null;
                    if (firstChild != null && firstChild.getNodeType() == NodeType.NOTNODE) {
                        notNode = firstChild;
                    } else {
                        assert (false) : firstChild;
                        return null;
                    }
                }
                int deleteSize = 1;
                ParserResult info = this.context.parserResult;
                int astNotOffset = AstUtilities.getRange((Node)notNode).getStart();
                int lexNotOffset = LexUtilities.getLexerOffset((Parser.Result)info, (int)astNotOffset);
                if (lexNotOffset == -1 || lexNotOffset > doc.getLength() - 1) {
                    return null;
                }
                int astIfOffset = this.ifNode.getPosition().getStartOffset();
                int lexIfOffset = LexUtilities.getLexerOffset((Parser.Result)info, (int)astIfOffset);
                if (lexIfOffset == -1 || lexIfOffset > doc.getLength()) {
                    return null;
                }
                boolean isEqualComparison = false;
                char c = doc.getText(lexNotOffset, 1).charAt(0);
                if (c != '!') {
                    int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)lexNotOffset);
                    String line = doc.getText(lexNotOffset, lineEnd - lexNotOffset);
                    int lineOffset = line.indexOf("!=");
                    if (lineOffset == -1) {
                        lineOffset = line.indexOf("!~");
                        if (lineOffset != -1) {
                            lexNotOffset += lineOffset;
                        } else {
                            String not;
                            boolean ok = false;
                            if (lexNotOffset < doc.getLength() - 3 && "not".equals(not = doc.getText(lexNotOffset, 3))) {
                                deleteSize = 3;
                                if (lexNotOffset < doc.getLength() - 4 && "not ".equals(not = doc.getText(lexNotOffset, 4))) {
                                    deleteSize = 4;
                                }
                                ok = true;
                            }
                            if (!ok) {
                                assert (false) : line;
                                return null;
                            }
                        }
                    } else {
                        lexNotOffset += lineOffset;
                        isEqualComparison = true;
                    }
                }
                if ((keywordOffset = ConvertIfToUnless.findKeywordOffset(this.context, this.ifNode)) == -1 || keywordOffset > doc.getLength() - 1) {
                    return null;
                }
                assert (keywordOffset < lexNotOffset);
                char k = doc.getText(keywordOffset, 1).charAt(0);
                boolean isIf = k == 'i';
                EditList edits = new EditList(doc);
                if (isEqualComparison) {
                    edits.replace(lexNotOffset, 1, "=", false, 0);
                } else {
                    edits.replace(lexNotOffset, deleteSize, null, false, 0);
                }
                if (isIf) {
                    edits.replace(keywordOffset, 2, "unless", false, 1);
                } else {
                    edits.replace(keywordOffset, 6, "if", false, 1);
                }
                return edits;
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
                return null;
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

