/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.impl.InvalidationListener;
import org.netbeans.modules.refactoring.spi.impl.Util;
import org.openide.LifecycleManager;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public final class UndoManager
extends FileChangeAdapter
implements DocumentListener,
PropertyChangeListener {
    private LinkedList<LinkedList<UndoItem>> undoList;
    private LinkedList<LinkedList<UndoItem>> redoList;
    private final Set<CloneableEditorSupport> allCES = new HashSet<CloneableEditorSupport>();
    private final Map<FileObject, CloneableEditorSupport> fileObjectToCES = new HashMap<FileObject, CloneableEditorSupport>();
    private final Map<Document, CloneableEditorSupport> documentToCES = new HashMap<Document, CloneableEditorSupport>();
    private final Map<InvalidationListener, Collection<? extends CloneableEditorSupport>> listenerToCES = new HashMap<InvalidationListener, Collection<? extends CloneableEditorSupport>>();
    private boolean listenersRegistered = false;
    public static final String PROP_STATE = "state";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean wasUndo = false;
    private boolean wasRedo = false;
    private boolean transactionStart;
    private boolean dontDeleteUndo = false;
    private IdentityHashMap<LinkedList, String> descriptionMap;
    private String description;
    private ProgressListener progress;
    private static UndoManager instance;
    private Set<Project> projects;
    private static Field undoRedo;
    private int stepCounter = 0;

    public static UndoManager getDefault() {
        if (instance == null) {
            instance = new UndoManager();
        }
        return instance;
    }

    private UndoManager() {
        this.undoList = new LinkedList();
        this.redoList = new LinkedList();
        this.descriptionMap = new IdentityHashMap();
        this.projects = new HashSet<Project>();
    }

    private UndoManager(ProgressListener progress) {
        this();
        this.progress = progress;
    }

    public void setUndoDescription(String desc) {
        this.description = desc;
    }

    public String getUndoDescription() {
        if (this.undoList.isEmpty()) {
            return null;
        }
        return this.descriptionMap.get(this.undoList.getFirst());
    }

    public String getRedoDescription() {
        if (this.redoList.isEmpty()) {
            return null;
        }
        return this.descriptionMap.get(this.redoList.getFirst());
    }

    public void transactionStarted() {
        this.transactionStart = true;
        this.unregisterListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnded(boolean fail) {
        try {
            this.description = null;
            this.dontDeleteUndo = true;
            if (fail && !this.undoList.isEmpty()) {
                this.undoList.removeFirst();
            } else if (this.isUndoAvailable() && this.getUndoDescription() == null) {
                this.descriptionMap.remove(this.undoList.removeFirst());
                this.dontDeleteUndo = false;
            }
            this.invalidate(null);
            this.dontDeleteUndo = false;
        }
        catch (Throwable throwable) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.registerListeners();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            UndoManager.this.registerListeners();
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.fireStateChange();
            throw throwable;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.registerListeners();
        } else {
            try {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.isUndoAvailable()) {
            boolean fail = true;
            try {
                this.transactionStarted();
                this.wasUndo = true;
                LinkedList<UndoItem> undo = this.undoList.getFirst();
                this.fireProgressListenerStart(0, undo.size());
                this.undoList.removeFirst();
                Iterator undoIterator = undo.iterator();
                this.redoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.redoList.getFirst(), this.descriptionMap.remove(undo));
                while (undoIterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem item = (UndoItem)undoIterator.next();
                    item.undo();
                    if (!(item instanceof SessionUndoItem)) continue;
                    this.addItem(item);
                }
                fail = false;
            }
            finally {
                try {
                    this.wasUndo = false;
                    this.transactionEnded(fail);
                }
                finally {
                    this.fireProgressListenerStop();
                    this.fireStateChange();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        if (this.isRedoAvailable()) {
            boolean fail = true;
            try {
                this.transactionStarted();
                this.wasRedo = true;
                LinkedList<UndoItem> redo = this.redoList.getFirst();
                this.fireProgressListenerStart(1, redo.size());
                this.redoList.removeFirst();
                Iterator redoIterator = redo.iterator();
                this.description = this.descriptionMap.remove(redo);
                while (redoIterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem item = (UndoItem)redoIterator.next();
                    item.redo();
                    if (!(item instanceof SessionUndoItem)) continue;
                    this.addItem(item);
                }
                fail = false;
            }
            finally {
                try {
                    this.wasRedo = false;
                    this.transactionEnded(fail);
                }
                finally {
                    this.fireProgressListenerStop();
                    this.fireStateChange();
                }
            }
        }
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
        this.descriptionMap.clear();
        BackupFacility.getDefault().clear();
        this.fireStateChange();
    }

    public void addItem(RefactoringSession session) {
        this.addItem(new SessionUndoItem(session));
    }

    private void addItem(UndoItem item) {
        if (this.wasUndo) {
            LinkedList<UndoItem> redo = this.redoList.getFirst();
            redo.addFirst(item);
        } else {
            if (this.transactionStart) {
                this.undoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.undoList.getFirst(), this.description);
                this.transactionStart = false;
            }
            LinkedList<UndoItem> undo = this.undoList.getFirst();
            undo.addFirst(item);
        }
        if (!this.wasUndo && !this.wasRedo) {
            this.redoList.clear();
        }
    }

    public boolean isUndoAvailable() {
        return !this.undoList.isEmpty();
    }

    public boolean isRedoAvailable() {
        return !this.redoList.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    private void fireStateChange() {
        this.pcs.firePropertyChange(PROP_STATE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(Collection<? extends CloneableEditorSupport> ceSupports, InvalidationListener l) {
        Set<CloneableEditorSupport> set = this.allCES;
        synchronized (set) {
            this.registerListeners();
        }
        for (final CloneableEditorSupport cloneableEditorSupport : ceSupports) {
            final StyledDocument d = cloneableEditorSupport.getDocument();
            if (d != null) {
                NbDocument.runAtomic((StyledDocument)d, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Set set = UndoManager.this.allCES;
                        synchronized (set) {
                            if (UndoManager.this.allCES.add(cloneableEditorSupport)) {
                                cloneableEditorSupport.addPropertyChangeListener((PropertyChangeListener)UndoManager.this);
                                d.addDocumentListener(UndoManager.this);
                                UndoManager.this.documentToCES.put(d, cloneableEditorSupport);
                                Object o = d.getProperty("stream");
                                if (o instanceof DataObject) {
                                    FileObject file = ((DataObject)o).getPrimaryFile();
                                    UndoManager.this.fileObjectToCES.put(file, cloneableEditorSupport);
                                    Project p = FileOwnerQuery.getOwner((FileObject)file);
                                    if (p != null) {
                                        UndoManager.this.projects.add(p);
                                    }
                                }
                            }
                        }
                    }
                });
                continue;
            }
            Set<CloneableEditorSupport> set2 = this.allCES;
            synchronized (set2) {
                if (this.allCES.add(cloneableEditorSupport)) {
                    cloneableEditorSupport.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
        set = this.allCES;
        synchronized (set) {
            if (l != null) {
                this.listenerToCES.put(l, ceSupports);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatching(InvalidationListener l) {
        Set<CloneableEditorSupport> set = this.allCES;
        synchronized (set) {
            this.listenerToCES.remove(l);
            this.clearIfPossible();
        }
    }

    private void discardAllEdits(InvalidationListener l) {
        for (CloneableEditorSupport cloneableEditorSupport : this.listenerToCES == null || l == null ? this.allCES : this.listenerToCES.get(l)) {
            try {
                UndoRedo.Manager manager = (UndoRedo.Manager)undoRedo.get(cloneableEditorSupport);
                if (manager == null) continue;
                manager.discardAllEdits();
            }
            catch (SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void registerListeners() {
        if (this.listenersRegistered) {
            return;
        }
        Util.addFileSystemsListener((FileChangeListener)this);
        for (CloneableEditorSupport ces : this.allCES) {
            ces.addPropertyChangeListener((PropertyChangeListener)this);
        }
        for (Document doc : this.documentToCES.keySet()) {
            doc.addDocumentListener(this);
        }
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.listenersRegistered = true;
    }

    private void unregisterListeners() {
        if (!this.listenersRegistered) {
            return;
        }
        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        Util.removeFileSystemsListener((FileChangeListener)this);
        for (CloneableEditorSupport ces : this.allCES) {
            ces.removePropertyChangeListener((PropertyChangeListener)this);
        }
        for (Document doc : this.documentToCES.keySet()) {
            doc.removeDocumentListener(this);
        }
        this.listenersRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(CloneableEditorSupport ces) {
        LinkedList<LinkedList<UndoItem>> linkedList = this.undoList;
        synchronized (linkedList) {
            if (!(this.wasRedo || this.wasUndo || this.dontDeleteUndo)) {
                this.clear();
            }
            Set<CloneableEditorSupport> set = this.allCES;
            synchronized (set) {
                if (ces == null) {
                    for (InvalidationListener lis : this.listenerToCES.keySet()) {
                        lis.invalidateObject();
                        this.discardAllEdits(lis);
                    }
                    this.listenerToCES.clear();
                } else {
                    Iterator<Map.Entry<InvalidationListener, Collection<? extends CloneableEditorSupport>>> it = this.listenerToCES.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<InvalidationListener, Collection<? extends CloneableEditorSupport>> e = it.next();
                        if (!e.getValue().contains(ces)) continue;
                        e.getKey().invalidateObject();
                        it.remove();
                    }
                }
                this.clearIfPossible();
            }
        }
    }

    private void clearIfPossible() {
        if (this.listenerToCES.isEmpty() && this.undoList.isEmpty() && this.redoList.isEmpty()) {
            this.unregisterListeners();
            this.allCES.clear();
            this.documentToCES.clear();
            this.fileObjectToCES.clear();
            this.projects.clear();
        }
    }

    public void fileChanged(FileEvent fe) {
        CloneableEditorSupport ces = this.fileObjectToCES.get(fe.getFile());
        if (ces != null) {
            this.invalidate(ces);
        }
    }

    public void fileDeleted(FileEvent fe) {
        this.fileChanged(fe);
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fileChanged((FileEvent)fe);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.invalidate(this.documentToCES.get(e.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.invalidate(this.documentToCES.get(e.getDocument()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentStateChanged(CloneableEditorSupport ces) {
        Set<CloneableEditorSupport> set = this.allCES;
        synchronized (set) {
            StyledDocument d = ces.getDocument();
            Iterator<Map.Entry<Document, CloneableEditorSupport>> it = this.documentToCES.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Document, CloneableEditorSupport> en = it.next();
                if (en.getValue() != ces) continue;
                en.getKey().removeDocumentListener(this);
                it.remove();
                break;
            }
            if (d != null) {
                this.documentToCES.put(d, ces);
                d.addDocumentListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        Set<CloneableEditorSupport> set = this.allCES;
        synchronized (set) {
            this.unregisterListeners();
        }
        try {
            LifecycleManager.getDefault().saveAll();
        }
        finally {
            set = this.allCES;
            synchronized (set) {
                this.registerListeners();
            }
        }
    }

    private void fireProgressListenerStart(int type, int count) {
        this.stepCounter = 0;
        if (this.progress == null) {
            return;
        }
        this.progress.start(new ProgressEvent(this, 1, type, count));
    }

    private void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step(new ProgressEvent(this, 2, 0, ++this.stepCounter));
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            return;
        }
        this.progress.stop(new ProgressEvent(this, 4));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("openProjects".equals(evt.getPropertyName())) {
            HashSet<Project> p = new HashSet<Project>(this.projects);
            p.removeAll(Arrays.asList((Project[])evt.getNewValue()));
            if (!p.isEmpty()) {
                this.invalidate(null);
            }
        } else if ("document".equals(evt.getPropertyName())) {
            this.documentStateChanged((CloneableEditorSupport)evt.getSource());
        }
    }

    static {
        try {
            undoRedo = CloneableEditorSupport.class.getDeclaredField("undoRedo");
            undoRedo.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private final class SessionUndoItem
    implements UndoItem {
        private RefactoringSession change;

        public SessionUndoItem(RefactoringSession change) {
            this.change = change;
        }

        @Override
        public void undo() {
            this.change.undoRefactoring(false);
        }

        @Override
        public void redo() {
            this.change.doRefactoring(false);
        }
    }

    private static interface UndoItem {
        public void undo();

        public void redo();
    }
}

