/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.ProjectNameProvider;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ProjectFolder
extends JPanel
implements ActionListener,
DocumentListener,
ChangeListener {
    private static final long serialVersionUID = 7976754658427748L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ProjectNameProvider projectNameProvider;
    private final SourcesFolderProvider sourcesFolderProvider;
    private JButton projectFolderBrowseButton;
    private JCheckBox projectFolderCheckBox;
    private JLabel projectFolderLabel;
    private JScrollPane projectFolderScrollPane;
    private JTextArea projectFolderTextArea;
    private JTextField projectFolderTextField;

    public ProjectFolder(ProjectNameProvider projectNameProvider, SourcesFolderProvider sourcesFolderProvider) {
        this.projectNameProvider = projectNameProvider;
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.initComponents();
        this.init();
        this.setWarning(false);
    }

    private void init() {
        this.projectFolderCheckBox.addActionListener(this);
        this.projectFolderTextField.getDocument().addDocumentListener(this);
        this.sourcesFolderProvider.addChangeListener(this);
    }

    void addProjectFolderListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    void removeProjectFolderListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    boolean isProjectFolderUsed() {
        return this.projectFolderCheckBox.isSelected();
    }

    void setProjectFolderUsed(boolean used) {
        this.projectFolderCheckBox.setSelected(used);
        this.setState(used);
    }

    String getProjectFolder() {
        return this.projectFolderTextField.getText().trim();
    }

    void setProjectFolder(String projectFolder) {
        this.projectFolderTextField.setText(projectFolder);
    }

    void setState(boolean enabled) {
        this.projectFolderLabel.setEnabled(enabled);
        this.projectFolderTextField.setEnabled(enabled);
        this.projectFolderBrowseButton.setEnabled(enabled);
        this.setWarning(enabled);
    }

    private void setWarning(boolean enabled) {
        boolean visible;
        boolean bl = visible = enabled && this.isProjectDifferentFromSources();
        if (this.projectFolderScrollPane.isVisible() != visible) {
            this.projectFolderScrollPane.setVisible(visible);
            this.revalidate();
            this.repaint();
        }
    }

    private boolean isProjectDifferentFromSources() {
        File sources = FileUtil.normalizeFile((File)this.sourcesFolderProvider.getSourcesFolder());
        File project = FileUtil.normalizeFile((File)new File(this.getProjectFolder()));
        return !Utils.subdirectories(sources.getAbsolutePath(), project.getAbsolutePath());
    }

    private void initComponents() {
        this.projectFolderCheckBox = new JCheckBox();
        this.projectFolderLabel = new JLabel();
        this.projectFolderTextField = new JTextField();
        this.projectFolderBrowseButton = new JButton();
        this.projectFolderScrollPane = new JScrollPane();
        this.projectFolderTextArea = new JTextArea();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return ProjectFolder.this.projectFolderCheckBox;
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return ProjectFolder.this.projectFolderCheckBox;
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return ProjectFolder.this.projectFolderTextArea;
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (aComponent == ProjectFolder.this.projectFolderCheckBox) {
                    return ProjectFolder.this.projectFolderTextField;
                }
                if (aComponent == ProjectFolder.this.projectFolderBrowseButton) {
                    return ProjectFolder.this.projectFolderTextArea;
                }
                if (aComponent == ProjectFolder.this.projectFolderTextField) {
                    return ProjectFolder.this.projectFolderBrowseButton;
                }
                return ProjectFolder.this.projectFolderCheckBox;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                if (aComponent == ProjectFolder.this.projectFolderTextField) {
                    return ProjectFolder.this.projectFolderCheckBox;
                }
                if (aComponent == ProjectFolder.this.projectFolderTextArea) {
                    return ProjectFolder.this.projectFolderBrowseButton;
                }
                if (aComponent == ProjectFolder.this.projectFolderBrowseButton) {
                    return ProjectFolder.this.projectFolderTextField;
                }
                return ProjectFolder.this.projectFolderTextArea;
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.projectFolderCheckBox, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SeparateProjectFolder"));
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_MetadataFolder"));
        this.projectFolderLabel.setEnabled(false);
        this.projectFolderTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.projectFolderBrowseButton, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_BrowseProject"));
        this.projectFolderBrowseButton.setEnabled(false);
        this.projectFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectFolder.this.projectFolderBrowseButtonActionPerformed(evt);
            }
        });
        this.projectFolderScrollPane.setBorder(null);
        this.projectFolderTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.projectFolderTextArea.setEditable(false);
        this.projectFolderTextArea.setFont(this.projectFolderTextArea.getFont().deriveFont(this.projectFolderTextArea.getFont().getStyle() | 1));
        this.projectFolderTextArea.setLineWrap(true);
        this.projectFolderTextArea.setText(NbBundle.getMessage(ProjectFolder.class, (String)"TXT_MetadataInfo"));
        this.projectFolderTextArea.setToolTipText(NbBundle.getMessage(ProjectFolder.class, (String)"TXT_MetadataInfo"));
        this.projectFolderTextArea.setWrapStyleWord(true);
        this.projectFolderTextArea.setBorder(null);
        this.projectFolderTextArea.setDisabledTextColor(UIManager.getDefaults().getColor("nb.warningForeground"));
        this.projectFolderTextArea.setEnabled(false);
        this.projectFolderScrollPane.setViewportView(this.projectFolderTextArea);
        this.projectFolderTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextArea.AccessibleContext.accessibleName"));
        this.projectFolderTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextArea.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.projectFolderScrollPane, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectFolderCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.projectFolderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectFolderTextField, -1, 249, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectFolderBrowseButton))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.projectFolderCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectFolderTextField, -2, -1, -2).addComponent(this.projectFolderLabel).addComponent(this.projectFolderBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectFolderScrollPane, -2, 85, -2)));
        this.projectFolderCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderCheckBox.AccessibleContext.accessibleName"));
        this.projectFolderCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderCheckBox.AccessibleContext.accessibleDescription"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderLabel.AccessibleContext.accessibleName"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderLabel.AccessibleContext.accessibleDescription"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextField.AccessibleContext.accessibleName"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextField.AccessibleContext.accessibleDescription"));
        this.projectFolderBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderBrowseButton.AccessibleContext.accessibleName"));
        this.projectFolderBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderBrowseButton.AccessibleContext.accessibleDescription"));
        this.projectFolderScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderScrollPane.AccessibleContext.accessibleName"));
        this.projectFolderScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderScrollPane.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.AccessibleContext.accessibleDescription"));
    }

    private void projectFolderBrowseButtonActionPerformed(ActionEvent evt) {
        File newLocation = Utils.browseLocationAction(this, LastUsedFolders.getProject(), NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SelectProjectFolder"));
        if (newLocation != null) {
            this.setProjectFolder(new File(newLocation, this.projectNameProvider.getProjectName()).getAbsolutePath());
            LastUsedFolders.setProject(newLocation);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setState(this.projectFolderCheckBox.isSelected());
        this.changeSupport.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.processUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.processUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.processUpdate();
    }

    private void processUpdate() {
        this.changeSupport.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setState(this.projectFolderCheckBox.isSelected());
    }
}

