/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PanelProjectLocationExtSrc
extends SettingsPanel {
    private PanelConfigureProject firer;
    private WizardDescriptor wizardDescriptor;
    private boolean calculateName;
    private JButton jButton3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField projectLocation;
    private JTextField projectName;

    public PanelProjectLocationExtSrc(PanelConfigureProject panel) {
        this.firer = panel;
        this.initComponents();
        this.projectName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectName(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectName(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectName(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
        this.projectLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
    }

    private synchronized void calculateProjectName() {
        if (this.calculateName) {
            File f;
            String path = this.projectLocation.getText().trim();
            if (path.length() > 0) {
                f = new File(path);
                try {
                    File g = f.getCanonicalFile();
                    if (g != null) {
                        f = g;
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                this.projectName.setText(f.getName());
            }
            f = new File(this.projectLocation.getText());
            this.calculateName = true;
        }
    }

    private synchronized void setCalculateProjectName(boolean value) {
        this.calculateName = value;
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    @Override
    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        Object path = null;
        String projectName = null;
        File projectLocation = (File)settings.getProperty("projdir");
        if (projectLocation == null) {
            projectLocation = ProjectChooser.getProjectsFolder();
            this.projectLocation.setText(projectLocation.getAbsolutePath());
            this.setCalculateProjectName(true);
            this.calculateProjectName();
            this.setCalculateProjectName(true);
            projectName = this.projectName.getText();
        } else {
            projectName = (String)settings.getProperty("name");
            boolean tmpFlag = this.calculateName;
            this.projectLocation.setText(projectLocation.getAbsolutePath());
            this.setCalculateProjectName(tmpFlag);
        }
        this.projectLocation.selectAll();
    }

    @Override
    void store(WizardDescriptor settings) {
        settings.putProperty("name", (Object)this.projectName.getText());
        File projectsDir = new File(this.projectLocation.getText());
        settings.putProperty("projdir", (Object)projectsDir);
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        String result = PanelProjectLocationExtSrc.checkValidity(this.projectName.getText(), this.projectLocation.getText());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    static String checkValidity(String projectName, String projectLocation) {
        if (projectName.length() == 0 || projectName.indexOf(47) > 0 || projectName.indexOf(92) > 0 || projectName.indexOf(58) > 0) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_IllegalProjectName");
        }
        File projLoc = new File(projectLocation).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(projLoc) == null) {
            return NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
        }
        while (projLoc != null && !projLoc.exists()) {
            projLoc = projLoc.getParentFile();
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderReadOnly");
        }
        File destFolder = FileUtil.normalizeFile((File)new File(projectLocation));
        File[] kids = destFolder.listFiles();
        boolean foundRails = false;
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String file = null;
            for (int i = 0; i < kids.length; ++i) {
                String childName = kids[i].getName();
                if ("nbproject".equals(childName)) {
                    file = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"TXT_NetBeansProject");
                } else if ("config".equals(childName)) {
                    foundRails = true;
                }
                if (file == null) continue;
                String format = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(format, file);
            }
        }
        if (Util.isProjectAlready((File)destFolder)) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectAlreadyProject");
        }
        if (!foundRails) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"TXT_NoRails");
        }
        return null;
    }

    @Override
    void validate(WizardDescriptor settings) throws WizardValidationException {
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.projectName = new JTextField();
        this.jLabel6 = new JLabel();
        this.projectLocation = new JTextField();
        this.jButton3 = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_ProjectNameAndLocationLabel"));
        this.jLabel5.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.jLabel6.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_BrowseLocation_Button3"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationExtSrc.this.browseProjectLocation(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel4, -2, 400, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel6).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.projectName, -1, 221, Short.MAX_VALUE).add((Component)this.projectLocation, -1, 221, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButton3)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jButton3).add((Component)this.projectLocation, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.projectName, -2, -1, -2)).addContainerGap(40, Short.MAX_VALUE)));
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jLabel4"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jLabel4"));
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectNameLabel"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectNameLabel"));
        this.jLabel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectLocationLabel"));
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectLocationLabel"));
        this.jButton3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_browseButton"));
        this.jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_browseButton"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jPanel1"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jPanel1"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void browseProjectLocation(ActionEvent evt) {
        File file;
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_SelectProjectLocation"));
        chooser.setFileSelectionMode(1);
        String path = this.projectLocation.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.projectLocation.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }
}

