/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.TargetModuleConverter;
import org.openide.util.NbBundle;

public class TargetModule
implements TargetModuleID,
Serializable {
    private static final long serialVersionUID = 69446832504L;
    private final String id;
    private final String instanceUrl;
    private final String targetName;
    private volatile long timestamp;
    private final String contentDirectory;
    private final String contextRoot;
    private transient TargetModuleID delegate;
    public static final TargetModuleID[] EMPTY_TMID_ARRAY = new TargetModuleID[0];

    public TargetModule(String string, String string2, long l, String string3, String string4, TargetModuleID targetModuleID) {
        this(string, string2, targetModuleID.getTarget().getName(), l, string3, string4);
        this.delegate = targetModuleID;
    }

    public TargetModule(String string, String string2, String string3, long l, String string4, String string5) {
        if (string == null || string2 == null || string3 == null || l < 0L) {
            java.util.List<Object> list = Arrays.asList(string, string2, string3, l);
            throw new IllegalArgumentException(NbBundle.getMessage(TargetModule.class, (String)"MSG_BadTargetModuleAttributes", list));
        }
        this.id = string;
        this.instanceUrl = string2;
        this.targetName = string3;
        this.timestamp = l;
        this.contentDirectory = string4;
        this.contextRoot = string5 == null ? "" : string5;
    }

    public TargetModule(String string, TargetModuleID targetModuleID) {
        this(string, "someurl", 0L, null, null, targetModuleID);
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public String getTargetName() {
        if (this.delegate != null) {
            return this.delegate.getTarget().getName();
        }
        return this.targetName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    public String getContentDirectory() {
        return this.contentDirectory;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public Target findTarget() {
        ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(this.instanceUrl);
        return serverInstance.getServerTarget(this.targetName).getTarget();
    }

    public void initDelegate(ModuleType moduleType) {
        if (this.delegate == null) {
            ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(this.instanceUrl);
            DeploymentManager deploymentManager = serverInstance.getDeploymentManager();
            Target target = this.findTarget();
            try {
                TargetModuleID[] targetModuleIDArray = deploymentManager.getAvailableModules(moduleType, new Target[]{target});
                for (int i = 0; i < targetModuleIDArray.length; ++i) {
                    if (!this.id.equals(targetModuleIDArray[i].toString())) continue;
                    this.delegate = targetModuleIDArray[i];
                    break;
                }
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.INFO, null, exception);
            }
        }
    }

    public void initDelegate(TargetModuleID targetModuleID) {
        this.delegate = targetModuleID;
    }

    public static TargetModuleID[] toTargetModuleID(TargetModule[] targetModuleArray) {
        if (targetModuleArray == null) {
            return new TargetModuleID[0];
        }
        TargetModuleID[] targetModuleIDArray = new TargetModuleID[targetModuleArray.length];
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            targetModuleIDArray[i] = targetModuleArray[i].delegate();
        }
        return targetModuleIDArray;
    }

    public static Target[] toTarget(TargetModule[] targetModuleArray) {
        if (targetModuleArray == null) {
            return new Target[0];
        }
        Target[] targetArray = new Target[targetModuleArray.length];
        for (int i = 0; i < targetArray.length; ++i) {
            targetArray[i] = targetModuleArray[i].delegate().getTarget();
        }
        return targetArray;
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    public TargetModuleID delegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Delegate is not set yet");
        }
        return this.delegate;
    }

    public TargetModuleID[] getChildTargetModuleID() {
        return this.delegate().getChildTargetModuleID();
    }

    public String getModuleID() {
        return this.delegate().getModuleID();
    }

    public TargetModuleID getParentTargetModuleID() {
        return this.delegate().getParentTargetModuleID();
    }

    public Target getTarget() {
        return this.delegate().getTarget();
    }

    public String getWebURL() {
        return this.delegate().getWebURL();
    }

    public String toString() {
        if (this.delegate == null) {
            return this.id;
        }
        return this.delegate.toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof TargetModuleID) {
            TargetModuleID targetModuleID = (TargetModuleID)object;
            return this.getModuleID().equals(targetModuleID.getModuleID()) && this.getTargetName().equals(targetModuleID.getTarget().getName());
        }
        return false;
    }

    public static java.util.List initDelegate(java.util.List list, Map map) {
        ArrayList<TargetModule> arrayList = new ArrayList<TargetModule>();
        for (TargetModule targetModule : list) {
            TargetModuleID targetModuleID = (TargetModuleID)map.get(targetModule.getId());
            if (targetModuleID == null) continue;
            targetModule.initDelegate(targetModuleID);
            arrayList.add(targetModule);
        }
        return arrayList;
    }

    public static java.util.List findByContextRoot(ServerString serverString, String string) {
        String string2 = TargetModule.getManagerDirName(serverString);
        String[] stringArray = serverString.getTargets(true);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = TargetModule.getReadableName(stringArray[i]);
            java.util.List list = TargetModuleConverter.getTargetModulesByContextRoot(string2, string3, string);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static void removeByContextRoot(ServerString serverString, String string) {
        java.util.List list = TargetModule.findByContextRoot(serverString, string);
        for (TargetModule targetModule : list) {
            targetModule.remove();
        }
    }

    private static String getManagerDirName(ServerString serverString) {
        return TargetModule.getReadableName(serverString.getUrl());
    }

    private String getManagerDirName() {
        return TargetModule.getReadableName(this.getInstanceUrl());
    }

    public static TargetModule[] load(ServerString serverString, String string) {
        String string2 = TargetModule.getManagerDirName(serverString);
        String[] stringArray = serverString.getTargets(true);
        ArrayList<TargetModule> arrayList = new ArrayList<TargetModule>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = TargetModule.getReadableName(stringArray[i]);
            TargetModule targetModule = TargetModuleConverter.readTargetModule(string2, string3, string);
            if (targetModule == null) continue;
            arrayList.add(targetModule);
        }
        return arrayList.toArray(new TargetModule[arrayList.size()]);
    }

    public void save(String string) {
        TargetModuleConverter.writeTargetModule(this, this.getManagerDirName(), TargetModule.getReadableName(this.targetName), string);
    }

    public void remove() {
        String string = this.getManagerDirName();
        String string2 = TargetModule.getReadableName(this.targetName);
        String string3 = TargetModule.shortNameFromPath(this.getContentDirectory());
        TargetModuleConverter.remove(string, string2, string3);
    }

    public static String getReadableName(String string) {
        int n = string.hashCode();
        int n2 = 16;
        if (n2 > string.length()) {
            n2 = string.length();
        }
        StringBuffer stringBuffer = TargetModule.subStringBuffer(string, 0, n2);
        stringBuffer.append(String.valueOf(n));
        return stringBuffer.toString();
    }

    public static StringBuffer subStringBuffer(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (n2 < 0) {
            stringBuffer.append(string.substring(n));
        } else {
            stringBuffer.append(string.substring(n, n2));
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (Character.isLetterOrDigit(stringBuffer.charAt(i))) continue;
            stringBuffer.setCharAt(i, '_');
        }
        return stringBuffer;
    }

    public static String shortNameFromPath(String string) {
        int n = string.hashCode();
        int n2 = string.length() - 16;
        if (n2 < 0) {
            n2 = 0;
        }
        StringBuffer stringBuffer = TargetModule.subStringBuffer(string, n2, -1);
        stringBuffer.append(String.valueOf(n));
        return stringBuffer.toString();
    }

    public static class List
    implements Serializable {
        private static final long serialVersionUID = 69446832514L;
        private TargetModule[] targetModules;

        public List(TargetModule[] targetModuleArray) {
            this.targetModules = targetModuleArray;
        }

        public List(TargetModule targetModule) {
            this.targetModules = new TargetModule[]{targetModule};
        }

        public TargetModule[] getTargetModules() {
            return this.targetModules;
        }
    }
}

