/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;

public abstract class RepositoryCommand
extends BuildableCommand {
    protected List requests = new LinkedList();
    protected ClientServices clientServices;
    private boolean recursive = true;
    protected final List modules = new LinkedList();
    protected final List expandedModules = new LinkedList();

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void addModule(String module) {
        this.modules.add(module);
    }

    public void setModules(String[] modules) {
        this.clearModules();
        if (modules == null) {
            return;
        }
        for (int i = 0; i < modules.length; ++i) {
            String module = modules[i];
            this.modules.add(module);
        }
    }

    public String[] getModules() {
        String[] mods = new String[this.modules.size()];
        mods = this.modules.toArray(mods);
        return mods;
    }

    public void clearModules() {
        this.modules.clear();
    }

    protected final void addArgumentRequests() {
        if (this.expandedModules.size() == 0) {
            return;
        }
        Iterator it = this.expandedModules.iterator();
        while (it.hasNext()) {
            String module = (String)it.next();
            this.addRequest(new ArgumentRequest(module));
        }
    }

    public final void moduleExpanded(ModuleExpansionEvent e) {
        this.expandedModules.add(e.getModule());
    }

    public final void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.requests.clear();
        super.execute(client, em);
        this.clientServices = client;
        if (client.isFirstCommand()) {
            this.requests.add(new RootRequest(client.getRepository()));
        }
        Iterator it = this.modules.iterator();
        while (it.hasNext()) {
            String module = (String)it.next();
            this.requests.add(new ArgumentRequest(module));
        }
        this.expandedModules.clear();
        this.requests.add(new DirectoryRequest(".", client.getRepository()));
        this.requests.add(new ExpandModulesRequest());
        try {
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        this.requests.clear();
        this.postExpansionExecute(client, em);
    }

    protected abstract void postExpansionExecute(ClientServices var1, EventManager var2) throws CommandException, AuthenticationException;

    protected final void addRequest(Request request) {
        this.requests.add(request);
    }

    protected final void addRequestForWorkingDirectory(ClientServices clientServices) throws IOException {
        this.addRequest(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalDirectory())));
    }

    protected final void addArgumentRequest(boolean value, String argument) {
        if (!value) {
            return;
        }
        this.addRequest(new ArgumentRequest(argument));
    }

    protected final void appendModuleArguments(StringBuffer buffer) {
        if (this.expandedModules.size() == 0) {
            return;
        }
        Iterator it = this.expandedModules.iterator();
        buffer.append((String)it.next());
        while (it.hasNext()) {
            buffer.append(' ');
            buffer.append((String)it.next());
        }
    }
}

