/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class WebBuildScriptExtensionProvider
implements JaxWsBuildScriptExtensionProvider {
    static String JAX_WS_STYLESHEET_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jaxws-web.xsl";
    private Project project;

    public WebBuildScriptExtensionProvider(Project project) {
        this.project = project;
    }

    @Override
    public void addJaxWsExtension(AntBuildExtender antBuildExtender) throws IOException {
        TransformerUtils.transformClients(this.project.getProjectDirectory(), JAX_WS_STYLESHEET_RESOURCE, true);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
        if (extension == null) {
            extension = antBuildExtender.addExtension("jaxws", fileObject);
            int n = 0;
            int n2 = 0;
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                n = jaxWsModel.getClients().length;
                for (Service service : jaxWsModel.getServices()) {
                    if (service.getWsdlUrl() == null) continue;
                    ++n2;
                }
            }
            if (n > 0) {
                extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
            }
            if (n2 > 0) {
                extension.addDependency("-pre-pre-compile", "wsimport-service-generate");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJaxWsExtension(final AntBuildExtender antBuildExtender) throws IOException {
        FileLock fileLock;
        FileObject fileObject;
        AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
        if (extension != null) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    antBuildExtender.removeExtension("jaxws");
                }
            });
            ProjectManager.getDefault().saveProject(this.project);
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml")) != null && (fileLock = fileObject.lock()) != null) {
            try {
                fileObject.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    @Override
    public void handleJaxWsModelChanges(JaxWsModel jaxWsModel) throws IOException {
        AntBuildExtender antBuildExtender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (antBuildExtender != null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            JaxWsModel jaxWsModel2 = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel2 != null) {
                n = jaxWsModel2.getClients().length;
                n2 = jaxWsModel2.getServices().length;
                for (Service service : jaxWsModel2.getServices()) {
                    if (service.getWsdlUrl() == null) continue;
                    ++n3;
                }
            }
            if (n + n2 == 0) {
                this.removeJaxWsExtension(antBuildExtender);
            } else {
                this.changeJaxWsExtension(antBuildExtender, n2, n3, n);
            }
            ProjectManager.getDefault().saveProject(this.project);
        }
    }

    private void changeJaxWsExtension(AntBuildExtender antBuildExtender, int n, int n2, int n3) throws IOException {
        TransformerUtils.transformClients(this.project.getProjectDirectory(), JAX_WS_STYLESHEET_RESOURCE, true);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
        boolean bl = false;
        if (extension == null) {
            extension = antBuildExtender.addExtension("jaxws", fileObject);
            bl = true;
        }
        if (n3 > 0) {
            extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
        } else if (!bl) {
            extension.removeDependency("-pre-pre-compile", "wsimport-client-generate");
        }
        if (n2 > 0) {
            extension.addDependency("-pre-pre-compile", "wsimport-service-generate");
        } else if (!bl) {
            extension.removeDependency("-pre-pre-compile", "wsimport-service-generate");
        }
    }
}

