/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefinedName;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.Token;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenEncoder {
    private String parseString = new String();
    private int index;
    private Workbook wb;

    public void setWorkbook(Workbook workbook) {
        this.wb = workbook;
    }

    public byte[] getByte(Token token) throws IOException {
        ArrayList<Byte> arrayList = null;
        if (token.getTokenType() == 1) {
            arrayList = this.operatorEncoder(token);
        } else if (token.getTokenType() == 4 || token.getTokenType() == 3) {
            arrayList = this.functionEncoder(token);
        } else {
            switch (token.getTokenID()) {
                case 35: {
                    arrayList = this.nameDefinitionEncoder(token);
                    break;
                }
                case 58: {
                    arrayList = this.threeDCellRefEncoder(token);
                    break;
                }
                case 59: {
                    arrayList = this.threeDAreaRefEncoder(token);
                    break;
                }
                case 68: {
                    arrayList = this.cellRefEncoder(token);
                    break;
                }
                case 37: {
                    arrayList = this.areaRefEncoder(token);
                    break;
                }
                case 31: {
                    arrayList = this.numEncoder(token);
                    break;
                }
                case 23: {
                    arrayList = this.stringEncoder(token);
                    break;
                }
                default: {
                    Debug.log(2, "Encoder found unrecognized Token");
                }
            }
        }
        byte[] byArray = new byte[arrayList.size()];
        int n = 0;
        String string = new String();
        for (Byte by : arrayList) {
            string = string + by + " ";
            byArray[n] = by;
            ++n;
        }
        Debug.log(4, "Encoding Token " + token.getValue() + " as [" + string + "]");
        return byArray;
    }

    private ArrayList<Byte> operatorEncoder(Token token) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        arrayList.add(new Byte((byte)token.getTokenID()));
        return arrayList;
    }

    private ArrayList<Byte> stringEncoder(Token token) throws IOException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        arrayList.add(new Byte((byte)token.getTokenID()));
        arrayList.add(new Byte((byte)token.getValue().length()));
        arrayList.add(new Byte(1));
        byte[] byArray = token.getValue().getBytes("UTF-16LE");
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(new Byte(byArray[i]));
        }
        return arrayList;
    }

    private ArrayList<Byte> numEncoder(Token token) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        double d = Double.parseDouble(token.getValue());
        arrayList.add(new Byte((byte)token.getTokenID()));
        byte[] byArray = EndianConverter.writeDouble(d);
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(new Byte(byArray[i]));
        }
        return arrayList;
    }

    private int char2int(char c) {
        if (!Character.isLetter(c)) {
            return -1;
        }
        c = Character.toUpperCase(c);
        return c - 65;
    }

    private boolean isAlpha(char c) {
        return Character.isLetter(c);
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private int column() {
        char c = this.parseString.charAt(this.index);
        String string = new String();
        int n = 0;
        while (this.isAlpha(c)) {
            string = string + c;
            ++this.index;
            c = this.parseString.charAt(this.index);
        }
        if (string.length() == 1) {
            n = this.char2int(string.charAt(0));
        } else if (string.length() == 2) {
            n = this.char2int(string.charAt(0)) + 1;
            n = n * 26 + this.char2int(string.charAt(1));
        } else {
            Debug.log(2, "Invalid Column Reference " + string);
        }
        return n;
    }

    private int row() {
        char c = this.parseString.charAt(this.index);
        String string = new String();
        boolean bl = true;
        do {
            string = string + c;
            ++this.index;
            if (this.index >= this.parseString.length()) {
                bl = false;
                continue;
            }
            c = this.parseString.charAt(this.index);
        } while (this.isDigit(c) && bl);
        return Integer.parseInt(string) - 1;
    }

    private byte[] encodeCellCoordinates(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 49152;
        this.index = 0;
        this.parseString = string;
        Debug.log(4, "Encoding cell coordinates " + string);
        if (string.charAt(this.index) == '$') {
            n3 &= 0x8000;
            ++this.index;
        }
        n = this.column();
        if (string.charAt(this.index) == '$') {
            n3 &= 0x4000;
            ++this.index;
        }
        n2 = this.row();
        byte[] byArray = new byte[]{(byte)(n2 |= n3), (byte)(n2 >> 8), (byte)n};
        return byArray;
    }

    private ArrayList<Byte> nameDefinitionEncoder(Token token) {
        String string;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        String string2 = token.getValue();
        Debug.log(4, "NameDefinitionEncoder : " + string2);
        arrayList.add(new Byte((byte)token.getTokenID()));
        Iterator<DefinedName> iterator = this.wb.getDefinedNames();
        int n = 0;
        do {
            DefinedName definedName = iterator.next();
            string = definedName.getName();
            Debug.log(4, "Name pulled from DefinedName : " + string);
            ++n;
        } while (!string2.equalsIgnoreCase(string) && iterator.hasNext());
        arrayList.add(new Byte((byte)n));
        arrayList.add(new Byte(0));
        for (int i = 0; i < 12; ++i) {
            arrayList.add(new Byte(0));
        }
        return arrayList;
    }

    private ArrayList<Byte> cellRefEncoder(Token token) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        arrayList.add(new Byte((byte)token.getTokenID()));
        byte[] byArray = this.encodeCellCoordinates(token.getValue());
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(new Byte(byArray[i]));
        }
        return arrayList;
    }

    private short findSheetIndex(String string) {
        String string2;
        int n = 0;
        String string3 = string.startsWith("$") ? string.substring(1, string.length()) : string.substring(0, string.length());
        Debug.log(4, "Searching for Worksheet : " + string3);
        ArrayList<Object> arrayList = this.wb.getWorksheetNames();
        Iterator<Object> iterator = arrayList.iterator();
        do {
            string2 = (String)iterator.next();
            n = (short)(n + 1);
        } while (!string2.equalsIgnoreCase(string3) && iterator.hasNext());
        Debug.log(4, "Setting sheetindex to " + n);
        return (short)(n - 1);
    }

    private ArrayList<Byte> threeDCellRefEncoder(Token token) {
        short s;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        this.parseString = token.getValue();
        Debug.log(4, "Encoding 3D Cell reference " + token);
        arrayList.add(new Byte((byte)token.getTokenID()));
        arrayList.add(new Byte(-1));
        arrayList.add(new Byte(-1));
        for (int i = 0; i < 8; ++i) {
            arrayList.add(new Byte(0));
        }
        String string = this.parseString.substring(0, this.parseString.indexOf(46) + 1);
        if (string.indexOf(58) != -1) {
            string = this.parseString.substring(0, this.parseString.indexOf(58));
            s = this.findSheetIndex(string);
            string = this.parseString.substring(this.parseString.indexOf(58) + 1, this.parseString.length());
            short s2 = this.findSheetIndex(string);
            arrayList.add(new Byte((byte)s));
            arrayList.add(new Byte(0));
            arrayList.add(new Byte((byte)s2));
            arrayList.add(new Byte(0));
        } else {
            string = this.parseString.substring(0, this.parseString.indexOf(46));
            s = this.findSheetIndex(string);
            arrayList.add(new Byte((byte)s));
            arrayList.add(new Byte(0));
            arrayList.add(new Byte((byte)s));
            arrayList.add(new Byte(0));
        }
        String string2 = this.parseString.substring(this.parseString.indexOf(46) + 1, this.parseString.length());
        Debug.log(4, "Parsing : " + string2);
        byte[] byArray = this.encodeCellCoordinates(string2);
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(new Byte(byArray[i]));
        }
        return arrayList;
    }

    private ArrayList<Byte> threeDAreaRefEncoder(Token token) {
        Object object;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        this.parseString = token.getValue();
        Debug.log(4, "Encoding 3D Area reference " + token);
        arrayList.add(new Byte((byte)token.getTokenID()));
        arrayList.add(new Byte(-1));
        arrayList.add(new Byte(-1));
        for (int i = 0; i < 8; ++i) {
            arrayList.add(new Byte(0));
        }
        String string = this.parseString.substring(0, this.parseString.indexOf(58));
        String string2 = string.substring(this.parseString.indexOf(46) + 1, string.length());
        String string3 = string.substring(0, string.indexOf(46));
        short s = this.findSheetIndex(string3);
        String string4 = this.parseString.substring(this.parseString.indexOf(58) + 1, this.parseString.length());
        Debug.log(4, "param2: " + string4);
        String string5 = string4.substring(string4.indexOf(46) + 1, string4.length());
        Debug.log(4, "cellRef2: " + string5);
        if (string4.indexOf(46) == -1) {
            arrayList.add(new Byte((byte)s));
            arrayList.add(new Byte(0));
            arrayList.add(new Byte((byte)s));
            arrayList.add(new Byte(0));
        } else {
            object = string4.substring(0, string4.indexOf(46));
            short s2 = this.findSheetIndex((String)object);
            arrayList.add(new Byte((byte)s));
            arrayList.add(new Byte(0));
            arrayList.add(new Byte((byte)s2));
            arrayList.add(new Byte(0));
        }
        object = this.encodeCellCoordinates(string2);
        byte[] byArray = this.encodeCellCoordinates(string5);
        arrayList.add(new Byte((byte)object[0]));
        arrayList.add(new Byte((byte)object[1]));
        arrayList.add(new Byte(byArray[0]));
        arrayList.add(new Byte(byArray[1]));
        arrayList.add(new Byte((byte)object[2]));
        arrayList.add(new Byte(byArray[2]));
        return arrayList;
    }

    private ArrayList<Byte> areaRefEncoder(Token token) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        arrayList.add(new Byte((byte)token.getTokenID()));
        String string = token.getValue();
        String string2 = new String();
        String string3 = new String();
        if (string.indexOf(58) == -1) {
            Debug.log(2, "Invalid Cell Range, could not find :");
        } else {
            string2 = string.substring(0, string.indexOf(58));
            string3 = string.substring(string.indexOf(58) + 1, string.length());
        }
        byte[] byArray = this.encodeCellCoordinates(string2);
        byte[] byArray2 = this.encodeCellCoordinates(string3);
        arrayList.add(new Byte(byArray[0]));
        arrayList.add(new Byte(byArray[1]));
        arrayList.add(new Byte(byArray2[0]));
        arrayList.add(new Byte(byArray2[1]));
        arrayList.add(new Byte(byArray[2]));
        arrayList.add(new Byte(byArray2[2]));
        return arrayList;
    }

    private ArrayList<Byte> functionEncoder(Token token) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        int n = token.getTokenID();
        if (token.getTokenType() == 4) {
            arrayList.add(new Byte(66));
            arrayList.add(new Byte((byte)token.getNumArgs()));
        } else {
            arrayList.add(new Byte(65));
        }
        arrayList.add(new Byte((byte)n));
        arrayList.add(new Byte((byte)(n >> 8)));
        return arrayList;
    }
}

