/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;
import org.jfree.layouting.renderer.text.Glyph;
import org.pentaho.reporting.libraries.fonts.text.Spacing;

public class RenderableText
extends RenderNode {
    private Glyph[] glyphs;
    private int offset;
    private int length;
    private boolean ltr;
    private int script;
    private long minimumWidth;
    private long preferredWidth;
    private boolean forceLinebreak;
    private ExtendedBaselineInfo baselineInfo;

    protected RenderableText() {
    }

    public RenderableText(ExtendedBaselineInfo extendedBaselineInfo, Glyph[] glyphArray, int n, int n2, int n3, boolean bl) {
        this.initialize(glyphArray, n, n2, extendedBaselineInfo, n3, bl);
    }

    protected void initialize(Glyph[] glyphArray, int n, int n2, ExtendedBaselineInfo extendedBaselineInfo, int n3, boolean bl) {
        if (glyphArray == null) {
            throw new NullPointerException();
        }
        if (glyphArray.length < n + n2) {
            throw new IllegalArgumentException();
        }
        this.baselineInfo = extendedBaselineInfo;
        this.ltr = true;
        this.script = n3;
        this.glyphs = glyphArray;
        this.offset = n;
        this.length = n2;
        this.forceLinebreak = bl;
        this.setMajorAxis(0);
        this.setMinorAxis(1);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        int n4 = Math.min(glyphArray.length, n + n2);
        for (int i = n; i < n4; ++i) {
            Glyph glyph = glyphArray[i];
            Spacing spacing = glyph.getSpacing();
            int n5 = glyph.getKerning();
            int n6 = glyph.getWidth();
            if (glyph.getBreakWeight() <= 1) {
                l += (long)(n6 + spacing.getMinimum() - n5);
                l2 += (long)(n6 + spacing.getMinimum() - n5);
                l3 += (long)(n6 + spacing.getOptimum() - n5);
                l4 += (long)(n6 + spacing.getMaximum() - n5);
                continue;
            }
            l2 += (long)(n6 + spacing.getMinimum() - n5);
            l3 += (long)(n6 + spacing.getOptimum() - n5);
            l4 += (long)(n6 + spacing.getMaximum() - n5);
            l5 = Math.max(l5, l += (long)(n6 + spacing.getMinimum() - n5));
            l2 = 0L;
            if (glyph.getBreakWeight() != 4) continue;
            throw new IllegalStateException("A renderable text cannot and must not contain linebreaks.");
        }
        l5 = Math.max(l5, l);
        this.minimumWidth = Math.max(this.minimumWidth, l2);
        this.preferredWidth = Math.max(this.preferredWidth, l3);
        long l6 = Math.max(this.minimumWidth, l4);
        this.setMaximumBoxWidth(l6);
        this.setMinimumChunkWidth(l5);
        this.setIcmMetricsFinished(true);
    }

    public boolean isForceLinebreak() {
        return this.forceLinebreak;
    }

    public boolean isLtr() {
        return this.ltr;
    }

    public Glyph[] getGlyphs() {
        return this.glyphs;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getRawText() {
        Glyph[] glyphArray = this.getGlyphs();
        int n = this.getLength();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.getOffset(); i < n; ++i) {
            Glyph glyph = glyphArray[i];
            stringBuffer.append((char)(0xFFFF & glyph.getCodepoint()));
            int[] nArray = glyph.getExtraChars();
            for (int j = 0; j < nArray.length; ++j) {
                int n2 = nArray[j];
                stringBuffer.append(n2);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean isDiscardable() {
        if (this.forceLinebreak) {
            return false;
        }
        return this.glyphs.length == 0;
    }

    public ExtendedBaselineInfo getBaselineInfo() {
        return this.baselineInfo;
    }

    public int getScript() {
        return this.script;
    }

    public long getMinimumWidth() {
        return this.minimumWidth;
    }

    public long getPreferredWidth() {
        return this.preferredWidth;
    }
}

