/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho.layoutprocessor;

import com.sun.star.report.pentaho.layoutprocessor.OfficePageSectionLayoutController;
import com.sun.star.report.pentaho.layoutprocessor.OfficeRepeatingStructureLayoutController;
import com.sun.star.report.pentaho.layoutprocessor.OfficeTableTemplateLayoutController;
import com.sun.star.report.pentaho.layoutprocessor.VariablesCollection;
import com.sun.star.report.pentaho.model.OfficeReport;
import com.sun.star.report.pentaho.model.VariablesDeclarationSection;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.ElementLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.structure.Node;

public class OfficeReportLayoutController
extends ElementLayoutController
implements OfficeRepeatingStructureLayoutController {
    private static final int STATE_NOT_STARTED = 0;
    private static final int STATE_TEMPLATES = 1;
    private static final int STATE_PAGE_HEADER_DONE = 2;
    private static final int STATE_PAGE_FOOTER_DONE = 3;
    private static final int STATE_SPREADSHEET_PAGE_HEADER_DONE = 4;
    private static final int STATE_SPREADSHEET_PAGE_FOOTER_DONE = 5;
    private static final int STATE_COLUMN_HEADER_DONE = 6;
    private static final int STATE_COLUMN_FOOTER_DONE = 7;
    private static final int STATE_INITIAL_VARIABLES_DONE = 8;
    private static final int STATE_REPORT_HEADER_DONE = 9;
    private static final int STATE_REPORT_BODY_DONE = 10;
    private static final int STATE_REPORT_FOOTER_VARIABLES = 11;
    private static final int STATE_REPORT_FOOTER_DONE = 12;
    private int state;
    private VariablesCollection variablesCollection;

    public void initialize(Object object, FlowController flowController, LayoutController layoutController) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        super.initialize(object, flowController, layoutController);
        this.variablesCollection = new VariablesCollection("auto_report_");
    }

    protected LayoutController processContent(ReportTarget reportTarget) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        OfficeReport officeReport = (OfficeReport)this.getElement();
        switch (this.state) {
            case 0: {
                return this.delegateToTemplates(1);
            }
            case 1: {
                return this.delegateSection(officeReport.getPageHeader(), 2);
            }
            case 2: {
                return this.delegateSpreadsheetSection(officeReport.getPageHeader(), 4);
            }
            case 4: {
                return this.delegateSection(officeReport.getPageFooter(), 3);
            }
            case 3: {
                return this.delegateSection(officeReport.getColumnHeader(), 6);
            }
            case 6: {
                return this.delegateSection(officeReport.getColumnFooter(), 7);
            }
            case 7: {
                return this.delegateSection(new VariablesDeclarationSection(), 8);
            }
            case 8: {
                return this.delegateSection(officeReport.getReportHeader(), 9);
            }
            case 9: {
                return this.delegateSection(officeReport.getBodySection(), 10);
            }
            case 10: {
                return this.delegateSection(new VariablesDeclarationSection(), 11);
            }
            case 11: {
                return this.delegateSection(officeReport.getReportFooter(), 12);
            }
            case 12: {
                return this.delegateSpreadsheetSection(officeReport.getPageFooter(), 5);
            }
            case 5: {
                OfficeReportLayoutController officeReportLayoutController = (OfficeReportLayoutController)this.clone();
                officeReportLayoutController.setProcessingState(3);
                return officeReportLayoutController;
            }
        }
        throw new IllegalStateException("Invalid processing state encountered.");
    }

    private LayoutController delegateSpreadsheetSection(Node node, int n) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        OfficeReportLayoutController officeReportLayoutController = (OfficeReportLayoutController)this.clone();
        officeReportLayoutController.state = n;
        if (node == null) {
            return officeReportLayoutController;
        }
        OfficePageSectionLayoutController officePageSectionLayoutController = new OfficePageSectionLayoutController();
        officePageSectionLayoutController.initialize(node, this.getFlowController(), officeReportLayoutController);
        return officePageSectionLayoutController;
    }

    private LayoutController delegateToTemplates(int n) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        OfficeReportLayoutController officeReportLayoutController = (OfficeReportLayoutController)this.clone();
        officeReportLayoutController.state = n;
        OfficeTableTemplateLayoutController officeTableTemplateLayoutController = new OfficeTableTemplateLayoutController();
        officeTableTemplateLayoutController.initialize(this.getElement(), this.getFlowController(), officeReportLayoutController);
        return officeTableTemplateLayoutController;
    }

    private LayoutController delegateSection(Node node, int n) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        OfficeReportLayoutController officeReportLayoutController = (OfficeReportLayoutController)this.clone();
        officeReportLayoutController.state = n;
        if (node == null) {
            return officeReportLayoutController;
        }
        FlowController flowController = this.getFlowController();
        ReportContext reportContext = flowController.getReportContext();
        LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
        return layoutControllerFactory.create(flowController, node, officeReportLayoutController);
    }

    public LayoutController join(FlowController flowController) {
        OfficeReportLayoutController officeReportLayoutController = (OfficeReportLayoutController)this.clone();
        officeReportLayoutController.setFlowController(flowController);
        return officeReportLayoutController;
    }

    public boolean isNormalFlowProcessing() {
        return this.state != 2 && this.state != 3;
    }

    public VariablesCollection getVariablesCollection() {
        return this.variablesCollection;
    }
}

