/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.uno.Any;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.ui.event.DataAware;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAwareFields {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public static DataAware.Value getFieldValueFor(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            Class<?> clazz = field.getType();
            Class<?> clazz2 = object2.getClass();
            if (clazz.equals(Boolean.TYPE)) {
                return new BooleanFieldValue(field, clazz2);
            }
            if (clazz.equals(Integer.TYPE)) {
                return new IntFieldValue(field, clazz2);
            }
            if (clazz.equals(Double.TYPE)) {
                return new DoubleFieldValue(field, clazz2);
            }
            if (clazz.equals(String.class) && clazz2.equals(Integer.class)) {
                return new ConvertedStringValue(field, clazz2);
            }
            return new SimpleFieldValue(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            return null;
        }
    }

    private static double toDouble(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        if (object instanceof short[]) {
            return ((short[])object).length == 0 ? 0.0 : (double)((short[])object)[0];
        }
        throw new IllegalArgumentException("Can't convert value to double." + object.getClass().getName());
    }

    private static boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof String) {
            return object.equals(TRUE);
        }
        if (object instanceof short[]) {
            return ((short[])object).length != 0 && ((short[])object)[0] != 0;
        }
        throw new IllegalArgumentException("Can't convert value to boolean." + object.getClass().getName());
    }

    private static int toInt(boolean bl) {
        return bl ? 1 : 0;
    }

    private static short[] toShortArray(double d) {
        return new short[]{(short)d};
    }

    private static Number toNumber(double d, Class<?> clazz) {
        if (clazz.equals(Integer.class)) {
            return new Integer((int)d);
        }
        if (clazz.equals(Short.class)) {
            return new Short((short)d);
        }
        if (clazz.equals(Double.class)) {
            return new Double(d);
        }
        throw new IllegalArgumentException("Cannot convert to the given Number type.");
    }

    private static class SimpleFieldValue
    extends FieldValue {
        public SimpleFieldValue(Field field) {
            super(field);
        }

        public Object get(Object object) {
            try {
                if (object == null) {
                    if (this.field.getType().equals(String.class)) {
                        return PropertyNames.EMPTY_STRING;
                    }
                    if (this.field.getType().equals(Short.class)) {
                        return new Short(0);
                    }
                    if (this.field.getType().equals(Integer.class)) {
                        return 0;
                    }
                    if (this.field.getType().equals(short[].class)) {
                        return new short[0];
                    }
                    return null;
                }
                return this.field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        public void set(Object object, Object object2) {
            try {
                this.field.set(object2, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConvertedStringValue
    extends FieldValue {
        private Class<?> convertTo;

        public ConvertedStringValue(Field field, Class<?> clazz) {
            super(field);
            this.convertTo = clazz;
        }

        @Override
        public Object get(Object object) {
            try {
                String string = (String)this.field.get(object);
                if (this.convertTo.equals(Boolean.class)) {
                    return string != null && !string.equals(PropertyNames.EMPTY_STRING) && string.equals(DataAwareFields.TRUE) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (this.convertTo.equals(Integer.class)) {
                    if (string == null || string.equals(PropertyNames.EMPTY_STRING)) {
                        return Any.VOID;
                    }
                    return new Integer(string);
                }
                if (this.convertTo.equals(Double.class)) {
                    if (string == null || string.equals(PropertyNames.EMPTY_STRING)) {
                        return Any.VOID;
                    }
                    return new Double(string);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        @Override
        public void set(Object object, Object object2) {
            try {
                this.field.set(object2, object == null || object.equals(Any.VOID) ? PropertyNames.EMPTY_STRING : object.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleFieldValue
    extends FieldValue {
        private Class<?> convertTo;

        public DoubleFieldValue(Field field, Class<?> clazz) {
            super(field);
            this.convertTo = clazz;
        }

        @Override
        public Object get(Object object) {
            try {
                double d = this.field.getDouble(object);
                if (this.convertTo.equals(Boolean.class)) {
                    return d != 0.0 ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Number.class.isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(d, this.convertTo);
                }
                if (this.convertTo.equals(String.class)) {
                    return String.valueOf(d);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(d);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        @Override
        public void set(Object object, Object object2) {
            try {
                this.field.setDouble(object2, DataAwareFields.toDouble(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntFieldValue
    extends FieldValue {
        private Class<?> convertTo;

        public IntFieldValue(Field field, Class<?> clazz) {
            super(field);
            this.convertTo = clazz;
        }

        @Override
        public Object get(Object object) {
            try {
                int n = this.field.getInt(object);
                if (this.convertTo.equals(Boolean.class)) {
                    return n != 0 ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Number.class.isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(n, this.convertTo);
                }
                if (this.convertTo.equals(String.class)) {
                    return String.valueOf(n);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(n);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        @Override
        public void set(Object object, Object object2) {
            try {
                this.field.setInt(object2, (int)DataAwareFields.toDouble(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanFieldValue
    extends FieldValue {
        private Class<?> convertTo;

        public BooleanFieldValue(Field field, Class<?> clazz) {
            super(field);
            this.convertTo = clazz;
        }

        @Override
        public Object get(Object object) {
            try {
                boolean bl = this.field.getBoolean(object);
                if (this.convertTo.equals(Boolean.class)) {
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Number.class.isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(bl ? 1.0 : 0.0, this.convertTo);
                }
                if (this.convertTo.equals(String.class)) {
                    return String.valueOf(bl);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(DataAwareFields.toInt(bl));
                }
                throw new IllegalArgumentException("Cannot convert boolean value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        @Override
        public void set(Object object, Object object2) {
            try {
                this.field.setBoolean(object2, DataAwareFields.toBoolean(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class FieldValue
    implements DataAware.Value {
        Field field;

        public FieldValue(Field field) {
            this.field = field;
        }

        @Override
        public boolean isAssignable(Class<?> clazz) {
            return this.field.getDeclaringClass().isAssignableFrom(clazz);
        }
    }
}

