/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XSingleSelectQueryAnalyzer;
import com.sun.star.sdb.XSingleSelectQueryComposer;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandName;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import java.util.ArrayList;

public class SQLQueryComposer {
    public XColumnsSupplier xColSuppl;
    QueryMetaData CurDBMetaData;
    public XSingleSelectQueryAnalyzer m_xQueryAnalyzer;
    ArrayList<CommandName> composedCommandNames = new ArrayList(1);
    private XSingleSelectQueryComposer m_queryComposer;
    XMultiServiceFactory xMSF;
    boolean bincludeGrouping = true;

    public SQLQueryComposer(QueryMetaData queryMetaData) {
        try {
            this.setDBMetaData(queryMetaData);
            this.xMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.CurDBMetaData.DBConnection);
            Object object = this.xMSF.createInstance("com.sun.star.sdb.SingleSelectQueryComposer");
            this.m_xQueryAnalyzer = (XSingleSelectQueryAnalyzer)UnoRuntime.queryInterface(XSingleSelectQueryAnalyzer.class, (Object)object);
            this.m_queryComposer = (XSingleSelectQueryComposer)UnoRuntime.queryInterface(XSingleSelectQueryComposer.class, (Object)this.m_xQueryAnalyzer);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private boolean addtoSelectClause(String string) throws SQLException {
        return !this.bincludeGrouping || !this.CurDBMetaData.xDBMetaData.supportsGroupByUnrelated() || this.CurDBMetaData.GroupFieldNames == null || JavaTools.FieldInList(this.CurDBMetaData.GroupFieldNames, string) <= -1;
    }

    public String getSelectClause(boolean bl) throws SQLException {
        String string;
        String string2 = string = "SELECT ";
        for (int i = 0; i < this.CurDBMetaData.FieldColumns.length; ++i) {
            if (!this.addtoSelectClause(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName())) continue;
            int n = this.CurDBMetaData.getAggregateIndex(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
            if (n > -1) {
                string2 = string2 + this.CurDBMetaData.AggregateFieldNames[n][1] + "(" + this.getComposedAliasFieldName(this.CurDBMetaData.AggregateFieldNames[n][0]) + ")";
                if (bl) {
                    string2 = string2 + this.getAliasFieldNameClause(this.CurDBMetaData.AggregateFieldNames[n][0]);
                }
            } else {
                string2 = string2 + this.getComposedAliasFieldName(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
                if (bl) {
                    string2 = string2 + this.getAliasFieldNameClause(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
                }
            }
            string2 = string2 + ", ";
        }
        string2 = string2.equals(string) ? string2.substring(0, string2.length() - 1) : string2.substring(0, string2.length() - 2);
        return string2;
    }

    public String getAliasFieldNameClause(String string) {
        String string2 = this.CurDBMetaData.getFieldTitle(string);
        if (!string2.equals(string)) {
            return " AS " + CommandName.quoteName(string2, this.CurDBMetaData.getIdentifierQuote());
        }
        return "";
    }

    public void appendFilterConditions() throws SQLException {
        try {
            for (int i = 0; i < this.CurDBMetaData.getFilterConditions().length; ++i) {
                this.m_queryComposer.setStructuredFilter(this.CurDBMetaData.getFilterConditions());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void prependSortingCriteria() throws SQLException {
        this.prependSortingCriteria(false);
    }

    public void prependSortingCriteria(boolean bl) throws SQLException {
        int n;
        XIndexAccess xIndexAccess = this.m_xQueryAnalyzer.getOrderColumns();
        this.m_queryComposer.setOrder("");
        for (n = 0; n < this.CurDBMetaData.getSortFieldNames().length; ++n) {
            this.appendSortingCriterion(n, bl);
        }
        for (n = 0; n < xIndexAccess.getCount(); ++n) {
            try {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xIndexAccess.getByIndex(n));
                String string = (String)xPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME);
                if (JavaTools.FieldInTable(this.CurDBMetaData.getSortFieldNames(), string) != -1) continue;
                boolean bl2 = AnyConverter.toBoolean((Object)xPropertySet.getPropertyValue("IsAscending"));
                this.m_queryComposer.appendOrderByColumn(xPropertySet, bl2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private void appendSortingCriterion(int n, boolean bl) throws SQLException {
        String string = this.CurDBMetaData.getSortFieldNames()[n][0];
        XPropertySet xPropertySet = this.CurDBMetaData.getColumnObjectByFieldName(string, bl);
        String string2 = this.CurDBMetaData.getSortFieldNames()[n][1];
        boolean bl2 = string2.equals("ASC");
        this.m_queryComposer.appendOrderByColumn(xPropertySet, bl2);
    }

    public void appendSortingcriteria(boolean bl) throws SQLException {
        String string = "";
        this.m_queryComposer.setOrder("");
        for (int i = 0; i < this.CurDBMetaData.getSortFieldNames().length; ++i) {
            String string2 = this.CurDBMetaData.getSortFieldNames()[i][0];
            int n = this.CurDBMetaData.getAggregateIndex(string2);
            if (n > -1) {
                string = this.m_xQueryAnalyzer.getOrder();
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + this.CurDBMetaData.AggregateFieldNames[n][1] + "(" + this.getComposedAliasFieldName(this.CurDBMetaData.AggregateFieldNames[n][0]) + ")";
                string = string + " " + this.CurDBMetaData.getSortFieldNames()[i][1];
                this.m_queryComposer.setOrder(string);
            } else {
                this.appendSortingCriterion(i, bl);
            }
            string = this.m_xQueryAnalyzer.getOrder();
        }
        string = this.m_queryComposer.getOrder();
    }

    public void appendGroupByColumns(boolean bl) throws SQLException {
        for (int i = 0; i < this.CurDBMetaData.GroupFieldNames.length; ++i) {
            XPropertySet xPropertySet = this.CurDBMetaData.getColumnObjectByFieldName(this.CurDBMetaData.GroupFieldNames[i], bl);
            this.m_queryComposer.appendGroupByColumn(xPropertySet);
        }
    }

    public void setDBMetaData(QueryMetaData queryMetaData) {
        this.CurDBMetaData = queryMetaData;
        this.updateComposedCommandNames();
    }

    private PropertyValue[][] replaceConditionsByAlias(PropertyValue[][] propertyValueArray) {
        XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.m_xQueryAnalyzer);
        XNameAccess xNameAccess = xColumnsSupplier.getColumns();
        for (int i = 0; i < propertyValueArray.length; ++i) {
            for (int j = 0; j < propertyValueArray[i].length; ++j) {
                String string = this.getComposedAliasFieldName(propertyValueArray[i][j].Name);
                if (!xNameAccess.hasByName(string)) continue;
                propertyValueArray[i][j].Name = string;
            }
        }
        return propertyValueArray;
    }

    public String getQuery() {
        return this.m_xQueryAnalyzer.getQuery();
    }

    private void updateComposedCommandNames() {
        this.composedCommandNames.clear();
        String[] stringArray = this.CurDBMetaData.getIncludedCommandNames();
        for (int i = 0; i < stringArray.length; ++i) {
            CommandName commandName = new CommandName(this.CurDBMetaData, stringArray[i]);
            commandName.setAliasName(this.getuniqueAliasName(commandName.getTableName()));
            this.composedCommandNames.add(commandName);
        }
    }

    public StringBuilder getFromClause() {
        StringBuilder stringBuilder = new StringBuilder("FROM");
        String[] stringArray = this.CurDBMetaData.getIncludedCommandNames();
        for (int i = 0; i < stringArray.length; ++i) {
            CommandName commandName = this.getComposedCommandByDisplayName(stringArray[i]);
            stringBuilder.append(" ").append(commandName.getComposedName()).append(" ").append(this.quoteName(commandName.getAliasName()));
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }

    public boolean setQueryCommand(XWindow xWindow, boolean bl, boolean bl2) {
        return this.setQueryCommand(xWindow, bl, bl2, true);
    }

    public boolean setQueryCommand(XWindow xWindow, boolean bl, boolean bl2, boolean bl3) {
        return this.setQueryCommand(xWindow, bl, bl2, bl3, false);
    }

    public boolean setQueryCommand(XWindow xWindow, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        try {
            this.bincludeGrouping = bl;
            if (bl3) {
                StringBuilder stringBuilder = this.getFromClause();
                String string = this.getSelectClause(bl2);
                StringBuilder stringBuilder2 = new StringBuilder(string).append(" ").append((CharSequence)stringBuilder);
                this.m_xQueryAnalyzer.setQuery(stringBuilder2.toString());
                if (this.CurDBMetaData.getFilterConditions() != null && this.CurDBMetaData.getFilterConditions().length > 0) {
                    this.CurDBMetaData.setFilterConditions(this.replaceConditionsByAlias(this.CurDBMetaData.getFilterConditions()));
                    this.m_queryComposer.setStructuredFilter(this.CurDBMetaData.getFilterConditions());
                }
            }
            if (bl) {
                this.appendGroupByColumns(bl2);
                if (this.CurDBMetaData.GroupByFilterConditions.length > 0) {
                    this.m_queryComposer.setStructuredHavingClause(this.CurDBMetaData.GroupByFilterConditions);
                }
            }
            if (bl4) {
                this.prependSortingCriteria(bl2);
            } else {
                this.appendSortingcriteria(bl2);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.displaySQLErrorDialog(exception, xWindow);
            return false;
        }
    }

    private String getComposedAliasFieldName(String string) {
        FieldColumn fieldColumn = this.CurDBMetaData.getFieldColumnByDisplayName(string);
        String string2 = fieldColumn.getCommandName();
        String string3 = fieldColumn.getFieldName();
        CommandName commandName = this.getComposedCommandByDisplayName(string2);
        if (commandName == null) {
            if (string2.length() > 0) {
                return this.quoteName(string2) + "." + this.quoteName(string3);
            }
            return this.quoteName(string3);
        }
        String string4 = commandName.getAliasName();
        return this.quoteName(string4) + "." + this.quoteName(string3);
    }

    private CommandName getComposedCommandByAliasName(String string) {
        if (this.composedCommandNames != null) {
            for (CommandName commandName : this.composedCommandNames) {
                if (!commandName.getAliasName().equals(string)) continue;
                return commandName;
            }
        }
        return null;
    }

    public CommandName getComposedCommandByDisplayName(String string) {
        if (this.composedCommandNames != null) {
            for (CommandName commandName : this.composedCommandNames) {
                if (!commandName.getDisplayName().equals(string)) continue;
                return commandName;
            }
        }
        return null;
    }

    public String getuniqueAliasName(String string) {
        int n = 0;
        String string2 = "";
        boolean bl = true;
        String string3 = string;
        while (bl) {
            boolean bl2 = bl = this.getComposedCommandByAliasName(string3) != null;
            if (bl) {
                string3 = string + "_" + String.valueOf(++n);
                continue;
            }
            string2 = string3;
        }
        return string2;
    }

    private String quoteName(String string) {
        return CommandName.quoteName(string, this.CurDBMetaData.getIdentifierQuote());
    }

    public void displaySQLErrorDialog(Exception exception, XWindow xWindow) {
        try {
            Object object = this.CurDBMetaData.xMSF.createInstance("com.sun.star.sdb.ErrorMessageDialog");
            XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)object);
            XExecutableDialog xExecutableDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)object);
            Object[] objectArray = new PropertyValue[]{Properties.createProperty(PropertyNames.PROPERTY_TITLE, Configuration.getProductName(this.CurDBMetaData.xMSF) + " Base"), Properties.createProperty("ParentWindow", xWindow), Properties.createProperty("SQLException", (Object)exception)};
            xInitialization.initialize(objectArray);
            xExecutableDialog.execute();
        }
        catch (Exception exception2) {
            exception2.printStackTrace(System.err);
        }
    }

    public PropertyValue[][] getNormalizedStructuredFilter() {
        PropertyValue[][] propertyValueArray = this.m_queryComposer.getStructuredFilter();
        for (int i = 0; i < propertyValueArray.length; ++i) {
            for (int j = 0; j < propertyValueArray[i].length; ++j) {
                if (!(propertyValueArray[i][j].Value instanceof String)) continue;
                StringBuffer stringBuffer = new StringBuffer((String)propertyValueArray[i][j].Value);
                switch (propertyValueArray[i][j].Handle) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        stringBuffer.delete(0, 2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        stringBuffer.delete(0, 1);
                        break;
                    }
                    case 8: {
                        stringBuffer.delete(0, 8);
                        break;
                    }
                    case 7: {
                        stringBuffer.delete(0, 4);
                        break;
                    }
                    case 9: {
                        stringBuffer.delete(0, 7);
                        break;
                    }
                    case 10: {
                        stringBuffer.delete(0, 11);
                    }
                }
                propertyValueArray[i][j].Value = stringBuffer.toString().trim();
            }
        }
        return propertyValueArray;
    }

    public XSingleSelectQueryComposer getQueryComposer() {
        return this.m_queryComposer;
    }
}

