/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.ui.dialogs.XFilePicker;
import com.sun.star.ui.dialogs.XFilePickerControlAccess;
import com.sun.star.ui.dialogs.XFilterManager;
import com.sun.star.ui.dialogs.XFolderPicker2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XStringSubstitution;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Resource;

public class SystemDialog {
    Object systemDialog;
    XFilePicker xFilePicker;
    XFolderPicker2 xFolderPicker;
    XFilterManager xFilterManager;
    XInitialization xInitialize;
    XExecutableDialog xExecutable;
    XComponent xComponent;
    XFilePickerControlAccess xFilePickerControlAccess;
    XMultiServiceFactory xMSF;
    public XStringSubstitution xStringSubstitution;
    public String sStorePath;

    public SystemDialog(XMultiServiceFactory xMultiServiceFactory, String string, short s) {
        try {
            this.xMSF = xMultiServiceFactory;
            this.systemDialog = xMultiServiceFactory.createInstance(string);
            this.xFilePicker = (XFilePicker)UnoRuntime.queryInterface(XFilePicker.class, (Object)this.systemDialog);
            this.xFolderPicker = (XFolderPicker2)UnoRuntime.queryInterface(XFolderPicker2.class, (Object)this.systemDialog);
            this.xFilterManager = (XFilterManager)UnoRuntime.queryInterface(XFilterManager.class, (Object)this.systemDialog);
            this.xInitialize = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)this.systemDialog);
            this.xExecutable = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)this.systemDialog);
            this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.systemDialog);
            this.xFilePickerControlAccess = (XFilePickerControlAccess)UnoRuntime.queryInterface(XFilePickerControlAccess.class, (Object)this.systemDialog);
            this.xStringSubstitution = SystemDialog.createStringSubstitution(xMultiServiceFactory);
            Object[] objectArray = new Short[]{new Short(s)};
            if (this.xInitialize != null) {
                this.xInitialize.initialize(objectArray);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    public static SystemDialog createStoreDialog(XMultiServiceFactory xMultiServiceFactory) {
        return new SystemDialog(xMultiServiceFactory, "com.sun.star.ui.dialogs.FilePicker", 10);
    }

    public static SystemDialog createOpenDialog(XMultiServiceFactory xMultiServiceFactory) {
        return new SystemDialog(xMultiServiceFactory, "com.sun.star.ui.dialogs.FilePicker", 0);
    }

    public static SystemDialog createFolderDialog(XMultiServiceFactory xMultiServiceFactory) {
        return new SystemDialog(xMultiServiceFactory, "com.sun.star.ui.dialogs.FolderPicker", 0);
    }

    public static SystemDialog createOfficeFolderDialog(XMultiServiceFactory xMultiServiceFactory) {
        return new SystemDialog(xMultiServiceFactory, "com.sun.star.ui.dialogs.OfficeFolderPicker", 0);
    }

    private String subst(String string) {
        try {
            return this.xStringSubstitution.substituteVariables(string, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public String callStoreDialog(String string, String string2, String string3) {
        String string4 = string2.substring(string2.length() - 3, string2.length());
        this.addFilterToDialog(string4, string3, true);
        return this.callStoreDialog(string, string2);
    }

    public String callStoreDialog(String string, String string2) {
        this.sStorePath = null;
        try {
            this.xFilePickerControlAccess.setValue((short)100, (short)0, (Object)Boolean.TRUE);
            this.xFilePicker.setDefaultName(string2);
            this.xFilePicker.setDisplayDirectory(this.subst(string));
            if (this.execute(this.xExecutable)) {
                String[] stringArray = this.xFilePicker.getFiles();
                this.sStorePath = stringArray[0];
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return this.sStorePath;
    }

    public String callFolderDialog(String string, String string2, String string3) {
        try {
            this.xFolderPicker.setDisplayDirectory(this.subst(string3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw new java.lang.IllegalArgumentException(illegalArgumentException.getMessage());
        }
        this.xFolderPicker.setTitle(string);
        this.xFolderPicker.setDescription(string2);
        if (this.execute((XExecutableDialog)this.xFolderPicker)) {
            return this.xFolderPicker.getDirectory();
        }
        return null;
    }

    private boolean execute(XExecutableDialog xExecutableDialog) {
        return xExecutableDialog.execute() == 1;
    }

    public String[] callOpenDialog(boolean bl, String string) {
        try {
            this.xFilePicker.setMultiSelectionMode(bl);
            this.xFilePicker.setDisplayDirectory(this.subst(string));
            if (this.execute(this.xExecutable)) {
                return this.xFilePicker.getFiles();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return null;
    }

    public void addFilterToDialog(String string, String string2, boolean bl) {
        try {
            String string3 = this.getFilterUIName(string2);
            String string4 = "*." + string;
            this.addFilter(string3, string4, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void addFilter(String string, String string2, boolean bl) {
        try {
            this.xFilterManager.appendFilter(string, string2);
            if (bl) {
                this.xFilterManager.setCurrentFilter(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getFilterUIName(String string) {
        String string2 = Configuration.getProductName(this.xMSF);
        String[][] stringArrayArray = new String[][]{{this.getFilterUIName_(string)}};
        stringArrayArray[0][0] = JavaTools.replaceSubString(stringArrayArray[0][0], string2, "%productname%");
        return stringArrayArray[0][0];
    }

    private String getFilterUIName_(String string) {
        try {
            Object object = this.xMSF.createInstance("com.sun.star.document.FilterFactory");
            Object object2 = Helper.getUnoObjectbyName(object, string);
            Object object3 = AnyConverter.toArray((Object)object2);
            for (PropertyValue propertyValue : (PropertyValue[])object3) {
                if (propertyValue == null || !propertyValue.Name.equals("UIName")) continue;
                return AnyConverter.toString((Object)propertyValue.Value);
            }
            throw new NullPointerException("UIName property not found for Filter " + string);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static int showErrorBox(XMultiServiceFactory xMultiServiceFactory, String string, String string2, int n, String string3, String string4) {
        String string5 = Configuration.getProductName(xMultiServiceFactory);
        Resource resource = new Resource(xMultiServiceFactory, string, string2);
        String string6 = resource.getResText(n);
        string6 = JavaTools.replaceSubString(string6, string5, "%PRODUCTNAME");
        string6 = JavaTools.replaceSubString(string6, String.valueOf('\r'), "<BR>");
        string6 = JavaTools.replaceSubString(string6, string4, string3);
        return SystemDialog.showMessageBox(xMultiServiceFactory, "ErrorBox", 0x400000, string6);
    }

    public static int showErrorBox(XMultiServiceFactory xMultiServiceFactory, String string, String string2, int n) {
        String string3 = Configuration.getProductName(xMultiServiceFactory);
        Resource resource = new Resource(xMultiServiceFactory, string, string2);
        String string4 = resource.getResText(n);
        string4 = JavaTools.replaceSubString(string4, string3, "%PRODUCTNAME");
        string4 = JavaTools.replaceSubString(string4, String.valueOf('\r'), "<BR>");
        return SystemDialog.showMessageBox(xMultiServiceFactory, "ErrorBox", 0x400000, string4);
    }

    public static int showMessageBox(XMultiServiceFactory xMultiServiceFactory, String string, int n, String string2) {
        int n2 = 0;
        try {
            if (string2 == null) {
                return 0;
            }
            XFrame xFrame = Desktop.getActiveFrame(xMultiServiceFactory);
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xFrame.getComponentWindow());
            return SystemDialog.showMessageBox(xMultiServiceFactory, xWindowPeer, string, n, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return n2;
        }
    }

    public static int showMessageBox(XMultiServiceFactory xMultiServiceFactory, XWindowPeer xWindowPeer, String string, int n, String string2) {
        if (xWindowPeer == null) {
            return SystemDialog.showMessageBox(xMultiServiceFactory, string, n, string2);
        }
        int n2 = 0;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
            XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)xInterface);
            WindowDescriptor windowDescriptor = new WindowDescriptor();
            windowDescriptor.WindowServiceName = string;
            windowDescriptor.Parent = xWindowPeer;
            windowDescriptor.Type = WindowClass.MODALTOP;
            windowDescriptor.WindowAttributes = n;
            XWindowPeer xWindowPeer2 = xToolkit.createWindow(windowDescriptor);
            XMessageBox xMessageBox = (XMessageBox)UnoRuntime.queryInterface(XMessageBox.class, (Object)xWindowPeer2);
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xMessageBox);
            xMessageBox.setMessageText(string2);
            n2 = xMessageBox.execute();
            xComponent.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return n2;
    }

    public static XStringSubstitution createStringSubstitution(XMultiServiceFactory xMultiServiceFactory) {
        Object object = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.util.PathSubstitution");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        if (object != null) {
            return (XStringSubstitution)UnoRuntime.queryInterface(XStringSubstitution.class, (Object)object);
        }
        return null;
    }
}

