/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.pocketword;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.ParaStyle;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.Paragraph;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.ParagraphTextSegment;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.PocketWordDocument;
import org.openoffice.xmerge.util.OfficeUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentDeserializerImpl
implements DocumentDeserializer,
OfficeConstants {
    private PocketWordDocument pswDoc = null;
    private SxwDocument sxwDoc = null;
    private String docName;
    private StyleCatalog styleCat = null;

    public DocumentDeserializerImpl(ConvertData convertData) {
        Iterator<Object> iterator = convertData.getDocumentEnumeration();
        while (iterator.hasNext()) {
            this.pswDoc = (PocketWordDocument)iterator.next();
        }
        this.docName = this.pswDoc.getName();
    }

    @Override
    public Document deserialize() throws IOException, ConvertException {
        Iterator<Paragraph> iterator = this.pswDoc.getParagraphEnumeration();
        this.sxwDoc = new SxwDocument(this.docName);
        this.sxwDoc.initContentDOM();
        this.styleCat = new StyleCatalog(5);
        try {
            this.buildDocument(iterator);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ConvertException("Error building OpenOffice Writer DOM: " + exception.toString());
        }
        return this.sxwDoc;
    }

    private void buildDocument(Iterator<Paragraph> iterator) throws IOException {
        Object object;
        org.w3c.dom.Document document = this.sxwDoc.getContentDOM();
        Node node = document.getElementsByTagName("office:body").item(0);
        Node node2 = document.getElementsByTagName("office:automatic-styles").item(0);
        if (node2 == null) {
            node2 = document.createElement("office:automatic-styles");
            document.insertBefore(node2, node);
        }
        int n = 1;
        int n2 = 1;
        Element element = null;
        while (iterator.hasNext()) {
            int n3;
            Object object2;
            Object object3;
            Object object4;
            object = iterator.next();
            Element element2 = document.createElement("text:p");
            ParaStyle paraStyle = ((Paragraph)object).makeStyle();
            if (paraStyle == null) {
                element2.setAttribute("text:style-name", "Standard");
            } else {
                paraStyle.setName(new String("PS" + n++));
                element2.setAttribute("text:style-name", paraStyle.getName());
                this.styleCat.add(paraStyle);
            }
            Iterator<ParagraphTextSegment> iterator2 = ((Paragraph)object).getSegmentsEnumerator();
            ArrayList<Element> arrayList = new ArrayList<Element>(0);
            do {
                object4 = iterator2.next();
                object3 = document.createElement("text:span");
                object2 = ((ParagraphTextSegment)object4).getStyle();
                if (object2 != null) {
                    ((Style)object2).setName(new String("TS" + n2++));
                    object3.setAttribute("text:style-name", ((Style)object2).getName());
                    this.styleCat.add((Style)object2);
                } else {
                    object3.setAttribute("text:style-name", "Standard");
                }
                if (((ParagraphTextSegment)object4).getText() != null && !((ParagraphTextSegment)object4).getText().equals("")) {
                    Node[] nodeArray = OfficeUtil.parseText(((ParagraphTextSegment)object4).getText(), document);
                    for (n3 = 0; n3 < nodeArray.length; ++n3) {
                        object3.appendChild(nodeArray[n3]);
                    }
                }
                arrayList.add((Element)object3);
            } while (iterator2.hasNext());
            object4 = (Element)arrayList.get(0);
            object3 = object4.getAttribute("text:style-name");
            if (((String)object3).equals("Standard")) {
                object2 = object4.getChildNodes();
                int n4 = object2.getLength();
                for (n3 = 0; n3 < n4; ++n3) {
                    element2.appendChild(object2.item(0));
                }
            } else {
                element2.appendChild((Node)object4);
            }
            for (int i = 1; i < arrayList.size(); ++i) {
                element2.appendChild((Node)arrayList.get(i));
            }
            if (((Paragraph)object).isBulleted()) {
                if (element == null) {
                    element = document.createElement("text:unordered-list");
                }
                Element element3 = document.createElement("text:list-item");
                element3.appendChild(element2);
                element.appendChild(element3);
                continue;
            }
            if (element != null) {
                node.appendChild(element);
                element = null;
            }
            node.appendChild(element2);
        }
        object = this.styleCat.writeNode(document, "dummy").getChildNodes();
        int n5 = object.getLength();
        for (int i = 0; i < n5; ++i) {
            node2.appendChild(object.item(0));
        }
    }
}

