/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.ArrayList;
import java.util.List;
import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.Resources;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeIterator
implements Iterator {
    private List<Node> nodeList = null;
    private int currentPosition = 0;
    private Node root;
    private ConverterCapabilities cc_ = null;

    public NodeIterator(ConverterCapabilities converterCapabilities, Node node) {
        this.cc_ = converterCapabilities;
        this.nodeList = new ArrayList<Node>();
        this.root = node;
        this.markTree(node);
    }

    public Object next() {
        if (this.currentPosition < this.nodeList.size() - 1) {
            ++this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    public Object previous() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    public Object start() {
        this.currentPosition = 0;
        return this.currentElement();
    }

    public Object end() {
        int n = this.nodeList.size();
        if (n > 0) {
            this.currentPosition = n - 1;
            return this.currentElement();
        }
        return null;
    }

    public Object currentElement() {
        if (this.currentPosition < 0 || this.currentPosition >= this.nodeList.size()) {
            return null;
        }
        return this.nodeList.get(this.currentPosition);
    }

    public int elementCount() {
        return this.nodeList.size();
    }

    public boolean equivalent(Object object, Object object2) {
        boolean bl = false;
        String string = null;
        if (!(object instanceof Node) || !(object2 instanceof Node)) {
            string = Resources.getInstance().getString("NOT_NODE_ERROR");
            Debug.log(2, string);
        } else {
            Node node = (Node)object;
            Node node2 = (Node)object2;
            bl = this.compareNode(node, node2);
        }
        return bl;
    }

    public void refresh() {
        this.nodeList = new ArrayList<Node>();
        this.markTree(this.root);
        this.currentPosition = 0;
    }

    protected boolean compareNode(Node node, Node node2) {
        boolean bl = false;
        if (node != null && node2 != null && node.getNodeType() == node2.getNodeType() && node.getNodeName().equals(node2.getNodeName()) && (node.getNodeValue() == null && node2.getNodeValue() == null || node.getNodeValue() != null && node2.getNodeValue() != null && node.getNodeValue().equals(node2.getNodeValue())) && this.attributesEqual(node, node2)) {
            if (!node.hasChildNodes() && !node2.hasChildNodes()) {
                bl = true;
            } else if (!node.hasChildNodes() || !node2.hasChildNodes()) {
                bl = false;
            } else if (this.childrenEqual(node, node2)) {
                bl = true;
            }
        }
        return bl;
    }

    protected boolean childrenEqual(Node node, Node node2) {
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList != null && nodeList2 != null && nodeList.getLength() == nodeList2.getLength()) {
            bl = true;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (this.compareNode(nodeList.item(i), nodeList2.item(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected boolean attributesEqual(Node node, Node node2) {
        boolean bl;
        block8: {
            bl = false;
            String string = node.getNodeName();
            NamedNodeMap[] namedNodeMapArray = new NamedNodeMap[]{node.getAttributes(), node2.getAttributes()};
            if (namedNodeMapArray[0] == null || namedNodeMapArray[1] == null) {
                if (namedNodeMapArray[0] == null && namedNodeMapArray[1] == null) {
                    bl = true;
                }
                return bl;
            }
            int[] nArray = new int[2];
            for (int i = 0; i < 2; ++i) {
                int n;
                int n2;
                if (i == 0) {
                    n2 = 0;
                    n = 1;
                } else {
                    n2 = 1;
                    n = 0;
                }
                nArray[n2] = namedNodeMapArray[n2].getLength();
                for (int j = 0; j < nArray[n2]; ++j) {
                    Node node3 = namedNodeMapArray[n2].item(j);
                    String string2 = node3.getNodeName();
                    if (this.cc_ != null && !this.cc_.canConvertAttribute(string, string2)) continue;
                    Node node4 = namedNodeMapArray[n].getNamedItem(string2);
                    if (node4 == null) {
                        Debug.log(1, "[NodeIterator] Attr not exist in dst - " + string2);
                    } else {
                        if (node3.getNodeValue().equals(node4.getNodeValue())) continue;
                        Debug.log(1, "[NodeIterator] Attr diff src: " + node3.getNodeValue() + " dst: " + node4.getNodeValue());
                    }
                    break block8;
                }
            }
            bl = true;
        }
        return bl;
    }

    protected abstract boolean nodeSupported(Node var1);

    private void markTree(Node node) {
        if (this.nodeSupported(node)) {
            this.nodeList.add(node);
        } else {
            String string = node.getNodeName();
            if (this.cc_ == null || this.cc_.canConvertTag(string)) {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    this.markTree(nodeList.item(i));
                }
            } else {
                Debug.log(1, " [NodeIterator::markTree] Skipping node " + string);
            }
        }
    }
}

