/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web.export;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.web.data.CGArgument;
import com.sun.star.wizards.web.data.CGDocument;
import com.sun.star.wizards.web.data.CGExporter;
import com.sun.star.wizards.web.export.Exporter;

public abstract class AbstractExporter
implements Exporter {
    protected CGExporter exporter;
    protected FileAccess fileAccess;

    protected void storeToURL(Object object, Properties properties, String string, String string2, PropertyValue[] propertyValueArray) throws IOException {
        properties = new Properties();
        properties.put("FilterName", string2);
        if (propertyValueArray.length > 0) {
            properties.put("FilterData", propertyValueArray);
        }
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)object);
        PropertyValue[] propertyValueArray2 = properties.getProperties();
        xStorable.storeToURL(string, propertyValueArray2);
    }

    protected void storeToURL(Object object, String string, String string2, PropertyValue[] propertyValueArray) throws IOException {
        this.storeToURL(object, new Properties(), string, string2, propertyValueArray);
    }

    protected void storeToURL(Object object, String string, String string2) throws IOException {
        this.storeToURL(object, new Properties(), string, string2, new PropertyValue[0]);
    }

    protected String getArgument(String string, CGExporter cGExporter) {
        return ((CGArgument)cGExporter.cp_Arguments.getElement((Object)string)).cp_Value;
    }

    protected Object openDocument(CGDocument cGDocument, XMultiServiceFactory xMultiServiceFactory) throws IOException {
        XComponent xComponent = null;
        try {
            XDesktop xDesktop = Desktop.getDesktop(xMultiServiceFactory);
            Properties properties = new Properties();
            properties.put("Hidden", Boolean.TRUE);
            properties.put("MacroExecutionMode", new Short(0));
            properties.put("UpdateDocMode", new Short(0));
            xComponent = ((XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop)).loadComponentFromURL(cGDocument.cp_URL, "_blank", 0, properties.getProperties());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.pageCount(cGDocument, xComponent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xComponent;
    }

    protected void closeDocument(Object object, XMultiServiceFactory xMultiServiceFactory) {
        try {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)object);
            xCloseable.close(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void pageCount(CGDocument cGDocument, Object object) {
        if (cGDocument.appType.equals("writer")) {
            cGDocument.pages = TextDocument.getPageCount(object);
        } else if (cGDocument.appType.equals("impress")) {
            cGDocument.pages = OfficeDocument.getSlideCount(object);
        } else if (cGDocument.appType.equals("draw")) {
            cGDocument.pages = OfficeDocument.getSlideCount(object);
        }
    }

    public void init(CGExporter cGExporter) {
        this.exporter = cGExporter;
    }

    protected FileAccess getFileAccess(XMultiServiceFactory xMultiServiceFactory) {
        if (this.fileAccess == null) {
            try {
                this.fileAccess = new FileAccess(xMultiServiceFactory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileAccess;
    }

    protected void calcFileSize(CGDocument cGDocument, String string, XMultiServiceFactory xMultiServiceFactory) {
        if (this.exporter.cp_Binary) {
            cGDocument.sizeBytes = this.getFileAccess(xMultiServiceFactory).getSize(string);
        }
    }
}

