/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.QuoteExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.lists.ConstVector;
import gnu.lists.FVector;
import gnu.mapping.InPort;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.Vector;

public class ReaderVector
extends ReadTableEntry {
    char close;

    public ReaderVector(char close) {
        this.close = close;
    }

    @Override
    public Object read(Lexer in, int ch, int count, int sharingIndex) throws IOException, SyntaxException {
        return ReaderVector.readVector((LispReader)in, in.getPort(), count, this.close, sharingIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FVector readVector(LispReader lexer, LineBufferedReader port, int count, char close, int sharingIndex) throws IOException, SyntaxException {
        int saveReadState = 32;
        if (port instanceof InPort) {
            saveReadState = ((InPort)port).readState;
            ((InPort)port).readState = (char)(close == ']' ? 91 : 40);
        }
        try {
            Vector<Object> vec = new Vector<Object>();
            ConstVector result = new ConstVector();
            lexer.bindSharedObject(sharingIndex, result);
            ReadTable rtable = ReadTable.getCurrent();
            block3: while (true) {
                int ch;
                if ((ch = lexer.read()) < 0) {
                    lexer.eofError("unexpected EOF in vector");
                }
                if (ch == close) break;
                Object value = lexer.readValues(ch, rtable, -1);
                if (value instanceof Values) {
                    Object[] values = ((Values)value).getValues();
                    int n = values.length;
                    int i = 0;
                    while (true) {
                        if (i >= n) continue block3;
                        vec.addElement(values[i]);
                        ++i;
                    }
                }
                if (value == QuoteExp.voidExp) {
                    value = Values.empty;
                }
                vec.addElement(value);
            }
            Object[] objs = new Object[vec.size()];
            vec.copyInto(objs);
            result.setDataBackDoor(objs);
            ConstVector constVector = result;
            return constVector;
        }
        finally {
            if (port instanceof InPort) {
                ((InPort)port).readState = (char)saveReadState;
            }
        }
    }
}

