/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1;

import impl.krypt.asn1.TagClass;

public class Tag {
    private int tag;
    private TagClass tc;
    private boolean isConstructed;
    private byte[] encoding;

    public Tag(int tag, TagClass tc, boolean isConstructed) {
        this(tag, tc, isConstructed, null);
    }

    public Tag(int tag, TagClass tc, boolean isConstructed, byte[] encoding) {
        this.tag = tag;
        this.tc = tc;
        this.isConstructed = isConstructed;
        this.encoding = encoding;
    }

    public byte[] getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.computeEncoding();
        }
        return this.encoding;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public void setConstructed(boolean isConstructed) {
        if (isConstructed == this.isConstructed) {
            return;
        }
        this.isConstructed = isConstructed;
        this.encoding = null;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        if (tag == this.tag) {
            return;
        }
        this.tag = tag;
        this.encoding = null;
    }

    public void invalidateEncoding() {
        this.encoding = null;
    }

    public TagClass getTagClass() {
        return this.tc;
    }

    public void setTagClass(TagClass tagClass) {
        if (tagClass == this.tc) {
            return;
        }
        this.tc = tagClass;
        this.encoding = null;
    }

    public boolean hasBeenComputed() {
        return this.encoding != null;
    }

    private byte[] computeEncoding() {
        if (this.tag < 31) {
            byte tagByte = this.isConstructed ? (byte)32 : 0;
            tagByte = (byte)(tagByte | this.tc.getMask());
            tagByte = (byte)(tagByte | (byte)(this.tag & 0xFF));
            return new byte[]{tagByte};
        }
        return this.computeComplexTag();
    }

    private byte[] computeComplexTag() {
        int tagByte = this.isConstructed ? 32 : 0;
        tagByte = (byte)(tagByte | this.tc.getMask());
        tagByte = (byte)(tagByte | 0x1F);
        int numShifts = Tag.determineNumberOfShifts(this.tag, 7);
        byte[] out = new byte[numShifts + 1];
        int tmpTag = this.tag;
        out[0] = tagByte;
        for (int i = numShifts; i > 0; --i) {
            tagByte = (byte)(tmpTag & 0x7F);
            if (i != numShifts) {
                tagByte = (byte)(tagByte | 0xFFFFFF80);
            }
            out[i] = tagByte;
            tmpTag >>= 7;
        }
        return out;
    }

    static int determineNumberOfShifts(int value, int shiftBy) {
        int i = 0;
        while (value > 0) {
            value >>= shiftBy;
            ++i;
        }
        return i;
    }
}

