/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import org.jruby.runtime.profile.Invocation;
import org.jruby.runtime.profile.InvocationSet;
import org.jruby.runtime.profile.MethodData;
import org.jruby.runtime.profile.ProfileData;
import org.jruby.runtime.profile.ProfilePrinter;
import org.jruby.util.collections.IntHashMap;

public class JsonProfilePrinter
extends ProfilePrinter {
    private static Locale JSON_LOCALE = Locale.ROOT;

    public JsonProfilePrinter(ProfileData profileData) {
        super(profileData);
    }

    JsonProfilePrinter(ProfileData profileData, Invocation topInvocation) {
        super(profileData, topInvocation);
    }

    @Override
    public void printHeader(PrintStream out) {
        out.println("{\n\tthread_profiles:[");
    }

    @Override
    public void printFooter(PrintStream out) {
        out.println("\n\t]\n}");
    }

    @Override
    public void printProfile(PrintStream out, boolean first2) {
        Invocation topInvocation = this.getTopInvocation();
        IntHashMap<MethodData> methods2 = JsonProfilePrinter.methodData(topInvocation);
        String threadName = this.getThreadName();
        if (!first2) {
            out.println(",");
        }
        out.println("\t\t{");
        out.printf("\t\t\t\"total_time\":%s,\n", this.nanosToSecondsString(topInvocation.getDuration()));
        out.printf("\t\t\t\"thread_name\":\"%s\",\n", threadName);
        out.println("\t\t\t\"methods\":[");
        Iterator<MethodData> i2 = methods2.values().iterator();
        while (i2.hasNext()) {
            MethodData method2 = i2.next();
            out.print("\t\t\t\t");
            out.print(this.methodToJson(method2));
            if (i2.hasNext()) {
                out.print(",");
            }
            out.println();
        }
        out.print("\t\t\t]\n\t\t}");
    }

    private String methodToJson(MethodData method2) {
        return this.toJsonObject("id", this.quote(method2.serialNumber), "name", this.quote(this.methodName(method2.serialNumber)), "total_calls", String.valueOf(method2.totalCalls()), "total_time", this.nanosToSecondsString(method2.totalTime()), "self_time", this.nanosToSecondsString(method2.selfTime()), "child_time", this.nanosToSecondsString(method2.childTime()), "parents", this.parentCallsToJson(method2), "children", this.childCallsToJson(method2));
    }

    private String parentCallsToJson(MethodData method2) {
        if (method2.serialNumber == 0) {
            return this.toJsonArray(new String[0]);
        }
        int[] parentSerials = method2.parents();
        String[] parentCalls = new String[parentSerials.length];
        for (int i2 = 0; i2 < parentSerials.length; ++i2) {
            parentCalls[i2] = this.callToJson(parentSerials[i2], method2.invocationsFromParent(parentSerials[i2]).totalCalls(), method2.rootInvocationsFromParent(parentSerials[i2]));
        }
        return this.toJsonArray(parentCalls);
    }

    private String childCallsToJson(MethodData method2) {
        int[] childSerials = method2.children();
        String[] childCalls = new String[childSerials.length];
        for (int i2 = 0; i2 < childSerials.length; ++i2) {
            childCalls[i2] = this.callToJson(childSerials[i2], method2.invocationsOfChild(childSerials[i2]).totalCalls(), method2.rootInvocationsOfChild(childSerials[i2]));
        }
        return this.toJsonArray(childCalls);
    }

    private String callToJson(int serial, int calls, InvocationSet invocations) {
        return this.toJsonObject("id", this.quote(serial), "total_calls", String.valueOf(calls), "total_time", this.nanosToSecondsString(invocations.totalTime()), "self_time", this.nanosToSecondsString(invocations.selfTime()), "child_time", this.nanosToSecondsString(invocations.childTime()));
    }

    private String nanosToSecondsString(long nanos) {
        return String.format(JSON_LOCALE, "%f", (double)nanos / 1.0E9);
    }

    private String quote(String str) {
        return String.format("\"%s\"", str);
    }

    private String quote(int num) {
        return String.format("\"%d\"", num);
    }

    private String quote(long num) {
        return String.format("\"%d\"", num);
    }

    private String toJsonArray(String ... values2) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (String v : values2) {
            buffer.append(v);
            if (v == values2[values2.length - 1]) continue;
            buffer.append(",");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String toJsonObject(String ... keysAndValues) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i2 = 0; i2 < keysAndValues.length; i2 += 2) {
            buffer.append(this.quote(keysAndValues[i2]));
            buffer.append(":");
            buffer.append(keysAndValues[i2 + 1]);
            if (i2 >= keysAndValues.length - 3) continue;
            buffer.append(",");
        }
        buffer.append("}");
        return buffer.toString();
    }
}

