/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SearchConstInstr
extends Instr
implements ResultInstr {
    private Operand startingScope;
    private String constName;
    private boolean noPrivateConsts;
    private Variable result;
    private volatile transient Object cachedConstant = null;
    private Object generation = -1;

    public SearchConstInstr(Variable result2, String constName, Operand startingScope, boolean noPrivateConsts) {
        super(Operation.SEARCH_CONST);
        assert (result2 != null) : "SearchConstInstr result is null";
        this.result = result2;
        this.constName = constName;
        this.startingScope = startingScope;
        this.noPrivateConsts = noPrivateConsts;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.startingScope};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.startingScope = this.startingScope.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new SearchConstInstr(ii.getRenamedVariable(this.result), this.constName, this.startingScope.cloneForInlining(ii), this.noPrivateConsts);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.constName + ", " + this.startingScope + ", no-private-consts=" + this.noPrivateConsts + ")";
    }

    private Object cache(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Ruby runtime) {
        RubyClass object = runtime.getObject();
        StaticScope staticScope = (StaticScope)this.startingScope.retrieve(context, self2, currDynScope, temp);
        IRubyObject constant = staticScope == null ? object.getConstant(this.constName) : staticScope.getConstantInner(this.constName);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = this.noPrivateConsts ? module.getConstantFromNoConstMissing(this.constName, false) : module.getConstantNoConstMissing(this.constName);
        }
        if (constant == null) {
            constant = module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(this.constName));
        } else {
            this.generation = runtime.getConstantInvalidator().getData();
            this.cachedConstant = constant;
        }
        return constant;
    }

    private boolean isCached(Ruby runtime, Object value2) {
        return value2 != null && this.generation == runtime.getConstantInvalidator().getData();
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        Ruby runtime = context.runtime;
        Object constant = this.cachedConstant;
        if (!this.isCached(runtime, constant)) {
            constant = this.cache(context, currDynScope, self2, temp, runtime);
        }
        return constant;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SearchConstInstr(this);
    }

    public Operand getStartingScope() {
        return this.startingScope;
    }

    public String getConstName() {
        return this.constName;
    }

    public boolean isNoPrivateConsts() {
        return this.noPrivateConsts;
    }
}

